/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;
import weblogic.transaction.internal.XidImpl;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.WSATConstants;
import weblogic.wsee.wstx.wsat.WSATHelper;

public class WSATXAResource
implements WSATConstants,
XAResource,
Serializable {
    static final long serialVersionUID = -5827137400010343968L;
    private Xid m_xid;
    static final String ACTIVE = "ACTIVE";
    private volatile String m_status = "ACTIVE";
    private Transactional.Version m_version;
    private boolean m_isRemovedFromMap = false;
    private transient EndpointReference m_epr;

    public WSATXAResource(EndpointReference endpointReference, Xid xid) {
        this(Transactional.Version.WSAT10, endpointReference, xid, false);
    }

    public WSATXAResource(Transactional.Version version2, EndpointReference endpointReference, Xid xid) {
        this(version2, endpointReference, xid, false);
    }

    public WSATXAResource(Transactional.Version version2, EndpointReference endpointReference, Xid xid, boolean bl) {
        this.m_version = version2;
        if (endpointReference == null) {
            throw new IllegalArgumentException("endpoint reference can't be null");
        }
        this.m_epr = endpointReference;
        this.m_xid = xid;
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWSATXAResource((String)this.m_epr.toString(), (Object)this.m_xid, (String)"");
        }
        if (bl) {
            this.m_status = "Prepared";
        }
    }

    WSATHelper getWSATHelper() {
        return WSATHelper.getInstance(this.m_version);
    }

    public void setStatus(String string) {
        this.m_status = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logPrepare((String)this.m_epr.toString(), (Object)this.m_xid);
        }
        this.getWSATHelper().prepare(this.m_epr, this.m_xid, this);
        try {
            WSATXAResource wSATXAResource = this;
            synchronized (wSATXAResource) {
                if (this.m_status.equals("ReadOnly")) {
                    return 3;
                }
                if (this.m_status.equals("Prepared")) {
                    if (WSATHelper.isDebugEnabled()) {
                        WseeWsatLogger.logPreparedBeforeWait((String)this.m_epr.toString(), (Object)this.m_xid);
                    }
                    return 0;
                }
                if (this.m_status.equals("Aborted")) {
                    throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", 100);
                }
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logPrepareWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                }
                this.wait(this.getWaitForReplyTimeout());
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logPrepareFinishedWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                }
            }
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logPrepareReceivedReplyStatus((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
            }
            if (this.m_status.equals("ReadOnly")) {
                this.logSuccess("preparereadonly");
                return 3;
            }
            if (this.m_status.equals("Prepared")) {
                this.logSuccess("prepareprepared");
                return 0;
            }
            if (this.m_status.equals("Aborted")) {
                throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", 100);
            }
            WseeWsatLogger.logFailedStateForPrepare((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
            throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", -7);
        }
        catch (InterruptedException interruptedException) {
            WseeWsatLogger.logInterruptedExceptionDuringPrepare((Exception)interruptedException, (String)this.m_epr.toString(), (Object)this.m_xid);
            XAException xAException = new XAException("InterruptedException during WS-AT XAResource prepare");
            xAException.errorCode = -7;
            xAException.initCause(interruptedException);
            throw xAException;
        }
    }

    private XAException newFailedStateXAExceptionForMethodNameAndErrorcode(String string, int n) {
        XAException xAException = new XAException("Failed state during " + string + " of WS-AT XAResource:" + this);
        xAException.errorCode = n;
        return xAException;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            this.getWSATHelper().removeDurableParticipant(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        block18: {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logCommit((String)this.m_epr.toString(), (Object)this.m_xid);
            }
            this.getWSATHelper().commit(this.m_epr, this.m_xid, this);
            try {
                Serializable serializable = this;
                synchronized (serializable) {
                    block17: {
                        if (!this.m_status.equals("Committed")) break block17;
                        if (WSATHelper.isDebugEnabled()) {
                            WseeWsatLogger.logCommitBeforeWait((String)this.m_epr.toString(), (Object)this.m_xid);
                        }
                        this.getWSATHelper().removeDurableParticipant(this);
                        this.m_isRemovedFromMap = true;
                        return;
                    }
                    if (WSATHelper.isDebugEnabled()) {
                        WseeWsatLogger.logCommitWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                    }
                    this.wait(this.getWaitForReplyTimeout());
                    if (WSATHelper.isDebugEnabled()) {
                        WseeWsatLogger.logCommitFinishedWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                    }
                }
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logCommitReceivedReplyStatus((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                }
                if (this.m_status.equals("Committed")) {
                    this.logSuccess("preparecommitted");
                    this.getWSATHelper().removeDurableParticipant(this);
                    this.m_isRemovedFromMap = true;
                    break block18;
                }
                if (this.m_status.equals("Prepared")) {
                    WseeWsatLogger.logFailedStateForCommit((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                    serializable = this.newFailedStateXAExceptionForMethodNameAndErrorcode("commit", -7);
                    this.log("Failed state during WS-AT XAResource commit:" + this.m_status);
                    throw serializable;
                }
                WseeWsatLogger.logFailedStateForCommit((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                serializable = this.newFailedStateXAExceptionForMethodNameAndErrorcode("commit", -6);
                this.log("Failed state during WS-AT XAResource commit:" + this.m_status);
                throw serializable;
            }
            catch (InterruptedException interruptedException) {
                WseeWsatLogger.logInterruptedExceptionDuringCommit((Exception)interruptedException, (String)this.m_epr.toString(), (Object)this.m_xid);
                XAException xAException = new XAException("InterruptedException during WS-AT XAResource commit:" + interruptedException);
                xAException.errorCode = -7;
                xAException.initCause(interruptedException);
                throw xAException;
            }
            finally {
                this.getWSATHelper().removeDurableParticipant(this);
            }
        }
    }

    int getWaitForReplyTimeout() {
        return this.getWSATHelper().getWaitForReplyTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        block18: {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logRollback((String)this.m_epr.toString(), (Object)this.m_xid);
            }
            this.getWSATHelper().rollback(this.m_epr, this.m_xid, this);
            try {
                WSATXAResource wSATXAResource = this;
                synchronized (wSATXAResource) {
                    block17: {
                        if (!this.m_status.equals("Aborted")) break block17;
                        if (WSATHelper.isDebugEnabled()) {
                            WseeWsatLogger.logRollbackBeforeWait((String)this.m_epr.toString(), (Object)this.m_xid);
                        }
                        this.getWSATHelper().removeDurableParticipant(this);
                        this.m_isRemovedFromMap = true;
                        return;
                    }
                    if (WSATHelper.isDebugEnabled()) {
                        WseeWsatLogger.logRollbackWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                    }
                    this.wait(this.getWaitForReplyTimeout());
                    if (WSATHelper.isDebugEnabled()) {
                        WseeWsatLogger.logRollbackFinishedWaitingForReply((String)this.m_epr.toString(), (Object)this.m_xid);
                    }
                }
                if (WSATHelper.isDebugEnabled()) {
                    WseeWsatLogger.logRollbackReceivedReplyStatus((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                }
                if (this.m_status.equals("Aborted")) {
                    this.logSuccess("rollbackaborted");
                    this.getWSATHelper().removeDurableParticipant(this);
                    this.m_isRemovedFromMap = true;
                    break block18;
                }
                if (this.m_status.equals("Prepared")) {
                    WseeWsatLogger.logFailedStateForRollback((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                    throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("rollback", -7);
                }
                WseeWsatLogger.logFailedStateForRollback((String)this.m_status, (String)this.m_epr.toString(), (Object)this.m_xid);
                throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("rollback", -7);
            }
            catch (InterruptedException interruptedException) {
                WseeWsatLogger.logInterruptedExceptionDuringRollback((Exception)interruptedException, (String)this.m_epr.toString(), (Object)this.m_xid);
                XAException xAException = new XAException("InterruptedException during WS-AT XAResource rollback");
                xAException.errorCode = -7;
                xAException.initCause(interruptedException);
                throw xAException;
            }
            finally {
                this.getWSATHelper().removeDurableParticipant(this);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return true;
    }

    public void start(Xid xid, int n) throws XAException {
    }

    public void end(Xid xid, int n) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return Integer.MAX_VALUE;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return false;
    }

    public Xid[] recover(int n) throws XAException {
        return new Xid[0];
    }

    public Xid getXid() {
        return this.m_xid;
    }

    public void setBranchQualifier(byte[] byArray) {
        this.m_xid = new XidImpl(this.m_xid.getFormatId(), this.m_xid.getGlobalTransactionId(), byArray);
    }

    public boolean equals(Object object) {
        return object instanceof WSATXAResource && ((WSATXAResource)object).getXid().equals(this.m_xid) && ((WSATXAResource)object).m_epr.toString().equals(this.m_epr.toString());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.m_epr.writeTo((Result)new StreamResult(byteArrayOutputStream));
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.m_epr = EndpointReference.readFrom((Source)new StreamSource(new ByteArrayInputStream(byArray)));
    }

    private void log(String string) {
        WseeWsatLogger.logWSATXAResourceInfo((String)string);
    }

    private void logSuccess(String string) {
        WSATHelper.getInstance().debug("success state during " + string + " of WS-AT XAResource:" + this);
    }

    public String toString() {
        return "WSATXAResource: xid" + this.m_xid + " status:" + this.m_status + " epr:" + this.m_epr + " isRemovedFromMap:" + this.m_isRemovedFromMap;
    }
}

