/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.common;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import javax.xml.ws.WebServiceFeature;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.common.NotificationBuilder;
import weblogic.wsee.wstx.wsat.common.WSATVersion10;
import weblogic.wsee.wstx.wsat.common.WSATVersion11;
import weblogic.wsee.wstx.wsat.common.client.CoordinatorProxyBuilder;
import weblogic.wsee.wstx.wsat.common.client.ParticipantProxyBuilder;
import weblogic.wsee.wstx.wsat.v11.types.Notification;
import weblogic.wsee.wstx.wsc.common.EndpointReferenceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSATVersion<T> {
    public static final WSATVersion<weblogic.wsee.wstx.wsat.v10.types.Notification> v10 = new WSATVersion10();
    public static final WSATVersion<Notification> v11 = new WSATVersion11();
    private Transactional.Version version;
    protected AddressingVersion addressingVersion;
    protected SOAPVersion soapVersion;

    public static WSATVersion getInstance(Transactional.Version version2) {
        if (Transactional.Version.WSAT10 == version2 || Transactional.Version.DEFAULT == version2) {
            return v10;
        }
        if (Transactional.Version.WSAT11 == version2 || Transactional.Version.WSAT12 == version2) {
            return v11;
        }
        throw new IllegalArgumentException(version2 + "is not a supported ws-at version");
    }

    WSATVersion(Transactional.Version version2) {
        this.version = version2;
    }

    public abstract WSATHelper getWSATHelper();

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public SOAPVersion getSOPAVersion() {
        return this.soapVersion;
    }

    public Transactional.Version getVersion() {
        return this.version;
    }

    public abstract CoordinatorProxyBuilder<T> newCoordinatorProxyBuilder();

    public abstract ParticipantProxyBuilder<T> newParticipantProxyBuilder();

    public abstract NotificationBuilder<T> newNotificationBuilder();

    public abstract EndpointReferenceBuilder newEndpointReferenceBuilder();

    public abstract WebServiceFeature newAddressingFeature();
}

