/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.common.client;

import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import weblogic.wsee.wstx.wsat.common.WSATVersion;
import weblogic.wsee.wstx.wsc.common.WSCUtil;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProxyBuilder<T, B extends BaseProxyBuilder<T, B>> {
    protected WSATVersion<T> version;
    protected EndpointReference to;
    protected EndpointReference replyTo;
    protected List<WebServiceFeature> features;
    protected List<CredentialProvider> credentialProviders;

    protected BaseProxyBuilder(WSATVersion<T> wSATVersion) {
        this.version = wSATVersion;
        this.feature(wSATVersion.newAddressingFeature());
    }

    public B feature(WebServiceFeature webServiceFeature) {
        if (webServiceFeature == null) {
            return (B)this;
        }
        if (this.features == null) {
            this.features = new ArrayList<WebServiceFeature>();
        }
        this.features.add(webServiceFeature);
        return (B)this;
    }

    public B to(EndpointReference endpointReference) {
        this.to = endpointReference;
        return (B)this;
    }

    public B replyTo(EndpointReference endpointReference) {
        this.replyTo = endpointReference;
        if (endpointReference != null) {
            this.feature((WebServiceFeature)new OneWayFeature(true, WSEndpointReference.create((EndpointReference)endpointReference)));
        }
        return (B)this;
    }

    public B txIdForReference(String string, String string2) {
        Object t = this.version.newEndpointReferenceBuilder().address(this.getDefaultCallbackAddress()).referenceParameter(WSCUtil.referenceElementTxId(string), WSCUtil.referenceElementBranchQual(string2), WSCUtil.referenceElementRoutingInfo()).build();
        this.replyTo((EndpointReference)t);
        return (B)this;
    }

    public B credentialProvider(CredentialProvider credentialProvider) {
        if (credentialProvider == null) {
            return (B)this;
        }
        if (this.credentialProviders == null) {
            this.credentialProviders = new ArrayList<CredentialProvider>();
        }
        this.credentialProviders.add(credentialProvider);
        return (B)this;
    }

    protected WebServiceFeature[] getEnabledFeatures() {
        return this.features.toArray(new WebServiceFeature[0]);
    }

    protected abstract String getDefaultCallbackAddress();
}

