/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.common.endpoint;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import javax.annotation.Resource;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import weblogic.transaction.WLXid;
import weblogic.transaction.internal.XidImpl;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.TransactionServices;
import weblogic.wsee.wstx.wsat.WSATException;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.WSATXAResource;
import weblogic.wsee.wstx.wsat.common.CoordinatorIF;
import weblogic.wsee.wstx.wsat.common.WSATVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinator<T>
implements CoordinatorIF<T> {
    @Resource
    private WebServiceContext m_context;
    private WSATVersion<T> m_version;

    public Coordinator(WebServiceContext webServiceContext, WSATVersion<T> wSATVersion) {
        this.m_context = webServiceContext;
        this.m_version = wSATVersion;
    }

    @Override
    public void preparedOperation(T t) {
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logPreparedOperationEntered(t);
        }
        Xid xid = this.getXid();
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logPreparedOperation((Object)xid);
        }
        if (!this.getWSATHelper().setDurableParticipantStatus(xid, "Prepared")) {
            this.replayOperation(t);
        }
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logPreparedOperationExited(t);
        }
    }

    @Override
    public void abortedOperation(T t) {
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logAbortedOperationEntered(t);
        }
        Xid xid = this.getXid();
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logAbortedOperation((Object)xid);
        }
        this.getWSATHelper().setDurableParticipantStatus(xid, "Aborted");
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logAbortedOperationExited(t);
        }
    }

    @Override
    public void readOnlyOperation(T t) {
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logReadOnlyOperationEntered(t);
        }
        Xid xid = this.getXid();
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logReadOnlyOperation((Object)xid);
        }
        this.getWSATHelper().setDurableParticipantStatus(xid, "ReadOnly");
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logReadOnlyOperationExited(t);
        }
    }

    @Override
    public void committedOperation(T t) {
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logCommittedOperationEntered(t);
        }
        Xid xid = this.getXid();
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logCommittedOperation((Object)xid);
        }
        this.getWSATHelper().setDurableParticipantStatus(xid, "Committed");
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logCommittedOperationExited(t);
        }
    }

    @Override
    public void replayOperation(T t) {
        block5: {
            if (this.isDebugEnabled()) {
                WseeWsatLogger.logReplayOperationEntered(t);
            }
            Xid xid = this.getXid();
            String string = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context);
            if (this.isDebugEnabled()) {
                WseeWsatLogger.logReplayOperation((Object)xid);
            }
            try {
                this.getTransactionServices().replayCompletion(string, this.createWSATXAResourceForXidFromReplyTo(xid));
            }
            catch (WSATException wSATException) {
                if (!this.isDebugEnabled()) break block5;
                WseeWsatLogger.logReplayOperationSOAPException((Object)xid, (Exception)wSATException);
            }
        }
        if (this.isDebugEnabled()) {
            WseeWsatLogger.logAbortedOperationExited(t);
        }
    }

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }

    WSATXAResource createWSATXAResourceForXidFromReplyTo(Xid xid) {
        HeaderList headerList = (HeaderList)this.m_context.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        WSEndpointReference wSEndpointReference = headerList.getReplyTo(AddressingVersion.W3C, SOAPVersion.SOAP_12);
        EndpointReference endpointReference = wSEndpointReference.toSpec();
        return new WSATXAResource(this.m_version.getVersion(), endpointReference, xid, true);
    }

    Xid getXid() {
        WLXid wLXid = this.getWSATHelper().getXidFromWebServiceContextHeaderList(this.m_context);
        String string = this.getWSATHelper().getBQualFromWebServiceContextHeaderList(this.m_context);
        return new XidImpl(wLXid.getFormatId(), wLXid.getGlobalTransactionId(), string.getBytes());
    }

    boolean isDebugEnabled() {
        return WSATHelper.isDebugEnabled();
    }

    protected WSATHelper getWSATHelper() {
        return this.m_version.getWSATHelper();
    }
}

