/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.common.endpoint;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import javax.transaction.xa.Xid;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import weblogic.transaction.WLXid;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.TransactionServices;
import weblogic.wsee.wstx.wsat.WSATException;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.common.CoordinatorIF;
import weblogic.wsee.wstx.wsat.common.ParticipantIF;
import weblogic.wsee.wstx.wsat.common.WSATVersion;
import weblogic.wsee.wstx.wsat.common.client.CoordinatorProxyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Participant<T>
implements ParticipantIF<T> {
    private WebServiceContext m_context;
    private WSATVersion<T> m_version;

    public Participant(WebServiceContext webServiceContext, WSATVersion<T> wSATVersion) {
        this.m_context = webServiceContext;
        this.m_version = wSATVersion;
    }

    @Override
    public void prepare(T t) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare enter:" + t);
        }
        CoordinatorIF<T> coordinatorIF = null;
        byte[] byArray = null;
        try {
            byArray = this.getWSATTid();
            coordinatorIF = this.getCoordinatorPortType();
            String string = this.getTransactionaService().prepare(byArray);
            if (WSATHelper.isDebugEnabled()) {
                this.debug("preparedOperation complete vote:" + string + " for tid:" + this.stringForTidByteArray(byArray));
            }
            if (string.equals("ReadOnly")) {
                coordinatorIF.readOnlyOperation(this.createNotification());
            } else if (string.equals("Prepared")) {
                coordinatorIF.preparedOperation(this.createNotification());
            }
        }
        catch (Exception exception) {
            this.log("prepare resulted in exception, sending aborted for tid:" + this.stringForTidByteArray(byArray) + " " + exception);
            if (coordinatorIF != null) {
                coordinatorIF.abortedOperation(this.createNotification());
            }
            this.log("prepare resulted in exception, unable to send abort as coordinatorPort was nullfor tid:" + this.stringForTidByteArray(byArray) + " " + exception);
            throw new WebServiceException("coordinator port null during prepare");
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare exit:" + t + " for tid:" + this.stringForTidByteArray(byArray));
        }
    }

    @Override
    public void commit(T t) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit enter:" + t);
        }
        CoordinatorIF<T> coordinatorIF = null;
        boolean bl = false;
        byte[] byArray = null;
        Exception exception = null;
        try {
            byArray = this.getWSATTid();
            coordinatorIF = this.getCoordinatorPortTypeForReplyTo();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort:" + coordinatorIF + " for tid:" + this.stringForTidByteArray(byArray));
            }
            if (this.isInForeignContextMap()) {
                this.getTransactionaService().commit(byArray);
            }
            bl = true;
            if (WSATHelper.isDebugEnabled()) {
                this.debug("committedOperation complete for tid:" + this.stringForTidByteArray(byArray));
            }
        }
        catch (WSATException wSATException) {
            exception = wSATException;
            this.log("WSATException during commit for tid:" + this.stringForTidByteArray(byArray) + " " + wSATException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
            this.log("IllegalArgumentException during commit for tid:" + this.stringForTidByteArray(byArray) + " " + illegalArgumentException);
        }
        if (coordinatorIF == null) {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort null, about to create from replyto for tid:" + this.stringForTidByteArray(byArray) + " ");
            }
            coordinatorIF = this.getCoordinatorPortType();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort null attempting to create from replyto coordinatorPort:" + coordinatorIF + "for tid:" + this.stringForTidByteArray(byArray));
            }
            if (coordinatorIF == null) {
                throw new WebServiceException("WS-AT coordinator port null during commit for transaction id:" + this.stringForTidByteArray(byArray));
            }
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort obtained from replyto:" + coordinatorIF + "for tid:" + this.stringForTidByteArray(byArray));
            }
        }
        if (!bl && WSATHelper.isDebugEnabled()) {
            this.debug("Participant.commit was not successful, presuming previous completion occurred and sending committed for tid:" + this.stringForTidByteArray(byArray) + " Exception:" + exception);
        }
        coordinatorIF.committedOperation(this.createNotification());
        if (WSATHelper.isDebugEnabled()) {
            this.debug("committed reply sent, local commit success is " + bl + " , coordinatorPort:" + coordinatorIF + " for tid:" + this.stringForTidByteArray(byArray));
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit exit:" + t + " for tid:" + this.stringForTidByteArray(byArray));
        }
    }

    @Override
    public void rollback(T t) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("rollback parameters:" + t);
        }
        CoordinatorIF<T> coordinatorIF = null;
        byte[] byArray = null;
        try {
            byArray = this.getWSATTid();
            coordinatorIF = this.getCoordinatorPortTypeForReplyTo();
            if (this.isInForeignContextMap()) {
                this.getTransactionaService().rollback(byArray);
            }
            if (WSATHelper.isDebugEnabled()) {
                this.debug("rollback abortedOperation complete for tid:" + this.stringForTidByteArray(byArray));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log("rollback IllegalArgumentException for tid:" + this.stringForTidByteArray(byArray) + " " + illegalArgumentException);
        }
        catch (WSATException wSATException) {
            this.log("rollback WSATException for tid:" + this.stringForTidByteArray(byArray) + " " + wSATException);
            throw new WebServiceException("Participant.rollback WSATException for tid:" + this.stringForTidByteArray(byArray) + " " + wSATException);
        }
        if (coordinatorIF != null) {
            coordinatorIF.abortedOperation(this.createNotification());
        } else {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.rollback coordinatorPort null attempting to create from replyto for tid:" + this.stringForTidByteArray(byArray));
            }
            coordinatorIF = this.getCoordinatorPortType();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.rollback coordinatorPort null attempting to create from replyto for tid:" + this.stringForTidByteArray(byArray) + " coordinatorPort:" + coordinatorIF);
            }
            if (coordinatorIF != null) {
                coordinatorIF.abortedOperation(this.createNotification());
            } else {
                this.log("Coordinator port null during rollback for tid:" + this.stringForTidByteArray(byArray) + " about to throw exception/fault.");
                throw new WebServiceException("WS-AT Coordinator port null during rollback for tid:" + this.stringForTidByteArray(byArray));
            }
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("rollback exit:" + t + " for tid:" + this.stringForTidByteArray(byArray));
        }
    }

    CoordinatorIF<T> getCoordinatorPortTypeForReplyTo() {
        EndpointReference endpointReference;
        AddressingVersion addressingVersion;
        HeaderList headerList = (HeaderList)this.m_context.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        WSEndpointReference wSEndpointReference = headerList.getReplyTo(addressingVersion = this.m_version.getAddressingVersion(), this.m_version.getSOPAVersion());
        if (wSEndpointReference != null && !wSEndpointReference.isNone() && wSEndpointReference.isAnonymous() && (endpointReference = headerList.get(addressingVersion.fromTag, true)) != null) {
            try {
                wSEndpointReference = endpointReference.readAsEPR(addressingVersion);
            }
            catch (XMLStreamException xMLStreamException) {
                this.log("XMLStreamException while reading ReplyTo EndpointReference:" + xMLStreamException);
            }
        }
        if (wSEndpointReference == null || wSEndpointReference.isNone() || wSEndpointReference.isAnonymous()) {
            return null;
        }
        endpointReference = wSEndpointReference.toSpec();
        CoordinatorProxyBuilder coordinatorProxyBuilder = (CoordinatorProxyBuilder)this.m_version.newCoordinatorProxyBuilder().to(endpointReference);
        CoordinatorIF coordinatorIF = coordinatorProxyBuilder.build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("getCoordinatorPortType replytocoordinatorPort:" + coordinatorIF + "for wsReplyTo/from:" + wSEndpointReference + " and replyTo/from:" + endpointReference);
        }
        return coordinatorIF;
    }

    TransactionServices getTransactionaService() {
        return WSATHelper.getTransactionServices();
    }

    byte[] getWSATTid() {
        byte[] byArray = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context).replace("urn:", "").replace("uuid:", "").getBytes();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("getWSATTid tid:" + this.stringForTidByteArray(byArray));
        }
        return byArray;
    }

    CoordinatorIF<T> getCoordinatorPortType() {
        String string = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context);
        WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(string);
        EndpointReference endpointReference = this.getTransactionaService().getParentReference((Xid)wLXid);
        CoordinatorProxyBuilder coordinatorProxyBuilder = (CoordinatorProxyBuilder)this.m_version.newCoordinatorProxyBuilder().to(endpointReference);
        CoordinatorIF coordinatorIF = coordinatorProxyBuilder.build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("getCoordinatorPortType coordinatorPort:" + coordinatorIF + "for txid:" + string + " xid:" + wLXid + " parentRef:" + endpointReference);
        }
        return coordinatorIF;
    }

    boolean isInForeignContextMap() {
        try {
            String string = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context);
            WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(string);
            this.getTransactionaService().getParentReference((Xid)wLXid);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private String stringForTidByteArray(byte[] byArray) {
        return byArray == null ? null : new String(byArray);
    }

    protected T createNotification() {
        return this.m_version.newNotificationBuilder().build();
    }

    protected WSATHelper getWSATHelper() {
        return this.m_version.getWSATHelper();
    }

    private void log(String string) {
        WseeWsatLogger.logWSATParticipant((Object)string);
    }

    private void debug(String string) {
        WSATHelper.getInstance().debug("Participant:" + string);
    }
}

