/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.config;

import com.sun.xml.ws.binding.WebServiceFeatureList;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.OperationComponentBean;
import weblogic.j2ee.descriptor.wl.OperationInfoBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.WSATConfigBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.wsee.jws.VisitableJWS;
import weblogic.wsee.jws.VisitableJWSBuilder;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.config.WSATBeanVisitor;

public class DDHelper {
    static final String NEVER = Transactional.TransactionFlowType.NEVER.toString();

    public static void updateFeatureFromServiceDD(TransactionalFeature transactionalFeature, PortComponentBean portComponentBean) {
        OperationComponentBean[] operationComponentBeanArray;
        if (transactionalFeature == null) {
            throw new IllegalArgumentException("TransactionalFeature can't be null");
        }
        if (portComponentBean == null) {
            return;
        }
        WSATConfigBean wSATConfigBean = portComponentBean.getWSATConfig();
        DDHelper.updateFeatureFromPortLevelConfig(transactionalFeature, wSATConfigBean);
        for (OperationComponentBean operationComponentBean : operationComponentBeanArray = portComponentBean.getOperations()) {
            WSATConfigBean wSATConfigBean2 = operationComponentBean.getWSATConfig();
            if (wSATConfigBean2 == null) {
                wSATConfigBean2 = wSATConfigBean;
            }
            String string = operationComponentBean.getName();
            DDHelper.updateFeatureFromOperationLevelConfig(transactionalFeature, wSATConfigBean2, string);
        }
    }

    private static void updateFeatureFromPortLevelConfig(TransactionalFeature transactionalFeature, WSATConfigBean wSATConfigBean) {
        if (wSATConfigBean == null) {
            transactionalFeature.setExplicitMode(true);
            transactionalFeature.setVersion(null);
            return;
        }
        transactionalFeature.setEnabled(wSATConfigBean.isEnabled());
        transactionalFeature.setFlowType(Transactional.TransactionFlowType.valueOf((String)wSATConfigBean.getFlowType()));
        transactionalFeature.setVersion(Transactional.Version.valueOf((String)wSATConfigBean.getVersion()));
    }

    private static void updateFeatureFromOperationLevelConfig(TransactionalFeature transactionalFeature, WSATConfigBean wSATConfigBean, String string) {
        boolean bl;
        if (wSATConfigBean == null) {
            return;
        }
        transactionalFeature.setEnabled(string, wSATConfigBean.isEnabled());
        Transactional.TransactionFlowType transactionFlowType = Transactional.TransactionFlowType.valueOf((String)wSATConfigBean.getFlowType());
        transactionalFeature.setFlowType(string, transactionFlowType);
        Transactional.Version version2 = Transactional.Version.valueOf((String)wSATConfigBean.getVersion());
        boolean bl2 = bl = wSATConfigBean.isEnabled() && transactionFlowType != Transactional.TransactionFlowType.NEVER;
        if (!bl) {
            return;
        }
        if (transactionalFeature.isExplicitMode() && bl) {
            transactionalFeature.setEnabled(true);
            if (transactionalFeature.getVersion() == null) {
                transactionalFeature.setVersion(version2);
            }
        }
        if (version2 != transactionalFeature.getVersion()) {
            if (transactionalFeature.isExplicitMode()) {
                throw new WebServiceException("WS-AT version on operation(" + version2 + ") '" + string + "' is different from the one on other operations!");
            }
            if (version2 != Transactional.Version.DEFAULT) {
                throw new WebServiceException("WS-AT version(" + version2 + ")  on operation '" + string + "' is different from the one(" + transactionalFeature.getVersion() + ") on port!");
            }
        }
    }

    public static TransactionalFeature buildFeatureFromServiceDD(PortComponentBean portComponentBean) {
        TransactionalFeature transactionalFeature = null;
        if (portComponentBean != null) {
            if (!DDHelper.isEffectivelyEnabled(portComponentBean.getWSATConfig())) {
                OperationComponentBean[] operationComponentBeanArray = portComponentBean.getOperations();
                for (int i = 0; i < operationComponentBeanArray.length; ++i) {
                    OperationComponentBean operationComponentBean = operationComponentBeanArray[i];
                    if (!DDHelper.isEffectivelyEnabled(operationComponentBean.getWSATConfig())) continue;
                    transactionalFeature = new TransactionalFeature();
                    transactionalFeature.setExplicitMode(true);
                    break;
                }
            } else {
                transactionalFeature = new TransactionalFeature();
            }
        }
        if (transactionalFeature != null) {
            DDHelper.updateFeatureFromServiceDD(transactionalFeature, portComponentBean);
        }
        return transactionalFeature;
    }

    public static TransactionalFeature buildFeatureFromServiceRefDD(PortInfoBean portInfoBean) {
        OperationInfoBean[] operationInfoBeanArray;
        if (portInfoBean == null) {
            return null;
        }
        WSATConfigBean wSATConfigBean = portInfoBean.getWSATConfig();
        TransactionalFeature transactionalFeature = null;
        if (wSATConfigBean != null) {
            transactionalFeature = new TransactionalFeature();
            DDHelper.updateFeatureFromPortLevelConfig(transactionalFeature, wSATConfigBean);
        }
        for (OperationInfoBean operationInfoBean : operationInfoBeanArray = portInfoBean.getOperations()) {
            WSATConfigBean wSATConfigBean2 = operationInfoBean.getWSATConfig();
            if (wSATConfigBean2 == null) continue;
            if (transactionalFeature == null) {
                transactionalFeature = new TransactionalFeature();
            }
            String string = operationInfoBean.getName();
            DDHelper.updateFeatureFromOperationLevelConfig(transactionalFeature, wSATConfigBean2, string);
        }
        return transactionalFeature;
    }

    public static void populateServiceDDFromJWS(Class clazz, Class clazz2, PortComponentBean portComponentBean) {
        DDHelper.populateServiceDDFromJWS(clazz, clazz2, portComponentBean, false);
    }

    public static void populateServiceDDFromJWS(Class clazz, Class clazz2, PortComponentBean portComponentBean, boolean bl) {
        VisitableJWS visitableJWS = VisitableJWSBuilder.jaxws().impl(clazz2).sei(clazz).build();
        visitableJWS.accept(new WSATBeanVisitor(portComponentBean, bl));
    }

    public static void populateServiceRefDDFromAnnotation(Transactional transactional, PortInfoBean portInfoBean) {
        if (transactional == null) {
            return;
        }
        if (portInfoBean == null) {
            throw new IllegalArgumentException("portInfoBean can't be null");
        }
        if (portInfoBean.getWSATConfig() != null) {
            return;
        }
        WSATConfigBean wSATConfigBean = portInfoBean.createWSATConfig();
        wSATConfigBean.setEnabled(transactional.enabled());
        wSATConfigBean.setVersion(transactional.version().toString());
        wSATConfigBean.setFlowType(transactional.value().toString());
    }

    public static TransactionalFeature buildFeatureFromAnnotation(Transactional transactional) {
        TransactionalFeature transactionalFeature = new TransactionalFeature();
        transactionalFeature.setEnabled(transactional.enabled());
        transactionalFeature.setVersion(transactional.version());
        transactionalFeature.setFlowType(transactional.value());
        return transactionalFeature;
    }

    public static void updateFeatureFromJWS(Class clazz, Class clazz2, WebServiceFeatureList webServiceFeatureList) {
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        WeblogicWebservicesBean weblogicWebservicesBean = (WeblogicWebservicesBean)editableDescriptorManager.createDescriptorRoot(WeblogicWebservicesBean.class).getRootBean();
        weblogicWebservicesBean.setVersion("1.2");
        PortComponentBean portComponentBean = weblogicWebservicesBean.createWebserviceDescription().createPortComponent();
        DDHelper.populateServiceDDFromJWS(clazz, clazz2, portComponentBean, true);
        TransactionalFeature transactionalFeature = (TransactionalFeature)webServiceFeatureList.get(TransactionalFeature.class);
        if (transactionalFeature == null) {
            transactionalFeature = DDHelper.buildFeatureFromServiceDD(portComponentBean);
            if (transactionalFeature != null) {
                webServiceFeatureList.add((WebServiceFeature)transactionalFeature);
            }
        } else {
            DDHelper.updateFeatureFromServiceDD(transactionalFeature, portComponentBean);
        }
    }

    public static boolean isEffectivelyEnabled(WSATConfigBean wSATConfigBean) {
        return wSATConfigBean != null && wSATConfigBean.isEnabled() && !NEVER.equals(wSATConfigBean.getFlowType());
    }
}

