/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.config;

import java.lang.reflect.Method;
import javax.xml.ws.WebServiceException;
import weblogic.j2ee.descriptor.wl.OperationComponentBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.WSATConfigBean;
import weblogic.wsee.jws.JWSVisitor;
import weblogic.wsee.wstx.wsat.Transactional;

public class WSATBeanVisitor
implements JWSVisitor {
    private PortComponentBean portComponentBean;
    WSATConfigBean portTransactionConfigBean;
    private boolean createOperationLevelBean;

    public WSATBeanVisitor(PortComponentBean portComponentBean) {
        this.portComponentBean = portComponentBean;
    }

    public WSATBeanVisitor(PortComponentBean portComponentBean, boolean bl) {
        this.portComponentBean = portComponentBean;
        this.createOperationLevelBean = bl;
    }

    public void visitClass(JWSVisitor.JWSClass jWSClass) {
        Transactional transactional;
        Method method;
        Transactional transactional2 = jWSClass.getServiceImpl().getAnnotation(Transactional.class);
        if (jWSClass.isProviderBased() && (method = jWSClass.getInvokeMethod()) != null && (transactional = method.getAnnotation(Transactional.class)) != null) {
            transactional2 = transactional;
        }
        this.portTransactionConfigBean = this.portComponentBean.getWSATConfig();
        if (transactional2 != null && this.portTransactionConfigBean == null) {
            this.portTransactionConfigBean = this.portComponentBean.createWSATConfig();
            this.fromAnnotationToBean(transactional2, this.portTransactionConfigBean, null);
        }
    }

    public void visitMethod(JWSVisitor.WsMethod wsMethod) {
        Method method = wsMethod.getImplMethod();
        OperationComponentBean operationComponentBean = this.portComponentBean.lookupOperation(wsMethod.getOperationName());
        if (operationComponentBean == null) {
            operationComponentBean = this.portComponentBean.createOperation();
            operationComponentBean.setName(wsMethod.getOperationName());
        }
        WSATConfigBean wSATConfigBean = operationComponentBean.getWSATConfig();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (wsMethod.isOneway()) {
            this.handleOnewayOperation(method, operationComponentBean, wSATConfigBean, transactional);
            return;
        }
        if (wSATConfigBean != null) {
            return;
        }
        if (transactional != null) {
            wSATConfigBean = operationComponentBean.createWSATConfig();
            this.fromAnnotationToBean(transactional, wSATConfigBean, this.portComponentBean.getWSATConfig());
        } else if (this.createOperationLevelBean && this.portTransactionConfigBean != null) {
            WSATConfigBean wSATConfigBean2 = operationComponentBean.createWSATConfig();
            wSATConfigBean2.setEnabled(this.portTransactionConfigBean.isEnabled());
            wSATConfigBean2.setFlowType(this.portTransactionConfigBean.getFlowType());
            wSATConfigBean2.setVersion(this.portTransactionConfigBean.getVersion());
        }
    }

    private void handleOnewayOperation(Method method, OperationComponentBean operationComponentBean, WSATConfigBean wSATConfigBean, Transactional transactional) {
        if (wSATConfigBean != null) {
            if (wSATConfigBean.isEnabled() && !Transactional.TransactionFlowType.NEVER.toString().equals(wSATConfigBean.getFlowType())) {
                throw new WebServiceException("WSAT-Config can't be enabled on Oneway operation - " + operationComponentBean.getName());
            }
        } else if (transactional != null) {
            if (transactional.enabled() && transactional.value() != Transactional.TransactionFlowType.NEVER) {
                throw new WebServiceException(Transactional.class.getName() + " can't be enabled on Oneway operation - " + method.toString());
            }
            this.buildOperationLevelWSATConfigBean(operationComponentBean, transactional.enabled(), transactional.value().toString(), transactional.version().toString());
        } else if (this.createOperationLevelBean) {
            this.buildOperationLevelWSATConfigBean(operationComponentBean, false, Transactional.TransactionFlowType.NEVER.toString(), Transactional.Version.DEFAULT.toString());
        }
    }

    private void buildOperationLevelWSATConfigBean(OperationComponentBean operationComponentBean, boolean bl, String string, String string2) {
        WSATConfigBean wSATConfigBean = operationComponentBean.createWSATConfig();
        wSATConfigBean.setEnabled(bl);
        wSATConfigBean.setFlowType(string);
        wSATConfigBean.setVersion(string2);
    }

    private void fromAnnotationToBean(Transactional transactional, WSATConfigBean wSATConfigBean, WSATConfigBean wSATConfigBean2) {
        wSATConfigBean.setEnabled(transactional.enabled());
        wSATConfigBean.setFlowType(transactional.value().toString());
        if (wSATConfigBean2 == null) {
            wSATConfigBean.setVersion(transactional.version().toString());
        } else {
            if (transactional.version() != Transactional.Version.DEFAULT && !transactional.version().toString().equals(wSATConfigBean2.getVersion())) {
                throw new WebServiceException("operation level version can't be different from the port level version!");
            }
            wSATConfigBean.setVersion(wSATConfigBean2.getVersion());
        }
    }
}

