/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.config;

import java.lang.reflect.Method;
import weblogic.wsee.jws.JWSVisitor;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.TransactionalFeature;

public class WSATFeatureVisitor
implements JWSVisitor {
    private TransactionalFeature atFeature;
    private Transactional portAnn;

    public void visitClass(JWSVisitor.JWSClass jWSClass) {
        this.portAnn = jWSClass.getServiceImpl().getAnnotation(Transactional.class);
        if (this.portAnn != null) {
            this.atFeature = new TransactionalFeature();
            this.atFeature.setEnabled(this.portAnn.enabled());
            this.atFeature.setVersion(this.portAnn.version());
            this.atFeature.setFlowType(this.portAnn.value());
        }
    }

    public void visitMethod(JWSVisitor.WsMethod wsMethod) {
        Method method = wsMethod.getImplMethod();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional == null) {
            transactional = this.portAnn;
        }
        if (transactional != null) {
            if (this.atFeature == null) {
                this.atFeature = new TransactionalFeature();
                this.atFeature.setExplicitMode(true);
            }
            String string = wsMethod.getOperationName();
            this.atFeature.setEnabled(string, transactional.enabled());
            if (this.atFeature.isExplicitMode()) {
                this.atFeature.setVersion(this.portAnn.version());
            }
            this.atFeature.setFlowType(string, transactional.value());
        }
    }

    public TransactionalFeature getFeature() {
        return this.atFeature;
    }
}

