/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.policy;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.wstx.wsat.policy.ATPolicyConstants;

public class ATAssertion
extends PolicyAssertion {
    private QName qname;
    private boolean isOptinalSet;

    public void setOptional(boolean bl) {
        super.setOptional(bl);
        this.isOptinalSet = true;
    }

    public Element serialize(Document document) throws PolicyException {
        QName qName = this.getName();
        Element element = DOMUtils.createElement(qName, document, qName.getPrefix());
        if (this.optional || this.isOptinalSet) {
            PolicyHelper.addOptionalAttribute(element, this.optional, this.getPolicyNamespaceUri());
        }
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isOptinalSet = objectInput.readBoolean();
        this.qname = (QName)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isOptinalSet);
        objectOutput.writeObject(this.getName());
    }

    public QName getName() {
        if (this.qname == null) {
            return ATPolicyConstants.DEFAULT_AT_QNAME;
        }
        return this.qname;
    }

    public void setName(QName qName) {
        this.qname = qName;
    }
}

