/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.policy;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.jws.Policy;
import weblogic.jws.jaxws.BasePolicyFeature;
import weblogic.jws.jaxws.PoliciesFeature;
import weblogic.jws.jaxws.PolicyFeature;
import weblogic.wsee.policy.framework.OperatorType;
import weblogic.wsee.policy.framework.PolicyExpression;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.policy.ATAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATAssertionBuilder {
    public static void buildPolicyMap(String string, Map<String, PolicyStatement> map, Map<QName, BasePolicyFeature> map2, TransactionalFeature transactionalFeature) {
        Transactional.Version version2 = transactionalFeature.getVersion();
        Map map3 = transactionalFeature.getFlowTypeMap();
        Map map4 = transactionalFeature.getEnabledMap();
        Set set = map3.keySet();
        for (String string2 : set) {
            String string3;
            PolicyStatement policyStatement;
            if (!Boolean.TRUE.equals(map4.get(string2))) continue;
            boolean bl = false;
            Transactional.TransactionFlowType transactionFlowType = (Transactional.TransactionFlowType)map3.get(string2);
            if (Transactional.TransactionFlowType.NEVER == transactionFlowType) continue;
            if (Transactional.TransactionFlowType.MANDATORY == transactionFlowType) {
                bl = true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (version2 == null || version2 == Transactional.Version.DEFAULT) {
                stringBuilder.append("defaultAT");
            } else {
                stringBuilder.append(version2);
            }
            if (!bl) {
                stringBuilder.append("_optional");
            }
            if ((policyStatement = map.get(string3 = stringBuilder.toString())) == null) {
                policyStatement = ATAssertionBuilder.buildPolicyStatement(string3.toString(), version2, bl);
                map.put(string3, policyStatement);
            }
            PoliciesFeature policiesFeature = ATAssertionBuilder.addATPolicyFeature(string, map2, string2, string3);
            map2.put(new QName(string, string2), (BasePolicyFeature)policiesFeature);
        }
    }

    private static PoliciesFeature addATPolicyFeature(String string, Map<QName, BasePolicyFeature> map, String string2, String string3) {
        BasePolicyFeature basePolicyFeature = map.get(new QName(string, string2));
        PolicyFeature policyFeature = new PolicyFeature(string3, Policy.Direction.both);
        PoliciesFeature policiesFeature = null;
        if (basePolicyFeature == null) {
            policiesFeature = new PoliciesFeature(new PolicyFeature[]{policyFeature});
        } else if (basePolicyFeature instanceof PoliciesFeature) {
            policiesFeature = (PoliciesFeature)basePolicyFeature;
            policiesFeature.getPolicies().add(policyFeature);
        } else if (basePolicyFeature instanceof PolicyFeature) {
            policiesFeature = new PoliciesFeature(new PolicyFeature[]{(PolicyFeature)basePolicyFeature, policyFeature});
        }
        return policiesFeature;
    }

    private static PolicyStatement buildPolicyStatement(String string, Transactional.Version version2, boolean bl) {
        Object object;
        PolicyExpression policyExpression = PolicyExpression.createExpression(OperatorType.EXACTLY_ONE);
        if (version2 == null || version2 == Transactional.Version.DEFAULT) {
            object = Transactional.Version.values();
            for (Transactional.Version version3 : object) {
                if (version3 == Transactional.Version.DEFAULT || version3 == Transactional.Version.WSAT11) continue;
                policyExpression.addExpression(ATAssertionBuilder.buildOneATAssertion(bl, version3));
            }
        } else {
            policyExpression.addExpression(ATAssertionBuilder.buildOneATAssertion(bl, version2));
        }
        object = PolicyStatement.createPolicyStatement(string);
        ((PolicyExpression)object).addExpression(policyExpression);
        return object;
    }

    private static PolicyExpression buildOneATAssertion(boolean bl, Transactional.Version version2) {
        ATAssertion aTAssertion = new ATAssertion();
        if (!bl) {
            aTAssertion.setOptional(true);
        }
        aTAssertion.setName(version2.getQName());
        PolicyExpression policyExpression = PolicyExpression.createExpression(OperatorType.ALL);
        PolicyExpression policyExpression2 = PolicyExpression.createExpression(OperatorType.TERMINAL);
        policyExpression2.setAssertion(aTAssertion);
        policyExpression.addExpression(policyExpression2);
        return policyExpression;
    }
}

