/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.policy;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyAssertionFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.wstx.wsat.policy.ATAssertion;
import weblogic.wsee.wstx.wsat.policy.ATPolicyConstants;

public class ATPolicyAssertionFactory
extends PolicyAssertionFactory {
    public PolicyAssertion createAssertion(Node node) throws PolicyException {
        Boolean bl;
        if (node == null) {
            return null;
        }
        assert (node.getNodeType() == 1);
        if (!"ATAssertion".equals(node.getLocalName())) {
            return null;
        }
        String string = node.getNamespaceURI();
        if (!"http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(string) && !"http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(string)) {
            return null;
        }
        ATAssertion aTAssertion = new ATAssertion();
        if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(string)) {
            aTAssertion.setName(ATPolicyConstants.AT12_QNAME);
        }
        if ((bl = PolicyHelper.getOptionalBoolean((Element)node)) != null) {
            aTAssertion.setOptional(bl);
        }
        return aTAssertion;
    }

    public static boolean isATPolicyAssertion(Node node) {
        if (node == null) {
            return false;
        }
        String string = node.getNamespaceURI();
        return ("http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(string) || "http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(string)) && node.getLocalName().equals("ATAssertion");
    }

    static {
        ATPolicyAssertionFactory.registerAssertion(ATPolicyConstants.AT10_QNAME, ATPolicyConstants.class.getName());
        ATPolicyAssertionFactory.registerAssertion(ATPolicyConstants.AT12_QNAME, ATPolicyConstants.class.getName());
    }
}

