/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.policy;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.policy.ATAssertion;

public class ATPolicyHelper {
    public static TransactionalFeature buildFeatureFromWsdl(WsdlPort wsdlPort, PolicyServer policyServer) {
        TransactionalFeature transactionalFeature = null;
        try {
            for (WsdlBindingOperation wsdlBindingOperation : wsdlPort.getBinding().getOperations().values()) {
                String string = wsdlBindingOperation.getName().getLocalPart();
                NormalizedExpression normalizedExpression = WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlBindingOperation, Collections.EMPTY_MAP);
                Set set = normalizedExpression.getPolicyAlternatives(ATAssertion.class);
                if (set == null) continue;
                boolean bl = false;
                for (PolicyAlternative policyAlternative : set) {
                    Set set2 = policyAlternative.getAssertions(ATAssertion.class);
                    for (PolicyAssertion policyAssertion : set2) {
                        if (!(policyAssertion instanceof ATAssertion)) continue;
                        if (transactionalFeature == null) {
                            transactionalFeature = new TransactionalFeature();
                            transactionalFeature.setExplicitMode(true);
                        }
                        QName qName = policyAssertion.getName();
                        Transactional.Version version2 = Transactional.Version.forNamespaceUri((String)qName.getNamespaceURI());
                        if (bl && version2 != transactionalFeature.getVersion()) {
                            transactionalFeature.setVersion(Transactional.Version.DEFAULT);
                        } else {
                            transactionalFeature.setVersion(version2);
                        }
                        transactionalFeature.setFlowType(string, ATPolicyHelper.toFlowType(policyAssertion.isOptional()));
                        transactionalFeature.setEnabled(string, true);
                        transactionalFeature.setEnabled(true);
                        bl = true;
                    }
                }
                if (bl || transactionalFeature == null) continue;
                transactionalFeature.setEnabled(string, false);
            }
        }
        catch (Exception exception) {
            throw new WebServiceException((Throwable)exception);
        }
        return transactionalFeature;
    }

    private static Transactional.TransactionFlowType toFlowType(boolean bl) {
        if (bl) {
            return Transactional.TransactionFlowType.SUPPORTS;
        }
        return Transactional.TransactionFlowType.MANDATORY;
    }
}

