/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.security;

import java.io.InputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jws.jaxws.ClientPolicyFeature;
import weblogic.jws.jaxws.policy.InputStreamPolicySource;
import weblogic.jws.jaxws.policy.PolicySource;

public abstract class ClientPolicyFeatureBuilder {
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private static String POLICY_HOME = "policies/wls_internal/wsat/";
    private static String BUILTIN_POLICY_HOME = "weblogic/wsee/policy/runtime/wls_internal/wsat/";

    public static ClientPolicyFeatureBuilder V10() {
        return ClientPolicyFeatureBuilderV10Holder.instance;
    }

    public static ClientPolicyFeatureBuilder V11() {
        return ClientPolicyFeatureBuilderV11Holder.instance;
    }

    abstract String getOutboundPolicy();

    abstract String getInboundPolicy();

    abstract String getIssuedTokenPolicy();

    public ClientPolicyFeature newClientPolicyFeature() {
        ClientPolicyFeature clientPolicyFeature = new ClientPolicyFeature();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        clientPolicyFeature.setEffectivePolicy((PolicySource)new InputStreamPolicySource(new InputStream[]{classLoader.getResourceAsStream(this.getIssuedTokenPolicy())}));
        if (ClientPolicyFeatureBuilder.isExisted(this.getInboundPolicy())) {
            if (logger.isDebugEnabled()) {
                logger.debug("WSAT registration inbound policy " + this.getInboundPolicy() + " will be used as client side policy.");
            }
            clientPolicyFeature.setEffectivePolicyForInputMessage((PolicySource)new InputStreamPolicySource(new InputStream[]{classLoader.getResourceAsStream(this.getInboundPolicy())}));
        }
        if (ClientPolicyFeatureBuilder.isExisted(this.getOutboundPolicy())) {
            if (logger.isDebugEnabled()) {
                logger.debug("WSAT registration outbound policy " + this.getOutboundPolicy() + " will be used as client side policy.");
            }
            clientPolicyFeature.setEffectivePolicyForOutputMessage((PolicySource)new InputStreamPolicySource(new InputStream[]{classLoader.getResourceAsStream(this.getOutboundPolicy())}));
        }
        return clientPolicyFeature;
    }

    private static boolean isExisted(String string) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(string) != null;
    }

    private static String getPolicy(String string) {
        String string2 = null;
        if (ClientPolicyFeatureBuilder.isExisted(POLICY_HOME + string)) {
            return POLICY_HOME + string;
        }
        string2 = BUILTIN_POLICY_HOME + string;
        if (logger.isDebugEnabled()) {
            logger.debug("policy file " + string + " will be loaded from " + string2);
        }
        return string2;
    }

    static /* synthetic */ String access$200(String string) {
        return ClientPolicyFeatureBuilder.getPolicy(string);
    }

    static class ClientPolicyFeatureBuilder_v11
    extends ClientPolicyFeatureBuilder {
        static final String WSAT11_POLICY = "wsat11-registration-policy.xml";
        private static final String WSAT11_INBOUND_POLICY = "wsat11-registration-inbound-policy.xml";
        private static final String WSAT11_OUTBOUND_POLICY = "wsat11-registration-outbound-policy.xml";
        private static String outboundPolicy = ClientPolicyFeatureBuilder.access$200("wsat11-registration-outbound-policy.xml");
        private static String inboundPolicy = ClientPolicyFeatureBuilder.access$200("wsat11-registration-inbound-policy.xml");
        private static String issuedTokenPolicy = ClientPolicyFeatureBuilder.access$200("wsat11-registration-policy.xml");

        ClientPolicyFeatureBuilder_v11() {
        }

        String getOutboundPolicy() {
            return outboundPolicy;
        }

        String getInboundPolicy() {
            return inboundPolicy;
        }

        String getIssuedTokenPolicy() {
            return issuedTokenPolicy;
        }
    }

    static class ClientPolicyFeatureBuilder_v10
    extends ClientPolicyFeatureBuilder {
        private static final String WSAT_INBOUND_POLICY = "wsat-registration-inbound-policy.xml";
        private static final String WSAT_OUTBOUND_POLICY = "wsat-registration-outbound-policy.xml";
        private static final String WSAT_POLICY = "wsat-registration-policy.xml";
        private static String outboundPolicy = ClientPolicyFeatureBuilder.access$200("wsat-registration-outbound-policy.xml");
        private static String inboundPolicy = ClientPolicyFeatureBuilder.access$200("wsat-registration-inbound-policy.xml");
        private static String issuedTokenPolicy = ClientPolicyFeatureBuilder.access$200("wsat-registration-policy.xml");

        ClientPolicyFeatureBuilder_v10() {
        }

        String getOutboundPolicy() {
            return outboundPolicy;
        }

        String getInboundPolicy() {
            return inboundPolicy;
        }

        String getIssuedTokenPolicy() {
            return issuedTokenPolicy;
        }
    }

    private static class ClientPolicyFeatureBuilderV11Holder {
        private static ClientPolicyFeatureBuilder instance = new ClientPolicyFeatureBuilder_v11();

        private ClientPolicyFeatureBuilderV11Holder() {
        }
    }

    private static class ClientPolicyFeatureBuilderV10Holder {
        private static ClientPolicyFeatureBuilder instance = new ClientPolicyFeatureBuilder_v10();

        private ClientPolicyFeatureBuilderV10Holder() {
        }
    }
}

