/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.security;

import com.sun.xml.ws.util.DOMUtil;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.security.wssp.ProtectionTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.SymmetricBindingInfo;
import weblogic.wsee.security.wst.framework.TrustProcessor;
import weblogic.wsee.security.wst.framework.TrustProcessorFactory;
import weblogic.wsee.security.wst.framework.TrustRequestor;
import weblogic.wsee.security.wst.framework.TrustRequestorFactory;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.wstx.wsat.security.ClientPolicyFeatureBuilder;
import weblogic.wsee.wstx.wsc.common.types.BaseIdentifier;
import weblogic.wsee.wstx.wsc.common.types.CoordinationContextIF;

public class IssuedTokenBuilder {
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugWSAT");
    private String trustVersion;
    private String tokenType;
    private String binarySecretType = "none";
    private int keySize = 256;
    private WebServiceException cachedException;

    public IssuedTokenBuilder(String string, String string2, int n) {
        this.trustVersion = string;
        this.tokenType = string2;
        this.keySize = n;
    }

    public IssuedTokenBuilder(String string) {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new WebServiceException("fail to load policy file:\t" + string);
            }
            NormalizedExpression normalizedExpression = null;
            try {
                normalizedExpression = PolicyFinder.readPolicyFromStream(string, inputStream).normalize();
            }
            catch (PolicyException policyException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("fail to load policy file:\t" + string, (Throwable)policyException);
                }
                throw new WebServiceException("fail to load policy file:\t" + string);
            }
            if (normalizedExpression == null || normalizedExpression.getPolicyAlternative() == null) {
                throw new WebServiceException("no policy alternative found in:\t" + string);
            }
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(normalizedExpression.getPolicyAlternative());
            if (securityPolicyAssertionInfo == null || securityPolicyAssertionInfo.getSymmetricBindingInfo() == null) {
                throw new WebServiceException("no SymmetricBindingInfo found in:\t" + string);
            }
            SymmetricBindingInfo symmetricBindingInfo = securityPolicyAssertionInfo.getSymmetricBindingInfo();
            ProtectionTokenAssertion protectionTokenAssertion = symmetricBindingInfo.getProtectionTokenAssertion();
            SecureConversationTokenAssertion secureConversationTokenAssertion = protectionTokenAssertion.getSecureConversationTokenAssertion();
            if (secureConversationTokenAssertion == null) {
                throw new WebServiceException("no SecureConversationToken Assertion found in:\t" + string);
            }
            String string2 = secureConversationTokenAssertion.getSctTokenType();
            String string3 = secureConversationTokenAssertion.isSC200502SecurityContextToken() ? "http://schemas.xmlsoap.org/ws/2005/02/trust" : "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            NormalizedExpression normalizedExpression2 = secureConversationTokenAssertion.getNormalizedBootstrapPolicy();
            if (normalizedExpression2 == null || normalizedExpression2.getPolicyAlternative() == null) {
                throw new WebServiceException("no Bootstrap Policy for SecureConversationToken Assertion found in:\t" + string);
            }
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo2 = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(normalizedExpression2.getPolicyAlternative());
            int n = securityPolicyAssertionInfo2.getAlgorithmSuiteInfo().getMinSymKeyLength();
            this.tokenType = string2;
            this.trustVersion = string3;
            this.keySize = n;
        }
        catch (Throwable throwable) {
            this.cachedException = throwable instanceof WebServiceException ? (WebServiceException)throwable : new WebServiceException(throwable);
        }
    }

    public static IssuedTokenBuilder v12() {
        if (V12BuilderLazyHolder.builder.cachedException != null) {
            throw V12BuilderLazyHolder.builder.cachedException;
        }
        return V12BuilderLazyHolder.builder;
    }

    public static IssuedTokenBuilder v13() {
        if (V13BuilderLazyHolder.builder.cachedException != null) {
            throw V13BuilderLazyHolder.builder.cachedException;
        }
        return V13BuilderLazyHolder.builder;
    }

    IssuedTokenBuilder keySize(int n) {
        this.keySize = n;
        return this;
    }

    public Element buildFromContext(CoordinationContextIF coordinationContextIF) {
        Element element = DOMUtil.createDom().createElement("dumy");
        try {
            BaseIdentifier baseIdentifier = coordinationContextIF.getIdentifier();
            JAXBElement jAXBElement = new JAXBElement(baseIdentifier.getQName(), baseIdentifier.getDelegate().getClass(), baseIdentifier.getDelegate());
            coordinationContextIF.getJAXBRIContext().createMarshaller().marshal((Object)jAXBElement, (Node)element);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException((Throwable)jAXBException);
        }
        return this.buildFromAppliesToElement((Element)element.getFirstChild());
    }

    public Element buildFromAppliesToElement(Element element) {
        try {
            TrustProcessorFactory trustProcessorFactory = TrustProcessorFactory.getInstance();
            TrustProcessor trustProcessor = trustProcessorFactory.getProcessor("/Issue");
            WSTContext wSTContext = new WSTContext();
            SoapMessageContext soapMessageContext = new SoapMessageContext();
            soapMessageContext.setProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME", "true");
            wSTContext.setMessageContext(soapMessageContext);
            wSTContext.setTrustVersion(this.trustVersion);
            wSTContext.setTokenType(this.tokenType);
            wSTContext.setAppliesToElement(element);
            wSTContext.setKeySize(this.keySize);
            wSTContext.setBinarySecretType(this.binarySecretType);
            TrustRequestorFactory trustRequestorFactory = TrustRequestorFactory.getInstance();
            TrustRequestor trustRequestor = trustRequestorFactory.createTrustRequestor(wSTContext.getTrustVersion());
            Node node = trustRequestor.newRequestSecurityToken(wSTContext);
            Node node2 = trustProcessor.processRequestSecurityToken(node, wSTContext);
            Element element2 = DOMUtil.createDom().createElementNS(this.trustVersion, "IssuedTokens");
            element2.appendChild(element2.getOwnerDocument().importNode(node2, true));
            return element2;
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("fail to create IssuedToken!", (Throwable)exception);
            }
            throw new WebServiceException((Throwable)exception);
        }
    }

    private static class V13BuilderLazyHolder {
        private static final IssuedTokenBuilder builder = new IssuedTokenBuilder(ClientPolicyFeatureBuilder.V11().getIssuedTokenPolicy());

        private V13BuilderLazyHolder() {
        }
    }

    private static class V12BuilderLazyHolder {
        private static final IssuedTokenBuilder builder = new IssuedTokenBuilder(ClientPolicyFeatureBuilder.V10().getIssuedTokenPolicy());

        private V12BuilderLazyHolder() {
        }
    }
}

