/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.security;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.wssc.base.sct.SCTHelper;
import weblogic.wsee.security.wssc.base.sct.SCTokenHandlerBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.v200502.sct.SCTokenHandler;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;

public class IssuedTokenCPBuilder {
    private SCTokenHandlerBase tokenHandler;
    private Node rstrNode = null;
    private String algorithm = "AES";

    public IssuedTokenCPBuilder algorithm(String string) {
        this.algorithm = string;
        return this;
    }

    public IssuedTokenCPBuilder issuedTokens(Element element) {
        String string = element.getNodeName();
        String string2 = element.getNamespaceURI();
        if ("IssuedTokens".equals(string)) {
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(string2)) {
                this.tokenHandler = new weblogic.wsee.security.wssc.v13.sct.SCTokenHandler();
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/trust".equals(string2)) {
                this.tokenHandler = new SCTokenHandler();
            }
        }
        if (this.tokenHandler == null) {
            throw new IllegalArgumentException("not valid issuedTokens");
        }
        NodeList nodeList = element.getElementsByTagNameNS(string2, "RequestSecurityTokenResponse");
        if (nodeList.getLength() > 0) {
            this.rstrNode = nodeList.item(0);
        }
        if (this.rstrNode == null) {
            throw new IllegalArgumentException("issuedTokens doesn't include RequestSecurityTokenResponse element");
        }
        return this;
    }

    public CredentialProvider build() {
        try {
            RequestSecurityTokenResponse requestSecurityTokenResponse = BindingHelper.unmarshalRSTRNode(this.rstrNode, this.tokenHandler);
            SecretKeySpec secretKeySpec = new SecretKeySpec(requestSecurityTokenResponse.getRequestedProofToken().getBinarySecret().getValue(), this.algorithm);
            final SCCredential sCCredential = SCTHelper.getSCCredentialFromRSTR(null, secretKeySpec, requestSecurityTokenResponse, this.tokenHandler);
            return new CredentialProvider(){

                public String[] getValueTypes() {
                    return IssuedTokenCPBuilder.this.tokenHandler.getValueTypes();
                }

                public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
                    return sCCredential;
                }
            };
        }
        catch (Exception exception) {
            throw new WebServiceException((Throwable)exception);
        }
    }
}

