/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.message.DOMHeader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import weblogic.wsee.wstx.wsat.WSATConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUHeaderHelper {
    private static final String MU_FAULT_DETAIL_LOCALPART = "NotUnderstood";
    private static final QName MU_HEADER_DETAIL = new QName(SOAPVersion.SOAP_12.nsUri, "NotUnderstood");
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "One or more mandatory SOAP header blocks not understood";

    public static Set<QName> getMUWSATHeaders(HeaderList headerList) {
        HashSet<QName> hashSet = null;
        for (int i = 0; i < headerList.size(); ++i) {
            Header header;
            QName qName;
            if (headerList.isUnderstood(i) || !WSATConstants.WSCOOR_CONTEXT_QNAME.equals(qName = new QName((header = headerList.get(i)).getNamespaceURI(), header.getLocalPart())) && !WSATConstants.WSCOOR11_CONTEXT_QNAME.equals(qName)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<QName>();
            }
            hashSet.add(qName);
        }
        return hashSet;
    }

    static Message createMUSOAPFaultMessage(SOAPVersion sOAPVersion, Set<QName> set) {
        try {
            SOAPFault sOAPFault = MUHeaderHelper.createMUSOAPFault(sOAPVersion);
            if (sOAPVersion == SOAPVersion.SOAP_11) {
                MUHeaderHelper.setMUFaultString(sOAPFault, set);
            }
            Message message = Messages.create((SOAPFault)sOAPFault);
            if (sOAPVersion == SOAPVersion.SOAP_12) {
                MUHeaderHelper.addHeader(message, set);
            }
            return message;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException((Throwable)sOAPException);
        }
    }

    private static void setMUFaultString(SOAPFault sOAPFault, Set<QName> set) throws SOAPException {
        sOAPFault.setFaultString("MustUnderstand headers:" + set + " are not understood");
    }

    private static void addHeader(Message message, Set<QName> set) throws SOAPException {
        for (QName qName : set) {
            SOAPElement sOAPElement = SOAPVersion.SOAP_12.getSOAPFactory().createElement(MU_HEADER_DETAIL);
            sOAPElement.addNamespaceDeclaration("abc", qName.getNamespaceURI());
            sOAPElement.setAttribute("qname", "abc:" + qName.getLocalPart());
            DOMHeader dOMHeader = new DOMHeader((Element)sOAPElement);
            message.getHeaders().add((Header)dOMHeader);
        }
    }

    private static SOAPFault createMUSOAPFault(SOAPVersion sOAPVersion) throws SOAPException {
        SOAPFault sOAPFault = sOAPVersion.getSOAPFactory().createFault();
        sOAPFault.setFaultCode(sOAPVersion.faultCodeMustUnderstand);
        sOAPFault.setFaultString(MUST_UNDERSTAND_FAULT_MESSAGE_STRING);
        return sOAPFault;
    }
}

