/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import weblogic.transaction.ClientTransactionManager;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.tube.TransactionalAttribute;
import weblogic.wsee.wstx.wsat.tube.WSATClient;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;
import weblogic.wsee.wstx.wsc.common.WSATCoordinationContextBuilder;
import weblogic.wsee.wstx.wsc.common.WSCBuilderFactory;
import weblogic.wsee.wstx.wsc.common.types.CoordinationContextIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATClientHelper
implements WSATClient {
    @Override
    public List<Header> doHandleRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        boolean bl;
        if (!transactionalAttribute.isEnabled()) {
            return null;
        }
        weblogic.transaction.Transaction transaction = WSATTubeHelper.getTransaction();
        boolean bl2 = bl = transaction != null;
        if (!bl) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logOutboundApplicationMessageNoTransaction();
            }
            if (transactionalAttribute.isRequired()) {
                throw new WebServiceException("no transaction to be exported!");
            }
            return null;
        }
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logOutboundApplicationMessageTransactionBeforeAddingContext((Object)transaction);
        }
        List<Header> list = this.processTransactionalRequest(transactionalAttribute, map);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logOutboundApplicationMessageTransactionAfterAddingContext((Object)transaction);
        }
        return list;
    }

    @Override
    public boolean doHandleResponse(Map<String, Object> map) {
        weblogic.transaction.Transaction transaction;
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logInboundApplicationMessage();
        }
        return (transaction = this.getWSATTransactionFromMap(map)) == null || this.resume(transaction);
    }

    @Override
    public void doHandleException(Map<String, Object> map) {
        weblogic.transaction.Transaction transaction;
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logInboundApplicationMessage();
        }
        if ((transaction = this.getWSATTransactionFromMap(map)) != null) {
            this.resume(transaction);
        }
    }

    private weblogic.transaction.Transaction getWSATTransactionFromMap(Map map) {
        weblogic.transaction.Transaction transaction = (weblogic.transaction.Transaction)map.get("wsat.transaction");
        return transaction;
    }

    private boolean resume(weblogic.transaction.Transaction transaction) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWillResumeInClientSideHandler((Object)transaction, (Object)Thread.currentThread());
        }
        try {
            WSATTubeHelper.getTransactionHelper().getTransactionManager().resume((Transaction)transaction);
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logResumedInClientSideHandler((Object)transaction, (Object)Thread.currentThread());
            }
            return true;
        }
        catch (InvalidTransactionException invalidTransactionException) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logInvalidTransactionExceptionInClientSideHandler((Exception)((Object)invalidTransactionException), (Object)transaction, (Object)Thread.currentThread());
            }
            WSATTubeHelper.getTransactionHelper().getTransactionManager().forceResume((Transaction)transaction);
            transaction.setRollbackOnly((Throwable)invalidTransactionException);
            return false;
        }
        catch (SystemException systemException) {
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logSystemExceptionInClientSideHandler((Exception)((Object)systemException), (Object)transaction, (Object)Thread.currentThread());
            }
            WSATTubeHelper.getTransactionHelper().getTransactionManager().forceResume((Transaction)transaction);
            transaction.setRollbackOnly((Throwable)systemException);
            return false;
        }
    }

    private List<Header> processTransactionalRequest(TransactionalAttribute transactionalAttribute, Map map) {
        weblogic.transaction.Transaction transaction = this.suspend(map);
        if (transaction == null) {
            return null;
        }
        ArrayList<Header> arrayList = new ArrayList<Header>();
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logSuspendSuccessfulInClientSideHandler((Object)transaction, (Object)Thread.currentThread());
        }
        String string = WSATTubeHelper.getWSATTxIdForTransaction(transaction);
        long l = transaction.getTimeToLiveMillis();
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logWSATInfoInClientSideHandler((String)string, (long)l, (Object)transaction, (Object)Thread.currentThread());
        }
        WSCBuilderFactory wSCBuilderFactory = WSCBuilderFactory.newInstance(transactionalAttribute.getVersion());
        WSATCoordinationContextBuilder wSATCoordinationContextBuilder = wSCBuilderFactory.newWSATCoordinationContextBuilder();
        CoordinationContextIF coordinationContextIF = wSATCoordinationContextBuilder.txId(string).expires(l).soapVersion(transactionalAttribute.getSoapVersion()).mustUnderstand(true).build();
        Header header = Headers.create((JAXBRIContext)coordinationContextIF.getJAXBRIContext(), coordinationContextIF.getDelegate());
        arrayList.add(header);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logOutboundApplicationMessageTransactionAfterAddingContext((Object)transaction);
        }
        if (WSATTubeHelper.isIssuedTokenEnabled()) {
            Element element = wSCBuilderFactory.newIssuedTokenBuilder().buildFromContext(coordinationContextIF);
            arrayList.add(Headers.create((Element)element));
        }
        return arrayList;
    }

    private weblogic.transaction.Transaction suspend(Map map) {
        weblogic.transaction.Transaction transaction = null;
        try {
            ClientTransactionManager clientTransactionManager = WSATTubeHelper.getTransactionHelper().getTransactionManager();
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logAboutToSuspendInClientSideHandler((Object)clientTransactionManager, (Object)Thread.currentThread());
            }
            transaction = (weblogic.transaction.Transaction)clientTransactionManager.suspend();
            transaction.setLocalProperty("weblogic.transaction.otsTransactionExport", null);
            map.put("wsat.transaction", transaction);
            if (WSATHelper.isDebugEnabled()) {
                WseeWsatLogger.logSuspendedInClientSideHandler((Object)transaction, (Object)Thread.currentThread());
            }
        }
        catch (SystemException systemException) {
            WseeWsatLogger.logSystemExceptionDuringSuspend((Exception)((Object)systemException), transaction, (Object)Thread.currentThread());
            return null;
        }
        return transaction;
    }
}

