/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.WSATConstants;
import weblogic.wsee.wstx.wsat.tube.TransactionalAttribute;
import weblogic.wsee.wstx.wsat.tube.WSATClient;
import weblogic.wsee.wstx.wsat.tube.WSATClientHelper;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATClientTube
extends AbstractFilterTubeImpl
implements WSATConstants {
    WSBinding m_wsbinding;
    WSATClient m_wsatClientHelper = new WSATClientHelper();
    private TransactionalFeature m_transactionalFeature;
    private WSDLPort m_port;

    public WSATClientTube(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext, TransactionalFeature transactionalFeature) {
        super(tube);
        this.m_wsbinding = clientTubeAssemblerContext.getBinding();
        this.m_transactionalFeature = transactionalFeature;
        this.m_port = clientTubeAssemblerContext.getWsdlModel();
    }

    private WSATClientTube(WSATClientTube wSATClientTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)wSATClientTube, tubeCloner);
        this.m_wsbinding = wSATClientTube.m_wsbinding;
        this.m_transactionalFeature = wSATClientTube.m_transactionalFeature;
        this.m_port = wSATClientTube.m_port;
    }

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        TransactionalAttribute transactionalAttribute = WSATTubeHelper.getTransactionalAttribute(this.m_transactionalFeature, packet, this.m_port);
        transactionalAttribute.setSoapVersion(this.m_wsbinding.getSOAPVersion());
        List<Header> list = this.m_wsatClientHelper.doHandleRequest(transactionalAttribute, packet.invocationProperties);
        if (list != null) {
            for (Header header : list) {
                packet.getMessage().getHeaders().add(header);
            }
        }
        return super.processRequest(packet);
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        this.m_wsatClientHelper.doHandleResponse(packet.invocationProperties);
        return super.processResponse(packet);
    }

    @NotNull
    public NextAction processException(Throwable throwable) {
        Map map = Fiber.current().getPacket().invocationProperties;
        this.m_wsatClientHelper.doHandleResponse(map);
        return super.processException(throwable);
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new WSATClientTube(this, tubeCloner);
    }
}

