/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.xml.ws.api.message.HeaderList;
import java.io.Serializable;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.WLXid;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.internal.ForeignRecoveryContext;
import weblogic.wsee.wstx.internal.ForeignRecoveryContextManager;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.WSATException;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.tube.TransactionalAttribute;
import weblogic.wsee.wstx.wsat.tube.WSATServer;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;
import weblogic.wsee.wstx.wsc.common.CoordinationContextBuilder;
import weblogic.wsee.wstx.wsc.common.RegistrationIF;
import weblogic.wsee.wstx.wsc.common.WSCBuilderFactory;
import weblogic.wsee.wstx.wsc.common.client.RegistrationMessageBuilder;
import weblogic.wsee.wstx.wsc.common.client.RegistrationProxyBuilder;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterResponseType;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterType;
import weblogic.wsee.wstx.wsc.common.types.CoordinationContextIF;

public class WSATServerHelper
implements WSATServer {
    public void doHandleRequest(HeaderList headerList, TransactionalAttribute transactionalAttribute) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("processRequest HeaderList:" + headerList + " TransactionalAttribute:" + transactionalAttribute + " isEnabled:" + transactionalAttribute.isEnabled());
        }
        if (transactionalAttribute.isEnabled()) {
            CoordinationContextBuilder coordinationContextBuilder = CoordinationContextBuilder.headers(headerList, transactionalAttribute.getVersion());
            if (coordinationContextBuilder != null) {
                this.processIncomingTransaction(headerList, coordinationContextBuilder);
            } else if (transactionalAttribute.isRequired()) {
                throw new WebServiceException("transaction context is required to be inflowed");
            }
        }
    }

    public void doHandleResponse(TransactionalAttribute transactionalAttribute) {
        if (transactionalAttribute != null && transactionalAttribute.isEnabled()) {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("processResponse isTransactionalAnnotationPresent about to suspend");
            }
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("processResponse suspend was successful tx:" + transaction);
            }
        }
    }

    public void doHandleException(Throwable throwable) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("processException about to suspend if transaction is present due to:" + throwable);
        }
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("processException suspend was successful tx:" + transaction);
        }
    }

    private void processIncomingTransaction(HeaderList headerList, CoordinationContextBuilder coordinationContextBuilder) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("in processingIncomingTransaction");
        }
        CoordinationContextIF coordinationContextIF = coordinationContextBuilder.buildFromHeader();
        long l = coordinationContextIF.getExpires().getValue();
        String string = coordinationContextIF.getIdentifier().getValue().replace("urn:", "").replaceAll("uuid:", "");
        boolean bl = TransactionIdHelper.getInstance().getXid(string.getBytes()) == null;
        try {
            Xid xid = WSATHelper.getTransactionServices().importTransaction((int)l, string.getBytes());
            if (bl) {
                this.register(headerList, coordinationContextBuilder, coordinationContextIF, xid, l);
            }
        }
        catch (WSATException wSATException) {
            throw new WebServiceException((Throwable)wSATException);
        }
    }

    private void register(HeaderList headerList, CoordinationContextBuilder coordinationContextBuilder, CoordinationContextIF coordinationContextIF, Xid xid, long l) {
        String string = TransactionIdHelper.getInstance().xid2wsatid((WLXid)xid);
        Transactional.Version version2 = coordinationContextBuilder.getVersion();
        WSCBuilderFactory wSCBuilderFactory = WSCBuilderFactory.newInstance(version2);
        RegistrationMessageBuilder registrationMessageBuilder = wSCBuilderFactory.newWSATRegistrationRequestBuilder();
        BaseRegisterType baseRegisterType = registrationMessageBuilder.durable(true).txId(string).routing().build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("About to suspend tx before registerOperation call");
        }
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("Suspend was successful for tx:" + transaction);
        }
        RegistrationProxyBuilder registrationProxyBuilder = wSCBuilderFactory.newRegistrationProxyBuilder();
        registrationProxyBuilder.feature((WebServiceFeature)WSATTubeHelper.getPolicyFeature(wSCBuilderFactory)).credentialProvider(WSATTubeHelper.getCredentialProvider(headerList)).to((EndpointReference)coordinationContextIF.getRegistrationService()).txIdForReference(string).timeout(l);
        RegistrationIF registrationIF = registrationProxyBuilder.build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("Before registerOperation call, suspend was successful for tx:" + transaction + " registration service proxy:" + registrationIF);
        }
        BaseRegisterResponseType baseRegisterResponseType = registrationIF.registerOperation(baseRegisterType);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("Return from registerOperation call:" + baseRegisterResponseType);
        }
        if (baseRegisterResponseType != null) {
            Object t = baseRegisterResponseType.getCoordinatorProtocolService();
            ForeignRecoveryContext foreignRecoveryContext = ForeignRecoveryContextManager.getInstance().addAndGetForeignRecoveryContextForTidByteArray(xid);
            foreignRecoveryContext.setEndpointReference((EndpointReference)t, coordinationContextBuilder.getVersion());
            if (((weblogic.transaction.Transaction)transaction).getProperty("weblogic.wsee.wstx.foreignContext") == null) {
                ((weblogic.transaction.Transaction)transaction).setProperty("weblogic.wsee.wstx.foreignContext", (Serializable)foreignRecoveryContext);
            }
        } else {
            this.log("Sending fault. Context refused registerResponseType is null");
            throw new WebServiceException("Sending fault. Context refused registerResponseType is null");
        }
        TransactionHelper.getTransactionHelper().getTransactionManager().forceResume(transaction);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("Returned from registerOperation call resumed tx:" + transaction);
        }
    }

    public void log(String string) {
        WseeWsatLogger.logWSATServerHelper((Object)("WSATServerInterceptor:" + string));
    }

    private void debug(String string) {
        WSATHelper.getInstance().debug("WSATServerInterceptor:" + string);
    }
}

