/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.WSATConstants;
import weblogic.wsee.wstx.wsat.tube.MUHeaderHelper;
import weblogic.wsee.wstx.wsat.tube.TransactionalAttribute;
import weblogic.wsee.wstx.wsat.tube.WSATServer;
import weblogic.wsee.wstx.wsat.tube.WSATServerHelper;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;

public class WSATServerTube
extends AbstractFilterTubeImpl
implements WSATConstants {
    private static final String WSATATTRIBUTE = "weblogic.wsee.wsat.attribute";
    ServerTubeAssemblerContext m_context;
    boolean isTransactionalAnnotationPresent;
    private WSDLPort m_port;
    private TransactionalFeature m_transactionalFeature;
    WSATServer m_wsatServerHelper = new WSATServerHelper();

    public WSATServerTube(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext, TransactionalFeature transactionalFeature) {
        super(tube);
        this.commonConstruct(serverTubeAssemblerContext, transactionalFeature);
    }

    private void commonConstruct(ServerTubeAssemblerContext serverTubeAssemblerContext, TransactionalFeature transactionalFeature) {
        this.m_context = serverTubeAssemblerContext;
        this.m_port = serverTubeAssemblerContext.getWsdlModel();
        this.m_transactionalFeature = transactionalFeature;
    }

    public WSATServerTube(WSATServerTube wSATServerTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)wSATServerTube, tubeCloner);
        this.m_context = wSATServerTube.m_context;
        this.m_port = wSATServerTube.m_port;
        this.m_transactionalFeature = wSATServerTube.m_transactionalFeature;
    }

    @NotNull
    public NextAction processRequest(Packet packet) {
        Set<QName> set;
        TransactionalAttribute transactionalAttribute = WSATTubeHelper.getTransactionalAttribute(this.m_transactionalFeature, packet, this.m_port);
        transactionalAttribute.setSoapVersion(this.m_context.getEndpoint().getBinding().getSOAPVersion());
        packet.invocationProperties.put(WSATATTRIBUTE, transactionalAttribute);
        HeaderList headerList = packet.getMessage().getHeaders();
        this.m_wsatServerHelper.doHandleRequest(headerList, transactionalAttribute);
        if (!transactionalAttribute.isEnabled() && (set = MUHeaderHelper.getMUWSATHeaders(headerList)) != null && !set.isEmpty()) {
            return this.doReturnWith(packet.createResponse(MUHeaderHelper.createMUSOAPFaultMessage(transactionalAttribute.getSoapVersion(), set)));
        }
        return super.processRequest(packet);
    }

    @NotNull
    public NextAction processResponse(Packet packet) {
        TransactionalAttribute transactionalAttribute = (TransactionalAttribute)packet.invocationProperties.get(WSATATTRIBUTE);
        this.m_wsatServerHelper.doHandleResponse(transactionalAttribute);
        return super.processResponse(packet);
    }

    @NotNull
    public NextAction processException(Throwable throwable) {
        this.m_wsatServerHelper.doHandleException(throwable);
        return super.processException(throwable);
    }

    public void preDestroy() {
        super.preDestroy();
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new WSATServerTube(this, tubeCloner);
    }

    NextAction doProcessResponse(Packet packet) {
        return super.processResponse(packet);
    }
}

