/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import java.security.AccessController;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.jws.jaxws.ClientPolicyFeature;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.WLXid;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.security.IssuedTokenCPBuilder;
import weblogic.wsee.wstx.wsat.tube.TransactionalAttribute;
import weblogic.wsee.wstx.wsc.common.WSCBuilderFactory;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

public class WSATTubeHelper {
    private static boolean isIssuedTokenEnabled;
    private static String transportSecurityMode;
    private static final AuthenticatedSubject kernelId;

    public static boolean isIssuedTokenEnabled() {
        return isIssuedTokenEnabled;
    }

    public static boolean isSSLRequired() {
        return "SSLRequired".equals(transportSecurityMode) || "ClientCertRequired".equals(transportSecurityMode);
    }

    public static CredentialProvider getCredentialProvider(HeaderList headerList) {
        Header header = headerList.get("http://schemas.xmlsoap.org/ws/2005/02/trust", "IssuedTokens", true);
        if (header == null) {
            header = headerList.get("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "IssuedTokens", true);
        }
        if (header == null) {
            return null;
        }
        SOAPMessage sOAPMessage = null;
        try {
            sOAPMessage = WLMessageFactory.getInstance().getMessageFactory(false).createMessage();
            header.writeTo(sOAPMessage);
            NodeList nodeList = sOAPMessage.getSOAPHeader().getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2005/02/trust", "IssuedTokens");
            if (nodeList.getLength() == 0) {
                nodeList = sOAPMessage.getSOAPHeader().getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "IssuedTokens");
            }
            if (nodeList.getLength() == 0 && WSATTubeHelper.isIssuedTokenEnabled()) {
                throw new WebServiceException("no required issuedToken in the incoming soap message!");
            }
            IssuedTokenCPBuilder issuedTokenCPBuilder = new IssuedTokenCPBuilder();
            Element element = (Element)nodeList.item(0);
            return issuedTokenCPBuilder.issuedTokens(element).build();
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException("fail to import issuedToken!", (Throwable)sOAPException);
        }
    }

    public static ClientPolicyFeature getPolicyFeature(WSCBuilderFactory wSCBuilderFactory) {
        if (isIssuedTokenEnabled) {
            return wSCBuilderFactory.newWSATReqistrationClientPolicyFeatureBuilder().newClientPolicyFeature();
        }
        return null;
    }

    public static TransactionalAttribute getTransactionalAttribute(TransactionalFeature transactionalFeature, Packet packet, WSDLPort wSDLPort) {
        if (wSDLPort == null) {
            boolean bl;
            boolean bl2 = transactionalFeature.isEnabled() && Transactional.TransactionFlowType.NEVER != transactionalFeature.getFlowType();
            boolean bl3 = bl = Transactional.TransactionFlowType.MANDATORY == transactionalFeature.getFlowType();
            if (WSATHelper.isDebugEnabled()) {
                WSATTubeHelper.debug("no wsdl port found, the effective transaction attribute is: enabled(" + bl2 + "),required(" + bl + "), version(" + transactionalFeature.getVersion() + ").");
            }
            return new TransactionalAttribute(bl2, bl, transactionalFeature.getVersion());
        }
        WSDLBoundOperation wSDLBoundOperation = packet.getMessage().getOperation(wSDLPort);
        if (wSDLBoundOperation != null && wSDLBoundOperation.getOperation() != null && !wSDLBoundOperation.getOperation().isOneWay()) {
            boolean bl;
            String string = wSDLBoundOperation.getName().getLocalPart();
            boolean bl4 = transactionalFeature.isEnabled(string) && Transactional.TransactionFlowType.NEVER != transactionalFeature.getFlowType(string);
            boolean bl5 = bl = Transactional.TransactionFlowType.MANDATORY == transactionalFeature.getFlowType(string);
            if (WSATHelper.isDebugEnabled()) {
                WSATTubeHelper.debug("the effective transaction attribute for operation' " + string + "' is : enabled(" + bl4 + "),required(" + bl + "), version(" + transactionalFeature.getVersion() + ").");
            }
            return new TransactionalAttribute(bl4, bl, transactionalFeature.getVersion());
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATTubeHelper.debug("no twoway operation found for this request, the effective transaction attribute is disabled.");
        }
        return new TransactionalAttribute(false, false, Transactional.Version.DEFAULT);
    }

    static Transaction getTransaction() {
        return (Transaction)WSATTubeHelper.getTransactionHelper().getTransaction();
    }

    static TransactionHelper getTransactionHelper() {
        return TransactionHelper.getTransactionHelper();
    }

    static String getWSATTxIdForTransaction(Transaction transaction) {
        return TransactionIdHelper.getInstance().xid2wsatid((WLXid)transaction.getXID());
    }

    private static void debug(String string) {
        WSATHelper.getInstance().debug("WSATTubeHelper:" + string);
    }

    static {
        DomainMBean domainMBean;
        isIssuedTokenEnabled = false;
        transportSecurityMode = "SSLRequired";
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess != null && (domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain()) != null) {
            JTAMBean jTAMBean = domainMBean.getJTA();
            if (jTAMBean != null) {
                isIssuedTokenEnabled = jTAMBean.isWSATIssuedTokenEnabled();
            }
            transportSecurityMode = jTAMBean.getWSATTransportSecurityMode();
        }
    }
}

