/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.tube;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.tubeline.TubeFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.WSATConstants;
import weblogic.wsee.wstx.wsat.policy.ATPolicyHelper;
import weblogic.wsee.wstx.wsat.tube.WSATClientTube;
import weblogic.wsee.wstx.wsat.tube.WSATServerTube;
import weblogic.wsee.wstx.wsat.tube.WSATTubeHelper;
import weblogic.wsee.wstx.wsat.validation.TXAttributesValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATTubelineDeploymentListener
implements TubelineDeploymentListener {
    private static final Logger LOGGER = Logger.getLogger(WSATTubelineDeploymentListener.class.getName());
    private static boolean isOnServer = KernelStatus.isServer();

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        EnvironmentFactory environmentFactory;
        if (!isOnServer) {
            return;
        }
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        final TransactionalFeature transactionalFeature = this.getTransactionalFeature(wSBinding, environmentFactory = JAXRPCEnvironmentFeature.getFactory(clientTubeAssemblerContext), true);
        if (transactionalFeature == null || !transactionalFeature.isEnabled()) {
            return;
        }
        TubeFactory tubeFactory = new TubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return new WSATClientTube(tube, clientTubeAssemblerContext, transactionalFeature);
            }

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return tube;
            }
        };
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem("WSATClient", tubeFactory);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("WS_SECURITY_1.1");
        tubelineAssemblerItem.setGoAfter(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("ADDRESSING_HANDLER");
        tubelineAssemblerItem.setGoBefore(hashSet2);
        set.add(tubelineAssemblerItem);
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        EnvironmentFactory environmentFactory;
        if (!isOnServer) {
            return;
        }
        WSEndpoint wSEndpoint = serverTubeAssemblerContext.getEndpoint();
        WSBinding wSBinding = wSEndpoint.getBinding();
        final TransactionalFeature transactionalFeature = this.getTransactionalFeature(wSBinding, environmentFactory = JAXRPCEnvironmentFeature.getFactory(wSEndpoint), false);
        if (transactionalFeature == null || !transactionalFeature.isEnabled()) {
            return;
        }
        this.validateEJBTxAttributes(serverTubeAssemblerContext, transactionalFeature);
        Iterable iterable = serverTubeAssemblerContext.getWsdlModel().getBinding().getPortType().getOperations();
        WSATTubelineDeploymentListener.inheritATAtrtibuteFromPortLevel(iterable, transactionalFeature);
        TubeFactory tubeFactory = new TubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return tube;
            }

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return new WSATServerTube(tube, serverTubeAssemblerContext, transactionalFeature);
            }
        };
        Set set2 = ((BindingImpl)environmentFactory.getBinding()).getKnownHeaders();
        this.registerKnownHeaders(transactionalFeature, set2);
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem("WSATServer", tubeFactory);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("POST_WS_SECURITY_POLICY_1.2");
        hashSet.add("OWSM_SECURITY_POLICY_HANDLER");
        tubelineAssemblerItem.setGoAfter(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("ADDRESSING_HANDLER");
        tubelineAssemblerItem.setGoBefore(hashSet2);
        set.add(tubelineAssemblerItem);
    }

    private void validateEJBTxAttributes(ServerTubeAssemblerContext serverTubeAssemblerContext, TransactionalFeature transactionalFeature) {
        DeployInfo deployInfo = (DeployInfo)serverTubeAssemblerContext.getEndpoint().getContainer().getSPI(DeployInfo.class);
        if (deployInfo != null && deployInfo instanceof EJBDeployInfo) {
            EJBDeployInfo eJBDeployInfo = (EJBDeployInfo)deployInfo;
            Map<String, Short> map = eJBDeployInfo.getTransactionAttributes();
            if (map == null) {
                return;
            }
            Short s = map.get("--*");
            if (s != null) {
                this.validateProviderBasedEJB(serverTubeAssemblerContext, transactionalFeature, s);
            } else {
                this.validSEIBasedEJB(transactionalFeature, map);
            }
        }
    }

    private void validSEIBasedEJB(TransactionalFeature transactionalFeature, Map<String, Short> map) {
        TXAttributesValidator tXAttributesValidator = new TXAttributesValidator();
        Set<Map.Entry<String, Short>> set = map.entrySet();
        for (Map.Entry<String, Short> entry : set) {
            Transactional.TransactionFlowType transactionFlowType = transactionalFeature.getFlowType(entry.getKey());
            tXAttributesValidator.visitOperation(entry.getKey(), entry.getValue(), transactionFlowType);
        }
        tXAttributesValidator.validate();
    }

    private void validateProviderBasedEJB(ServerTubeAssemblerContext serverTubeAssemblerContext, TransactionalFeature transactionalFeature, Short s) {
        if (s != null) {
            TXAttributesValidator tXAttributesValidator = new TXAttributesValidator();
            Iterable iterable = serverTubeAssemblerContext.getWsdlModel().getBinding().getPortType().getOperations();
            for (WSDLOperation wSDLOperation : iterable) {
                String string = wSDLOperation.getName().getLocalPart();
                Transactional.TransactionFlowType transactionFlowType = transactionalFeature.getFlowType(string);
                tXAttributesValidator.visitOperation(string, s, transactionFlowType);
            }
            tXAttributesValidator.validate();
        }
    }

    private TransactionalFeature getTransactionalFeature(WSBinding wSBinding, EnvironmentFactory environmentFactory, boolean bl) {
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort == null) {
            if (bl && wSBinding.getSOAPVersion() != null) {
                return (TransactionalFeature)wSBinding.getFeature(TransactionalFeature.class);
            }
            return null;
        }
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        QName qName = wSDLPort.getName();
        WsPort wsPort = singletonService.getPort(qName.getLocalPart());
        PolicyServer policyServer = singletonService.getPolicyServer();
        TransactionalFeature transactionalFeature = (TransactionalFeature)wSBinding.getFeature(TransactionalFeature.class);
        if (transactionalFeature == null) {
            transactionalFeature = ATPolicyHelper.buildFeatureFromWsdl(wsPort.getWsdlPort(), policyServer);
            if (bl && transactionalFeature != null) {
                ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)transactionalFeature);
            }
        }
        return transactionalFeature;
    }

    private void registerKnownHeaders(TransactionalFeature transactionalFeature, Set<QName> set) {
        boolean bl = isOnServer && WSATTubeHelper.isIssuedTokenEnabled();
        Transactional.Version version2 = transactionalFeature.getVersion();
        if (version2 == Transactional.Version.WSAT10) {
            this.addWSAT10Header(set, bl);
        } else if (version2 == Transactional.Version.DEFAULT) {
            this.addWSAT10Header(set, bl);
            this.addWSAT11Header(set, bl);
        } else if (version2 == Transactional.Version.WSAT11 || version2 == Transactional.Version.WSAT12) {
            this.addWSAT11Header(set, bl);
        }
    }

    private void addWSAT11Header(Set<QName> set, boolean bl) {
        set.add(WSATConstants.WSCOOR11_CONTEXT_QNAME);
        if (bl) {
            set.add(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "IssuedTokens"));
        }
    }

    private void addWSAT10Header(Set<QName> set, boolean bl) {
        set.add(WSATConstants.WSCOOR_CONTEXT_QNAME);
        if (bl) {
            set.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "IssuedTokens"));
        }
    }

    private static void inheritATAtrtibuteFromPortLevel(Iterable<? extends WSDLOperation> iterable, TransactionalFeature transactionalFeature) {
        for (WSDLOperation wSDLOperation : iterable) {
            String string = wSDLOperation.getName().getLocalPart();
            if (!wSDLOperation.isOneWay()) {
                if (!transactionalFeature.isEnabled(string)) continue;
                transactionalFeature.setEnabled(string, transactionalFeature.isEnabled(string));
                transactionalFeature.setFlowType(string, transactionalFeature.getFlowType(string));
                continue;
            }
            transactionalFeature.setEnabled(string, false);
        }
    }
}

