/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsat.validation;

import java.util.HashSet;
import java.util.Set;
import javax.ejb.TransactionAttributeType;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.wstx.wsat.Transactional;

public class TXAttributesValidator {
    public static final short TX_NOT_SET = -1;
    public static final short TX_NOT_SUPPORTED = 0;
    public static final short TX_REQUIRED = 1;
    public static final short TX_SUPPORTS = 2;
    public static final short TX_REQUIRES_NEW = 3;
    public static final short TX_MANDATORY = 4;
    public static final short TX_NEVER = 5;
    Set<InvalidCombination> inValidateCombinations = new HashSet<InvalidCombination>();
    static Set<Combination> validateCombinations = new HashSet<Combination>();

    public void visitOperation(String string, short s, Transactional.TransactionFlowType transactionFlowType) {
        TransactionAttributeType transactionAttributeType = TXAttributesValidator.fromIndex(s);
        this.visitOperation(string, transactionAttributeType, transactionFlowType);
    }

    public void validate() throws WebServiceException {
        StringBuilder stringBuilder = new StringBuilder();
        for (InvalidCombination invalidCombination : this.inValidateCombinations) {
            stringBuilder.append("The effective TransactionAttributeType " + invalidCombination.ejbTx).append(" and WS-AT Transaction flowType ").append(invalidCombination.wsat).append(" on WebService operation ").append(invalidCombination.operationName).append(" is not a valid combination! ");
        }
        if (stringBuilder.length() > 0) {
            throw new WebServiceException(stringBuilder.toString());
        }
    }

    public void visitOperation(String string, TransactionAttributeType transactionAttributeType, Transactional.TransactionFlowType transactionFlowType) {
        Combination combination;
        if (transactionFlowType == null) {
            transactionFlowType = Transactional.TransactionFlowType.NEVER;
        }
        if (!validateCombinations.contains(combination = new Combination(transactionAttributeType, transactionFlowType))) {
            this.inValidateCombinations.add(new InvalidCombination(transactionAttributeType, transactionFlowType, string));
        }
    }

    public static boolean isValid(TransactionAttributeType transactionAttributeType, Transactional.TransactionFlowType transactionFlowType) {
        return validateCombinations.contains(new Combination(transactionAttributeType, transactionFlowType));
    }

    private static TransactionAttributeType fromIndex(Short s) {
        switch (s) {
            case 0: {
                return TransactionAttributeType.NOT_SUPPORTED;
            }
            case 1: {
                return TransactionAttributeType.REQUIRED;
            }
            case 2: {
                return TransactionAttributeType.SUPPORTS;
            }
            case 3: {
                return TransactionAttributeType.REQUIRES_NEW;
            }
            case 4: {
                return TransactionAttributeType.MANDATORY;
            }
            case 5: {
                return TransactionAttributeType.NEVER;
            }
        }
        return TransactionAttributeType.SUPPORTS;
    }

    static {
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRED, Transactional.TransactionFlowType.MANDATORY));
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRED, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.MANDATORY, Transactional.TransactionFlowType.MANDATORY));
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRED, Transactional.TransactionFlowType.SUPPORTS));
        validateCombinations.add(new Combination(TransactionAttributeType.SUPPORTS, Transactional.TransactionFlowType.SUPPORTS));
        validateCombinations.add(new Combination(TransactionAttributeType.REQUIRES_NEW, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.NEVER, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.NOT_SUPPORTED, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.SUPPORTS, Transactional.TransactionFlowType.NEVER));
        validateCombinations.add(new Combination(TransactionAttributeType.SUPPORTS, Transactional.TransactionFlowType.MANDATORY));
    }

    static class InvalidCombination {
        TransactionAttributeType ejbTx;
        Transactional.TransactionFlowType wsat;
        String operationName;

        InvalidCombination(TransactionAttributeType transactionAttributeType, Transactional.TransactionFlowType transactionFlowType, String string) {
            this.ejbTx = transactionAttributeType;
            this.wsat = transactionFlowType;
            this.operationName = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InvalidCombination invalidCombination = (InvalidCombination)object;
            if (this.ejbTx != invalidCombination.ejbTx) {
                return false;
            }
            if (!this.operationName.equals(invalidCombination.operationName)) {
                return false;
            }
            return this.wsat == invalidCombination.wsat;
        }

        public int hashCode() {
            int n = this.ejbTx.hashCode();
            n = 31 * n + this.wsat.hashCode();
            n = 31 * n + this.operationName.hashCode();
            return n;
        }
    }

    static class Combination {
        TransactionAttributeType ejbTx;
        Transactional.TransactionFlowType wsat;

        Combination(TransactionAttributeType transactionAttributeType, Transactional.TransactionFlowType transactionFlowType) {
            this.ejbTx = transactionAttributeType;
            this.wsat = transactionFlowType;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Combination combination = (Combination)object;
            if (this.ejbTx != combination.ejbTx) {
                return false;
            }
            return this.wsat == combination.wsat;
        }

        public int hashCode() {
            int n = this.ejbTx.hashCode();
            n = 31 * n + this.wsat.hashCode();
            return n;
        }
    }
}

