/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsc.common.types.CoordinationContextIF;
import weblogic.wsee.wstx.wsc.v10.CoordinationContextBuilderImpl;

public abstract class CoordinationContextBuilder {
    protected String coordinationType;
    protected String identifier;
    protected long expires;
    protected String address;
    protected String txId;
    protected boolean mustUnderstand;
    protected SOAPVersion soapVersion;
    protected Header coordinationHeader;
    Transactional.Version version;

    public static CoordinationContextBuilder newInstance(Transactional.Version version2) {
        if (Transactional.Version.WSAT10 == version2) {
            return new CoordinationContextBuilderImpl();
        }
        if (Transactional.Version.WSAT11 == version2 || Transactional.Version.WSAT12 == version2) {
            return new weblogic.wsee.wstx.wsc.v11.CoordinationContextBuilderImpl();
        }
        throw new IllegalArgumentException(version2 + "is not a supported ws-at version");
    }

    public static CoordinationContextBuilder headers(HeaderList headerList, Transactional.Version version2) {
        CoordinationContextBuilder coordinationContextBuilder = null;
        for (int i = 0; i < headerList.size(); ++i) {
            Header header = headerList.get(i);
            if (!header.getLocalPart().equals("CoordinationContext")) continue;
            if ("http://schemas.xmlsoap.org/ws/2004/10/wscoor".equals(header.getNamespaceURI())) {
                if (version2 == Transactional.Version.WSAT10 || version2 == Transactional.Version.DEFAULT) {
                    coordinationContextBuilder = new CoordinationContextBuilderImpl();
                    coordinationContextBuilder.version = Transactional.Version.WSAT10;
                }
            } else if ("http://docs.oasis-open.org/ws-tx/wscoor/2006/06".equals(header.getNamespaceURI()) && version2 != Transactional.Version.WSAT10) {
                coordinationContextBuilder = new weblogic.wsee.wstx.wsc.v11.CoordinationContextBuilderImpl();
                coordinationContextBuilder.version = Transactional.Version.WSAT11;
            }
            if (coordinationContextBuilder == null) continue;
            headerList.understood(i);
            return coordinationContextBuilder.header(header);
        }
        return null;
    }

    public Transactional.Version getVersion() {
        return this.version;
    }

    public CoordinationContextBuilder address(String string) {
        this.address = string;
        return this;
    }

    public CoordinationContextBuilder txId(String string) {
        this.txId = string;
        return this;
    }

    public CoordinationContextBuilder identifier(String string) {
        this.identifier = string;
        return this;
    }

    public CoordinationContextBuilder expires(long l) {
        this.expires = l;
        return this;
    }

    public CoordinationContextBuilder mustUnderstand(boolean bl) {
        this.mustUnderstand = bl;
        return this;
    }

    public CoordinationContextBuilder soapVersion(SOAPVersion sOAPVersion) {
        this.soapVersion = sOAPVersion;
        return this;
    }

    public CoordinationContextBuilder coordinationType(String string) {
        this.coordinationType = string;
        return this;
    }

    CoordinationContextBuilder header(Header header) {
        this.coordinationHeader = header;
        return this;
    }

    public CoordinationContextIF buildFromHeader() {
        return this._fromHeader(this.coordinationHeader);
    }

    protected abstract CoordinationContextIF _fromHeader(Header var1);

    public abstract CoordinationContextIF build();

    public abstract JAXBRIContext getJAXBRIContext();
}

