/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common;

import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.wstx.wsat.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndpointReferenceBuilder<T extends EndpointReference> {
    protected String address;
    protected List<Element> referenceParameters = new ArrayList<Element>();

    public static EndpointReferenceBuilder newInstance(Transactional.Version version2) {
        if (Transactional.Version.WSAT10 == version2 || Transactional.Version.DEFAULT == version2) {
            return EndpointReferenceBuilder.MemberSubmission();
        }
        if (Transactional.Version.WSAT11 == version2 || Transactional.Version.WSAT12 == version2) {
            return EndpointReferenceBuilder.W3C();
        }
        throw new IllegalArgumentException(version2 + "is not a supported ws-at version");
    }

    public static EndpointReferenceBuilder<W3CEndpointReference> W3C() {
        return new W3CEndpointReferenceBuilder();
    }

    public static EndpointReferenceBuilder<MemberSubmissionEndpointReference> MemberSubmission() {
        return new MemberSubmissionEndpointReferenceBuilder();
    }

    public EndpointReferenceBuilder<T> address(String string) {
        this.address = string;
        return this;
    }

    public EndpointReferenceBuilder<T> referenceParameter(Element ... elementArray) {
        for (Element element : elementArray) {
            this.referenceParameters.add(element);
        }
        return this;
    }

    public EndpointReferenceBuilder<T> referenceParameter(Node ... nodeArray) {
        for (Node node : nodeArray) {
            this.referenceParameters.add((Element)node);
        }
        return this;
    }

    public EndpointReferenceBuilder<T> referenceParameter(List<Element> list) {
        this.referenceParameters.addAll(list);
        return this;
    }

    public abstract T build();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberSubmissionEndpointReferenceBuilder
    extends EndpointReferenceBuilder<MemberSubmissionEndpointReference> {
        MemberSubmissionEndpointReferenceBuilder() {
        }

        @Override
        public MemberSubmissionEndpointReference build() {
            MemberSubmissionEndpointReference memberSubmissionEndpointReference = new MemberSubmissionEndpointReference();
            memberSubmissionEndpointReference.addr = new MemberSubmissionEndpointReference.Address();
            memberSubmissionEndpointReference.addr.uri = this.address;
            memberSubmissionEndpointReference.referenceParameters = new MemberSubmissionEndpointReference.Elements();
            memberSubmissionEndpointReference.referenceParameters.elements = new ArrayList();
            memberSubmissionEndpointReference.referenceParameters.elements.addAll(this.referenceParameters);
            return memberSubmissionEndpointReference;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class W3CEndpointReferenceBuilder
    extends EndpointReferenceBuilder<W3CEndpointReference> {
        W3CEndpointReferenceBuilder() {
        }

        @Override
        public W3CEndpointReference build() {
            javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder w3CEndpointReferenceBuilder = new javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder();
            for (int i = 0; i < this.referenceParameters.size(); ++i) {
                Element element = (Element)this.referenceParameters.get(i);
                w3CEndpointReferenceBuilder.referenceParameter(element);
            }
            W3CEndpointReference w3CEndpointReference = w3CEndpointReferenceBuilder.address(this.address).build();
            return w3CEndpointReference;
        }
    }
}

