/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common;

import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EndpointReferenceHelper {
    public static EndpointReferenceHelper newInstance(EndpointReference endpointReference) {
        if (endpointReference == null) {
            throw new IllegalArgumentException("EndpointReference can't be null");
        }
        if (endpointReference instanceof MemberSubmissionEndpointReference) {
            return new MemberSubmissionEndpointReferenceHelper((MemberSubmissionEndpointReference)endpointReference);
        }
        if (endpointReference instanceof W3CEndpointReference) {
            return new W3CEndpointReferenceHelper((W3CEndpointReference)endpointReference);
        }
        throw new IllegalArgumentException(endpointReference.getClass() + "is not a supported EndpointReference");
    }

    public abstract String getAddress();

    public abstract Node[] getReferenceParameters();

    static class W3CEndpointReferenceHelper
    extends EndpointReferenceHelper {
        private static Field address = null;
        private static Field referenceParameters = null;
        private static Class address_class = null;
        private static Class referenceParameters_class = null;
        private static Field uri = null;
        private static Field elements = null;
        W3CEndpointReference epr;

        W3CEndpointReferenceHelper(W3CEndpointReference w3CEndpointReference) {
            this.epr = w3CEndpointReference;
        }

        public String getAddress() {
            try {
                return (String)uri.get(address.get(this.epr));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        public Node[] getReferenceParameters() {
            try {
                return ((List)elements.get(referenceParameters.get(this.epr))).toArray(new Element[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        static {
            try {
                address = W3CEndpointReference.class.getDeclaredField("address");
                address.setAccessible(true);
                referenceParameters = W3CEndpointReference.class.getDeclaredField("referenceParameters");
                referenceParameters.setAccessible(true);
                address_class = Class.forName("javax.xml.ws.wsaddressing.W3CEndpointReference$Address");
                referenceParameters_class = Class.forName("javax.xml.ws.wsaddressing.W3CEndpointReference$Elements");
                uri = address_class.getDeclaredField("uri");
                uri.setAccessible(true);
                elements = referenceParameters_class.getDeclaredField("elements");
                elements.setAccessible(true);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    static class MemberSubmissionEndpointReferenceHelper
    extends EndpointReferenceHelper {
        MemberSubmissionEndpointReference epr;

        MemberSubmissionEndpointReferenceHelper(MemberSubmissionEndpointReference memberSubmissionEndpointReference) {
            this.epr = memberSubmissionEndpointReference;
        }

        public String getAddress() {
            return this.epr.addr.uri;
        }

        public Node[] getReferenceParameters() {
            return this.epr.referenceParameters.elements.toArray(new Element[0]);
        }
    }
}

