/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterResponseType;

public class PendingRequestManager {
    private static final Logger logger = Logger.getLogger(PendingRequestManager.class.getName());
    static ConcurrentHashMap<String, ResponseBox> pendingRequests = new ConcurrentHashMap();

    public static ResponseBox reqisterRequest(String string) {
        ResponseBox responseBox = new ResponseBox();
        pendingRequests.put(string, responseBox);
        return responseBox;
    }

    public static void removeRequest(String string) {
        pendingRequests.remove(string);
    }

    public static void registryReponse(String string, BaseRegisterResponseType baseRegisterResponseType) {
        ResponseBox responseBox;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("get a repsonse for request:\t" + string);
        }
        if ((responseBox = pendingRequests.remove(string)) != null) {
            responseBox.put(baseRegisterResponseType);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("ignore reponse for timed out request:\t" + string);
        }
    }

    public static class ResponseBox {
        private boolean isSet = false;
        private BaseRegisterResponseType type;

        ResponseBox() {
        }

        public synchronized void put(BaseRegisterResponseType baseRegisterResponseType) {
            this.type = baseRegisterResponseType;
            this.isSet = true;
            this.notify();
        }

        public synchronized BaseRegisterResponseType getReponse(long l) {
            long l2 = System.currentTimeMillis();
            while (!this.isSet) {
                try {
                    this.wait(l);
                    long l3 = System.currentTimeMillis();
                    if ((l -= l3 - l2) <= 0L) break;
                    l2 = l3;
                }
                catch (InterruptedException interruptedException) {
                    throw new WebServiceException((Throwable)interruptedException);
                }
            }
            return this.type;
        }
    }
}

