/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common;

import com.sun.xml.ws.api.SOAPVersion;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsc.common.CoordinationContextBuilder;
import weblogic.wsee.wstx.wsc.common.types.CoordinationContextIF;
import weblogic.wsee.wstx.wsc.v10.WSATCoordinationContextBuilderImpl;

public abstract class WSATCoordinationContextBuilder {
    protected String coordinationType;
    protected String identifier;
    protected long expires;
    protected String registrationCoordinatorAddress;
    protected String txId;
    protected boolean mustUnderstand = false;
    protected SOAPVersion soapVersion = SOAPVersion.SOAP_11;

    public static WSATCoordinationContextBuilder newInstance(Transactional.Version version2) {
        if (Transactional.Version.WSAT10 == version2) {
            return new WSATCoordinationContextBuilderImpl();
        }
        if (Transactional.Version.WSAT11 == version2 || Transactional.Version.WSAT12 == version2) {
            return new weblogic.wsee.wstx.wsc.v11.WSATCoordinationContextBuilderImpl();
        }
        throw new IllegalArgumentException(version2 + "is not a supported ws-at version");
    }

    public WSATCoordinationContextBuilder txId(String string) {
        this.txId = string;
        return this;
    }

    public WSATCoordinationContextBuilder registrationCoordinatorAddress(String string) {
        this.registrationCoordinatorAddress = string;
        return this;
    }

    public WSATCoordinationContextBuilder soapVersion(SOAPVersion sOAPVersion) {
        if (sOAPVersion == null) {
            throw new IllegalArgumentException("SOAP version can't null!");
        }
        this.soapVersion = sOAPVersion;
        return this;
    }

    public WSATCoordinationContextBuilder mustUnderstand(boolean bl) {
        this.mustUnderstand = bl;
        return this;
    }

    public WSATCoordinationContextBuilder expires(long l) {
        this.expires = l;
        return this;
    }

    public CoordinationContextIF build() {
        CoordinationContextBuilder coordinationContextBuilder = this.configBuilder();
        return coordinationContextBuilder.build();
    }

    private CoordinationContextBuilder configBuilder() {
        if (this.registrationCoordinatorAddress == null) {
            this.registrationCoordinatorAddress = this.getDefaultRegistrationCoordinatorAddress();
        }
        CoordinationContextBuilder coordinationContextBuilder = this.newCoordinationContextBuilder();
        coordinationContextBuilder.coordinationType(this.getCoordinationType()).address(this.registrationCoordinatorAddress).identifier("urn:uuid:" + this.txId).txId(this.txId).expires(this.expires).soapVersion(this.soapVersion).mustUnderstand(this.mustUnderstand);
        return coordinationContextBuilder;
    }

    protected abstract CoordinationContextBuilder newCoordinationContextBuilder();

    protected abstract String getCoordinationType();

    protected abstract String getDefaultRegistrationCoordinatorAddress();
}

