/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.security.ClientPolicyFeatureBuilder;
import weblogic.wsee.wstx.wsat.security.IssuedTokenBuilder;
import weblogic.wsee.wstx.wsc.common.WSATCoordinationContextBuilder;
import weblogic.wsee.wstx.wsc.common.client.RegistrationMessageBuilder;
import weblogic.wsee.wstx.wsc.common.client.RegistrationProxyBuilder;
import weblogic.wsee.wstx.wsc.v10.WSCBuilderFactoryImpl;

public abstract class WSCBuilderFactory {
    public static WSCBuilderFactory newInstance(Transactional.Version version2) {
        if (Transactional.Version.WSAT10 == version2 || Transactional.Version.DEFAULT == version2) {
            return new WSCBuilderFactoryImpl();
        }
        if (Transactional.Version.WSAT11 == version2 || Transactional.Version.WSAT12 == version2) {
            return new weblogic.wsee.wstx.wsc.v11.WSCBuilderFactoryImpl();
        }
        throw new IllegalArgumentException(version2 + "is not a supported ws-at version");
    }

    public static WSCBuilderFactory fromHeaders(HeaderList headerList) {
        WSCBuilderFactory wSCBuilderFactory = null;
        for (int i = 0; i < headerList.size(); ++i) {
            Header header = headerList.get(i);
            if (!header.getLocalPart().equals("CoordinationContext")) continue;
            if ("http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(header.getNamespaceURI())) {
                wSCBuilderFactory = new WSCBuilderFactoryImpl();
            } else if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(header.getNamespaceURI())) {
                wSCBuilderFactory = new weblogic.wsee.wstx.wsc.v11.WSCBuilderFactoryImpl();
            }
            if (wSCBuilderFactory == null) continue;
            headerList.understood(i);
            return wSCBuilderFactory;
        }
        return null;
    }

    public abstract WSATCoordinationContextBuilder newWSATCoordinationContextBuilder();

    public abstract RegistrationProxyBuilder newRegistrationProxyBuilder();

    public abstract RegistrationMessageBuilder newWSATRegistrationRequestBuilder();

    public abstract IssuedTokenBuilder newIssuedTokenBuilder();

    public abstract ClientPolicyFeatureBuilder newWSATReqistrationClientPolicyFeatureBuilder();
}

