/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common.client;

import javax.xml.ws.EndpointReference;
import org.w3c.dom.Element;
import weblogic.wsee.wstx.wsc.common.EndpointReferenceBuilder;
import weblogic.wsee.wstx.wsc.common.WSCUtil;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterResponseType;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterType;

public abstract class RegistrationMessageBuilder {
    protected boolean durable = true;
    protected Element txIdElement;
    protected Element routingElement;
    protected String participantAddress;
    protected String protocolIdentifier;

    public RegistrationMessageBuilder durable(boolean bl) {
        this.durable = bl;
        return this;
    }

    public RegistrationMessageBuilder txId(String string) {
        this.txIdElement = WSCUtil.referenceElementTxId(string);
        return this;
    }

    public RegistrationMessageBuilder routing() {
        this.routingElement = WSCUtil.referenceElementRoutingInfo();
        return this;
    }

    public RegistrationMessageBuilder participantAddress(String string) {
        this.participantAddress = string;
        return this;
    }

    public RegistrationMessageBuilder protocolIdentifier(String string) {
        this.protocolIdentifier = string;
        return this;
    }

    public BaseRegisterType build() {
        if (this.participantAddress == null) {
            this.participantAddress = this.getDefaultParticipantAddress();
        }
        BaseRegisterType baseRegisterType = this.newRegistrationRequest();
        baseRegisterType.setParticipantProtocolService(this.getParticipantProtocolService());
        baseRegisterType.setProtocolIdentifier(this.protocolIdentifier);
        return baseRegisterType;
    }

    protected EndpointReference getParticipantProtocolService() {
        EndpointReferenceBuilder endpointReferenceBuilder = this.getEndpointReferenceBuilder();
        return endpointReferenceBuilder.address(this.participantAddress).referenceParameter(this.txIdElement).referenceParameter(this.routingElement).build();
    }

    protected abstract BaseRegisterType newRegistrationRequest();

    protected abstract String getDefaultParticipantAddress();

    protected abstract BaseRegisterResponseType buildRegistrationResponse();

    protected abstract EndpointReferenceBuilder getEndpointReferenceBuilder();
}

