/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common.client;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import weblogic.wsee.wstx.wsc.common.EndpointReferenceBuilder;
import weblogic.wsee.wstx.wsc.common.PendingRequestManager;
import weblogic.wsee.wstx.wsc.common.RegistrationIF;
import weblogic.wsee.wstx.wsc.common.WSCUtil;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterResponseType;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterType;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

public abstract class RegistrationProxyBuilder {
    protected List<WebServiceFeature> features;
    protected List<CredentialProvider> credentialProviders;
    protected EndpointReference to;
    protected String txId;
    protected long timeout;
    protected String callbackAddress;

    public RegistrationProxyBuilder feature(WebServiceFeature webServiceFeature) {
        if (webServiceFeature == null) {
            return this;
        }
        if (this.features == null) {
            this.features = new ArrayList<WebServiceFeature>();
        }
        this.features.add(webServiceFeature);
        return this;
    }

    public RegistrationProxyBuilder credentialProvider(CredentialProvider credentialProvider) {
        if (credentialProvider == null) {
            return this;
        }
        if (this.credentialProviders == null) {
            this.credentialProviders = new ArrayList<CredentialProvider>();
        }
        this.credentialProviders.add(credentialProvider);
        return this;
    }

    public RegistrationProxyBuilder txIdForReference(String string) {
        this.txId = string;
        return this;
    }

    public RegistrationProxyBuilder to(EndpointReference endpointReference) {
        this.to = endpointReference;
        return this;
    }

    public RegistrationProxyBuilder timeout(long l) {
        this.timeout = l;
        return this;
    }

    public RegistrationProxyBuilder callback(String string) {
        this.callbackAddress = string;
        return this;
    }

    protected abstract String getDefaultCallbackAddress();

    protected abstract EndpointReferenceBuilder getEndpointReferenceBuilder();

    protected WebServiceFeature[] getEnabledFeatures() {
        return this.features.toArray(new WebServiceFeature[0]);
    }

    public RegistrationIF build() {
        if (this.callbackAddress == null) {
            this.callbackAddress = this.getDefaultCallbackAddress();
        }
        Object t = this.getEndpointReferenceBuilder().address(this.callbackAddress).referenceParameter(WSCUtil.referenceElementTxId(this.txId), WSCUtil.referenceElementRoutingInfo()).build();
        WSEndpointReference wSEndpointReference = WSEndpointReference.create(t);
        OneWayFeature oneWayFeature = new OneWayFeature(true, wSEndpointReference);
        this.feature((WebServiceFeature)oneWayFeature);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class RegistrationProxyF<T extends EndpointReference, K, P, D>
    implements RegistrationIF<T, K, P> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BaseRegisterResponseType<T, P> registerOperation(BaseRegisterType<T, K> baseRegisterType) {
            try {
                PendingRequestManager.ResponseBox responseBox = PendingRequestManager.reqisterRequest(RegistrationProxyBuilder.this.txId);
                this.asyncRegister(baseRegisterType.getDelegate());
                BaseRegisterResponseType baseRegisterResponseType = responseBox.getReponse(RegistrationProxyBuilder.this.timeout);
                return baseRegisterResponseType;
            }
            finally {
                PendingRequestManager.removeRequest(RegistrationProxyBuilder.this.txId);
            }
        }

        public abstract D getDelegate();

        public abstract void asyncRegister(K var1);

        public abstract AddressingVersion getAddressingVersion();
    }
}

