/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.wstx.wsc.common.endpoint;

import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import weblogic.transaction.WLXid;
import weblogic.wsee.WseeWsatLogger;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.wstx.TransactionIdHelper;
import weblogic.wsee.wstx.TransactionServices;
import weblogic.wsee.wstx.wsat.Transactional;
import weblogic.wsee.wstx.wsat.WSATException;
import weblogic.wsee.wstx.wsat.WSATFaultFactory;
import weblogic.wsee.wstx.wsat.WSATHelper;
import weblogic.wsee.wstx.wsat.WSATSynchronization;
import weblogic.wsee.wstx.wsat.WSATXAResource;
import weblogic.wsee.wstx.wsc.common.EndpointReferenceBuilder;
import weblogic.wsee.wstx.wsc.common.RegistrationIF;
import weblogic.wsee.wstx.wsc.common.WSCUtil;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterResponseType;
import weblogic.wsee.wstx.wsc.common.types.BaseRegisterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRegistration<T extends EndpointReference, K, P>
implements RegistrationIF<T, K, P> {
    WebServiceContext context;
    Transactional.Version version;

    protected BaseRegistration(WebServiceContext webServiceContext, Transactional.Version version2) {
        this.context = webServiceContext;
        this.version = version2;
    }

    @Override
    public BaseRegisterResponseType<T, P> registerOperation(BaseRegisterType<T, K> baseRegisterType) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logRegisterOperationEntered(baseRegisterType);
        }
        String string = WSATHelper.getInstance().getWSATTidFromWebServiceContextHeaderList(this.context);
        WLXid wLXid = TransactionIdHelper.getInstance().wsatid2xid(string);
        this.checkIssuedTokenAtApplicationLevel(string);
        byte[] byArray = this.processRegisterTypeAndEnlist(baseRegisterType, (Xid)wLXid);
        BaseRegisterResponseType<T, P> baseRegisterResponseType = this.createRegisterResponseType(wLXid, byArray);
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logRegisterOperationExited(baseRegisterResponseType);
        }
        return baseRegisterResponseType;
    }

    byte[] processRegisterTypeAndEnlist(BaseRegisterType<T, K> baseRegisterType, Xid xid) {
        if (baseRegisterType == null) {
            WSATFaultFactory.throwInvalidParametersFault();
        }
        String string = baseRegisterType.getProtocolIdentifier();
        if (baseRegisterType.isDurable()) {
            return this.enlistResource(xid, baseRegisterType.getParticipantProtocolService());
        }
        if (baseRegisterType.isVolatile()) {
            this.registerSynchronization(xid, baseRegisterType.getParticipantProtocolService());
            return null;
        }
        WseeWsatLogger.logUnknownParticipantIdentifier((String)string);
        throw new WebServiceException("unknown participant identifier:" + string);
    }

    BaseRegisterResponseType<T, P> createRegisterResponseType(WLXid wLXid, byte[] byArray) {
        BaseRegisterResponseType<T, P> baseRegisterResponseType = this.newRegisterResponseType();
        String string = this.getCoordinatorAddress();
        String string2 = TransactionIdHelper.getInstance().xid2wsatid(wLXid);
        String string3 = new String(byArray);
        EndpointReferenceBuilder<T> endpointReferenceBuilder = this.getEndpointReferenceBuilder();
        T t = endpointReferenceBuilder.address(string).referenceParameter(WSCUtil.referenceElementTxId(string2), WSCUtil.referenceElementBranchQual(string3), WSCUtil.referenceElementRoutingInfo()).build();
        baseRegisterResponseType.setCoordinatorProtocolService(t);
        return baseRegisterResponseType;
    }

    private byte[] enlistResource(Xid xid, T t) {
        if (WSATHelper.isDebugEnabled()) {
            WseeWsatLogger.logEnlistResource(t, (Object)xid);
        }
        WSATXAResource wSATXAResource = new WSATXAResource(this.version, (EndpointReference)t, xid);
        try {
            byte[] byArray = this.getTransactionServices().enlistResource(wSATXAResource, xid);
            wSATXAResource.setBranchQualifier(byArray);
            return byArray;
        }
        catch (WSATException wSATException) {
            WseeWsatLogger.logExceptionWSATXAResourceEnlist(t, (Object)xid, (Throwable)wSATException);
            throw new WebServiceException((Throwable)wSATException);
        }
    }

    private void registerSynchronization(Xid xid, T t) {
        WseeWsatLogger.logRegisterSynchronization(t, (Object)xid);
        WSATSynchronization wSATSynchronization = new WSATSynchronization(this.version, (EndpointReference)t, xid);
        try {
            this.getTransactionServices().registerSynchronization(wSATSynchronization, xid);
        }
        catch (WSATException wSATException) {
            WseeWsatLogger.logExceptionDuringRegisterSynchronization((Exception)wSATException);
            WSATFaultFactory.throwContextRefusedFault();
        }
    }

    private void checkIssuedTokenAtApplicationLevel(String string) {
        SCCredential sCCredential;
        SOAPMessageContext sOAPMessageContext = EnvironmentFactory.getContext(this.context.getMessageContext());
        SCCredential sCCredential2 = sCCredential = sOAPMessageContext == null ? null : (SCCredential)sOAPMessageContext.getProperty("weblogic.wsee.wssc.sct");
        if (sCCredential != null) {
            String string2;
            String string3 = string2 = sCCredential.getAppliesToElement() == null ? null : sCCredential.getAppliesToElement().getTextContent();
            if (!("urn:uuid:" + string).equals(string2)) {
                if (WSATHelper.isDebugEnabled()) {
                    WSATHelper.getInstance().debug("the token used to protect the registration message doesn't known the coordination identifier");
                }
                throw new WebServiceException("unknown context identifier:" + string);
            }
        }
    }

    protected abstract EndpointReferenceBuilder<T> getEndpointReferenceBuilder();

    protected abstract BaseRegisterResponseType<T, P> newRegisterResponseType();

    protected abstract String getCoordinatorAddress();

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }
}

