/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.corba.internal;

import com.bea.core.jatmi.common.ntrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.wtc.corba.internal.ORBSocketInputStream;
import weblogic.wtc.corba.internal.ORBSocketOutputStream;
import weblogic.wtc.gwt.TuxedoCorbaConnection;
import weblogic.wtc.gwt.TuxedoCorbaConnectionFactory;
import weblogic.wtc.jatmi.BEAObjectKey;
import weblogic.wtc.jatmi.CallDescriptor;
import weblogic.wtc.jatmi.TPException;

public final class ORBSocket
extends Socket {
    private boolean dummyTcpNoDelay;
    private boolean dummyKeepAlive;
    private int dummyRecvBufSize;
    private int dummySendBufSize;
    private boolean dummyLingerEnabled;
    private int dummyLingerValue;
    private int dummyPort;
    private InetAddress dummyInetAddress;
    private int dummyTimeout;
    private ORBSocketInputStream inputStream;
    private ORBSocketOutputStream outputStream;
    private TuxedoCorbaConnection tuxConnection;
    private HashMap outstandingReqMap;

    public ORBSocket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, true);
    }

    public ORBSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, true);
    }

    private ORBSocket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        TuxedoCorbaConnectionFactory tuxedoCorbaConnectionFactory;
        boolean bl2 = ntrace.isTraceEnabled((int)8);
        if (bl2) {
            ntrace.doTrace((String)("[/ORBSocket//" + inetAddress + "/" + n + "/" + bl));
        }
        this.dummyTcpNoDelay = false;
        this.dummyKeepAlive = false;
        this.dummyRecvBufSize = 2048;
        this.dummySendBufSize = 2048;
        this.dummyLingerEnabled = false;
        this.dummyLingerValue = 0;
        this.dummyInetAddress = inetAddress;
        this.dummyPort = n;
        this.dummyTimeout = 0;
        try {
            InitialContext initialContext = new InitialContext();
            tuxedoCorbaConnectionFactory = (TuxedoCorbaConnectionFactory)initialContext.lookup("tuxedo.services.TuxedoCorbaConnection");
        }
        catch (NamingException namingException) {
            throw new IOException("Could not get TuxedoCorbaConnectionFactory : " + namingException);
        }
        catch (Exception exception) {
            throw new IOException("Could not get TuxedoCorbaConnectionFactory : " + exception);
        }
        try {
            this.tuxConnection = tuxedoCorbaConnectionFactory.getTuxedoCorbaConnection();
        }
        catch (TPException tPException) {
            throw new IOException("Could not get TuxedoCorbaConnection : " + (Object)((Object)tPException));
        }
        catch (Exception exception) {
            throw new IOException("Could not get TuxedoCorbaConnection : " + exception);
        }
        this.inputStream = new ORBSocketInputStream(this, this.tuxConnection);
        this.outputStream = new ORBSocketOutputStream(this, this.tuxConnection);
        this.outstandingReqMap = new HashMap();
        if (bl2) {
            ntrace.doTrace((String)"[/ORBSocket//50");
        }
    }

    public InetAddress getInetAddress() {
        return this.dummyInetAddress;
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPort() {
        return this.dummyPort;
    }

    public int getLocalPort() {
        return 0;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.dummyTcpNoDelay = bl;
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.dummyTcpNoDelay;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.dummyLingerEnabled = bl;
        this.dummyLingerValue = n;
    }

    public int getSoLinger() throws SocketException {
        if (this.dummyLingerEnabled) {
            return this.dummyLingerValue;
        }
        return -1;
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.dummyTimeout = n;
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.dummyTimeout;
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this.dummySendBufSize;
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        this.dummyRecvBufSize = n;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.dummyRecvBufSize;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.dummyKeepAlive = bl;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.dummyKeepAlive;
    }

    public synchronized void close() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/close/");
        }
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.tuxConnection.tpterm();
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocket/close/10/IOException" + exception));
                exception.printStackTrace();
            }
            throw new IOException("Could not close ORBSocket : " + exception);
        }
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/close/50");
        }
    }

    public void shutdownInput() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/shutdownInput/");
        }
        try {
            this.inputStream.close();
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocket/shutdownInput/10/IOException" + exception));
            }
            throw new IOException("Could not close ORBSocketInputStream : " + exception);
        }
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/shutdownInput/50");
        }
    }

    public void shutdownOutput() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/shutdownOutput/");
        }
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocket/shutdownOutput/10/IOException" + exception));
            }
            throw new IOException("Could not close ORBSocketOutputStream : " + exception);
        }
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/shutdownOutput/50");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutstandingRequest(CallDescriptor callDescriptor, BEAObjectKey bEAObjectKey) {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocket/addOutstandingRequest/" + callDescriptor + "/" + bEAObjectKey));
        }
        HashMap hashMap = this.outstandingReqMap;
        synchronized (hashMap) {
            this.outstandingReqMap.put(callDescriptor, bEAObjectKey);
        }
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocket/addOutstandingRequest/50");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEAObjectKey removeOutstandingRequest(CallDescriptor callDescriptor) {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocket/removeOutstandingRequest/" + callDescriptor));
        }
        BEAObjectKey bEAObjectKey = null;
        HashMap hashMap = this.outstandingReqMap;
        synchronized (hashMap) {
            bEAObjectKey = (BEAObjectKey)this.outstandingReqMap.remove(callDescriptor);
            if (bEAObjectKey == null && callDescriptor == null && !this.outstandingReqMap.isEmpty()) {
                Set set = this.outstandingReqMap.keySet();
                Iterator iterator = set.iterator();
                bEAObjectKey = (BEAObjectKey)this.outstandingReqMap.remove((CallDescriptor)iterator.next());
            }
        }
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocket/removeOutstandingRequest/50/" + bEAObjectKey));
        }
        return bEAObjectKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallDescriptor getOriginalCallDescriptor(CallDescriptor callDescriptor) {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocket/getOriginalCallDescriptor/" + callDescriptor));
        }
        CallDescriptor callDescriptor2 = null;
        HashMap hashMap = this.outstandingReqMap;
        synchronized (hashMap) {
            if (this.outstandingReqMap.containsKey(callDescriptor)) {
                Set set = this.outstandingReqMap.entrySet();
                for (Map.Entry entry : set) {
                    CallDescriptor callDescriptor3 = (CallDescriptor)entry.getKey();
                    if (!callDescriptor3.equals(callDescriptor)) continue;
                    callDescriptor2 = callDescriptor3;
                    break;
                }
            }
        }
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocket/getOriginalCallDescriptor/50/" + callDescriptor2));
        }
        return callDescriptor2;
    }

    public String toString() {
        return "Socket[addr=" + this.dummyInetAddress + ",port=" + this.dummyPort + "]";
    }
}

