/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.corba.internal;

import com.bea.core.jatmi.common.Utilities;
import com.bea.core.jatmi.common.ntrace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.wtc.corba.internal.ORBSocket;
import weblogic.wtc.gwt.TuxedoCorbaConnection;
import weblogic.wtc.jatmi.BEAObjectKey;
import weblogic.wtc.jatmi.CallDescriptor;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.ReqOid;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TypedBuffer;
import weblogic.wtc.jatmi.TypedTGIOP;

public final class ORBSocketInputStream
extends InputStream {
    ORBSocket orbSocket;
    TuxedoCorbaConnection tuxConnection;
    boolean closed;
    int bufLen;
    int bufOffset;
    byte[] tuxBuf;
    Reply tuxReply;
    TypedTGIOP tuxReplyBuf;

    public ORBSocketInputStream(ORBSocket oRBSocket, TuxedoCorbaConnection tuxedoCorbaConnection) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketInputStream");
        }
        this.orbSocket = oRBSocket;
        this.tuxConnection = tuxedoCorbaConnection;
        this.closed = false;
        this.bufOffset = 0;
        this.bufLen = 0;
        this.tuxBuf = null;
        this.tuxReply = null;
        this.tuxReplyBuf = null;
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketInputStream");
        }
    }

    public synchronized int read() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketInputStream/read");
        }
        if (this.closed) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketInputStream/read/10");
            }
            throw new IOException("Input stream is closed");
        }
        if (this.bufLen == 0) {
            this.getNextReply();
        }
        if (this.bufLen == 0) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketInputStream/read/20");
            }
            throw new IOException("No reply found");
        }
        byte by = this.tuxBuf[this.bufOffset++];
        if (this.bufOffset == this.bufLen) {
            this.bufOffset = 0;
            this.bufLen = 0;
            this.tuxBuf = null;
            this.tuxReply = null;
            this.tuxReplyBuf = null;
        }
        if (bl) {
            ntrace.doTrace((String)("]/ORBSocketInputStream/read/30" + by));
        }
        return by;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketInputStream/read/" + byArray + "/" + n + "/" + n2));
        }
        if (this.closed) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketInputStream/read/10");
            }
            throw new IOException("Input Stream is closed");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.bufLen == 0) {
            this.getNextReply();
        }
        if (this.bufLen == 0) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketInputStream/read/20");
            }
            throw new IOException("No reply found");
        }
        int n3 = this.bufLen - this.bufOffset;
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.tuxBuf, this.bufOffset, byArray, n, n4);
        this.bufOffset += n4;
        if (this.bufOffset == this.bufLen) {
            this.bufOffset = 0;
            this.bufLen = 0;
            this.tuxBuf = null;
            this.tuxReply = null;
            this.tuxReplyBuf = null;
        }
        if (bl) {
            ntrace.doTrace((String)("]/ORBSocketInputStream/read/30/" + n4));
        }
        return n4;
    }

    public int available() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketInputStream/available");
        }
        if (this.closed) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketInputStream/available/10");
            }
            throw new IOException("Input Stream is closed");
        }
        if (bl) {
            ntrace.doTrace((String)("]/ORBSocketInputStream/available/30/" + (this.bufLen - this.bufOffset)));
        }
        return this.bufLen - this.bufOffset;
    }

    public void close() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketInputStream/close");
        }
        this.closed = true;
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketInputStream/close/30");
        }
    }

    private void getNextReply() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketInputStream/getNextReply");
        }
        int n = 128;
        try {
            this.tuxReply = this.tuxConnection.tpgetrply(null, n);
            CallDescriptor callDescriptor = this.tuxReply.getCallDescriptor();
            BEAObjectKey bEAObjectKey = this.orbSocket.removeOutstandingRequest(callDescriptor);
            TypedBuffer typedBuffer = this.tuxReply.getReplyBuffer();
            if (typedBuffer.getHintIndex() != 10 && bl) {
                ntrace.doTrace((String)("[/ORBSocketInputStream/getNextReply/10/" + typedBuffer.getHintIndex() + "/" + callDescriptor + "/" + bEAObjectKey));
            }
            this.tuxReplyBuf = (TypedTGIOP)typedBuffer;
            this.tuxBuf = this.tuxReplyBuf.tgiop;
            this.bufLen = this.tuxReplyBuf.send_size;
            this.bufOffset = 0;
        }
        catch (TPReplyException tPReplyException) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocketInputStream/getNextReply/30/" + (Object)((Object)tPReplyException)));
            }
            this.mapTPExceptionToCorbaException("Could not get reply via WTC : " + (Object)((Object)tPReplyException), tPReplyException.gettperrno(), tPReplyException.getExceptionReply() != null ? tPReplyException.getExceptionReply().getCallDescriptor() : null);
        }
        catch (TPException tPException) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocketInputStream/getNextReply/40/" + (Object)((Object)tPException)));
            }
            this.mapTPExceptionToCorbaException("Could not get reply via WTC : " + (Object)((Object)tPException), tPException.gettperrno(), tPException.getReplyRtn() != null ? tPException.getReplyRtn().getCallDescriptor() : null);
        }
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketInputStream/getNextReply/60");
        }
    }

    private void mapTPExceptionToCorbaException(String string, int n, CallDescriptor callDescriptor) throws IOException {
        String string2;
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketInputStream/mapTPExceptionToCorbaException/" + string + "/" + n + "/" + callDescriptor));
        }
        boolean bl2 = false;
        try {
            if (((ReqOid)callDescriptor).getXID() != null) {
                bl2 = true;
            } else {
                string2 = this.orbSocket.getOriginalCallDescriptor(callDescriptor);
                if (string2 != null && ((ReqOid)string2).getXID() != null) {
                    bl2 = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            switch (n) {
                case 1: {
                    string2 = "IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0";
                    break;
                }
                case 3: {
                    string2 = "IDL:omg.org/CORBA/TRANSIENT:1.0";
                    break;
                }
                case 5: {
                    string2 = "IDL:omg.org/CORBA/NO_RESOURCE:1.0";
                    break;
                }
                case 6: {
                    string2 = "IDL:omg.org/CORBA/NO_IMPLEMENT:1.0";
                    break;
                }
                case 8: {
                    string2 = "IDL:omg.org/CORBA/NO_PERMISSION:1.0";
                    break;
                }
                case 10: {
                    if (bl2) {
                        string2 = "IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0";
                        break;
                    }
                    string2 = "IDL:omg.org/CORBA/OBJ_ADAPTER:1.0";
                    break;
                }
                case 13: {
                    if (bl2) {
                        string2 = "IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0";
                        break;
                    }
                    string2 = "IDL:omg.org/CORBA/NO_RESPONSE:1.0";
                    break;
                }
                case 14: {
                    string2 = "IDL:omg.org/CORBA/INVALIDTRANSACTION:1.0";
                    break;
                }
                case 15: {
                    string2 = "IDL:omg.org/CORBA/TRANSIENT:1.0";
                    break;
                }
                case 17: 
                case 18: {
                    string2 = "IDL:omg.org/CORBA/MARSHAL:1.0";
                    break;
                }
                case 23: {
                    string2 = "IDL:omg.org/CORBA/BAD_INV_ORDER:1.0";
                    break;
                }
                default: {
                    string2 = "IDL:omg.org/CORBA/INTERNAL:1.0";
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            BEAObjectKey bEAObjectKey = this.orbSocket.removeOutstandingRequest(callDescriptor);
            dataOutputStream.write(71);
            dataOutputStream.write(73);
            dataOutputStream.write(79);
            dataOutputStream.write(80);
            if (bEAObjectKey != null) {
                dataOutputStream.write(bEAObjectKey.getMajorVersion());
                dataOutputStream.write(bEAObjectKey.getMinorVersion());
            } else {
                dataOutputStream.write(1);
                dataOutputStream.write(0);
            }
            dataOutputStream.write(0);
            if (bEAObjectKey != null && bEAObjectKey.getMsgType() == 0) {
                dataOutputStream.write(1);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(bEAObjectKey.getRequestId());
                dataOutputStream.writeInt(2);
                this.writeString(dataOutputStream, string2);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(2);
            } else if (bEAObjectKey != null && bEAObjectKey.getMsgType() == 3) {
                dataOutputStream.write(4);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(bEAObjectKey.getRequestId());
                if (bEAObjectKey.getMajorVersion() == 1 && bEAObjectKey.getMinorVersion() <= 1) {
                    dataOutputStream.writeInt(0);
                } else {
                    dataOutputStream.writeInt(4);
                    this.writeString(dataOutputStream, string2);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(2);
                }
            } else {
                dataOutputStream.write(6);
                dataOutputStream.writeInt(0);
            }
            this.tuxBuf = byteArrayOutputStream.toByteArray();
            this.bufLen = byteArrayOutputStream.size();
            this.bufOffset = 0;
            int n2 = this.bufLen - 12;
            this.tuxBuf[8] = (byte)(n2 >>> 24 & 0xFF);
            this.tuxBuf[9] = (byte)(n2 >>> 16 & 0xFF);
            this.tuxBuf[10] = (byte)(n2 >>> 8 & 0xFF);
            this.tuxBuf[11] = (byte)(n2 >>> 0 & 0xFF);
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocketInputStream/mapTPExceptionToCorbaException/50/" + exception));
            }
            throw new IOException("Error creating CORBA System exception: " + exception);
        }
        if (bl) {
            ntrace.doTrace((String)("]/ORBSocketInputStream/mapTPExceptionToCorbaException/60/" + string2 + "/" + this.bufLen + "/" + this.tuxBuf));
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        byte[] byArray = Utilities.getEncBytes((String)string);
        int n = byArray.length + 1;
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
        dataOutputStream.write(0);
        int n2 = n % 4;
        if (n2 > 0) {
            for (int i = 0; i < 4 - n2; ++i) {
                dataOutputStream.write(0);
            }
        }
    }
}

