/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.corba.internal;

import com.bea.core.jatmi.common.ntrace;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.wtc.corba.internal.ORBSocket;
import weblogic.wtc.gwt.TuxedoCorbaConnection;
import weblogic.wtc.jatmi.BEAObjectKey;
import weblogic.wtc.jatmi.CallDescriptor;
import weblogic.wtc.jatmi.ObjinfoImpl;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TypedBuffer;
import weblogic.wtc.jatmi.TypedTGIOP;

public final class ORBSocketOutputStream
extends OutputStream {
    ORBSocket orbSocket;
    TuxedoCorbaConnection tuxConnection;
    boolean closed;
    byte[] hdrBuf;
    int hdrOffset;
    TypedTGIOP tuxTGIOPBuf;
    int bufOffset;
    static final int GIOPBigEndian = 0;

    public ORBSocketOutputStream(ORBSocket oRBSocket, TuxedoCorbaConnection tuxedoCorbaConnection) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketOutputStream");
        }
        this.orbSocket = oRBSocket;
        this.tuxConnection = tuxedoCorbaConnection;
        this.closed = false;
        this.hdrBuf = new byte[12];
        this.hdrOffset = 0;
        this.tuxTGIOPBuf = null;
        this.bufOffset = 0;
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream");
        }
    }

    public synchronized void write(int n) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketOutputStream/write/" + n));
        }
        if (this.closed) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketOutputStream/write/10");
            }
            throw new IOException("Output Stream is closed");
        }
        if (this.hdrOffset == 12) {
            this.tuxTGIOPBuf.tgiop[this.bufOffset++] = (byte)n;
            if (this.bufOffset == this.tuxTGIOPBuf.send_size) {
                this.handleCompleteMsg(this.tuxTGIOPBuf);
            }
        } else {
            this.hdrBuf[this.hdrOffset++] = (byte)n;
            if (this.hdrOffset == 12) {
                this.handleCompleteHdr(this.hdrBuf);
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream/write/50");
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketOutputStream/write/" + byArray + "/" + n + "/" + n2));
        }
        if (this.closed) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketOutputStream/write/10");
            }
            throw new IOException("Output Stream is closed");
        }
        if (this.hdrOffset == 12) {
            this.writeMsgBody(byArray, n, n2);
        } else {
            int n3 = 12 - this.hdrOffset;
            int n4 = n3 < n2 ? n3 : n2;
            System.arraycopy(byArray, n, this.hdrBuf, this.hdrOffset, n4);
            this.hdrOffset += n4;
            if (this.hdrOffset == 12) {
                this.handleCompleteHdr(this.hdrBuf);
                if (n4 < n2) {
                    this.writeMsgBody(byArray, n + n4, n2 - n4);
                }
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream/write/50");
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            boolean bl = ntrace.isTraceEnabled((int)8);
            if (bl) {
                ntrace.doTrace((String)"[/ORBSocketOutputStream/flush");
                ntrace.doTrace((String)"*]/ORBSocketOutputStream/flush/10");
            }
            throw new IOException("Output Stream is closed");
        }
    }

    public void close() throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)"[/ORBSocketOutputStream/close");
        }
        this.closed = true;
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream/close/30");
        }
    }

    private void writeMsgBody(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketOutputStream/writeMsgBody/" + byArray + "/" + n + "/" + n2));
        }
        int n4 = (n3 = this.tuxTGIOPBuf.send_size - this.bufOffset) < n2 ? n3 : n2;
        System.arraycopy(byArray, n, this.tuxTGIOPBuf.tgiop, this.bufOffset, n4);
        this.bufOffset += n4;
        if (this.bufOffset == this.tuxTGIOPBuf.send_size) {
            this.handleCompleteMsg(this.tuxTGIOPBuf);
            if (n4 < n2) {
                this.write(byArray, n + n4, n2 - n4);
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream/writeMsgBody/50");
        }
    }

    private void handleCompleteHdr(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketOutputStream/handleCompleteHdr/" + byArray));
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 79 || byArray[3] != 80) {
            if (bl) {
                ntrace.doTrace((String)"*]/ORBSocketOutputStream/handleCompleteHdr/10");
            }
            throw new IOException("Invalid GIOP message");
        }
        if (byArray[6] == 0) {
            n4 = byArray[8] << 24 & 0xFF000000;
            n3 = byArray[9] << 16 & 0xFF0000;
            n2 = byArray[10] << 8 & 0xFF00;
            n = byArray[11] << 0 & 0xFF;
        } else {
            n4 = byArray[11] << 24 & 0xFF000000;
            n3 = byArray[10] << 16 & 0xFF0000;
            n2 = byArray[9] << 8 & 0xFF00;
            n = byArray[8] << 0 & 0xFF;
        }
        int n5 = (n4 | n3 | n2 | n) + 12;
        this.tuxTGIOPBuf = new TypedTGIOP(n5);
        System.arraycopy(byArray, 0, this.tuxTGIOPBuf.tgiop, 0, 12);
        this.bufOffset = 12;
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream/handleCompleteHdr/50");
        }
    }

    private void handleCompleteMsg(TypedTGIOP typedTGIOP) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)8);
        if (bl) {
            ntrace.doTrace((String)("[/ORBSocketOutputStream/handleCompleteMsg/" + typedTGIOP));
        }
        try {
            this.hdrOffset = 0;
            BEAObjectKey bEAObjectKey = new BEAObjectKey(typedTGIOP);
            ObjinfoImpl objinfoImpl = new ObjinfoImpl(bEAObjectKey, null, null, 0);
            int n = 0;
            int n2 = bEAObjectKey.getMsgType();
            if (n2 == 2 || n2 == 5 || n2 == 6 || n2 == 0 && bEAObjectKey.getResponseExpected() == 0) {
                n |= 4;
            }
            CallDescriptor callDescriptor = this.tuxConnection.tpMethodReq((TypedBuffer)typedTGIOP, objinfoImpl, null, n);
            if ((n & 4) == 0) {
                this.orbSocket.addOutstandingRequest(callDescriptor, bEAObjectKey);
            }
        }
        catch (TPException tPException) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocketOutputStream/handleCompleteMsg/20/" + (Object)((Object)tPException)));
            }
            throw new IOException("Could not send message via WTC : " + (Object)((Object)tPException));
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("*]/ORBSocketOutputStream/handleCompleteMsg/30/" + exception));
                exception.printStackTrace();
            }
            throw new IOException("Could not send message via WTC : " + exception);
        }
        if (bl) {
            ntrace.doTrace((String)"]/ORBSocketOutputStream/handleCompleteMsg/50");
        }
    }
}

