/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.internal.TCTransactionHelper;
import com.bea.core.jatmi.internal.TuxedoXA;
import com.bea.core.jatmi.intf.TCTask;
import com.bea.core.jatmi.intf.TuxedoLoggable;
import java.util.Timer;
import java.util.TimerTask;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.gwt.OatmialCommitterTimer;

class OatmialCommitter
implements TCTask {
    private Xid myXid;
    private TuxedoXA myResource;
    private Timer myTimeService;
    private long myTimeLeft;
    private long myLastTime;
    private boolean myRetry;
    private OatmialCommitterTimer myCommitterTimer;
    private String myName;

    public OatmialCommitter(Xid xid, TuxedoXA tuxedoXA, int n, Timer timer) {
        this.myXid = xid;
        this.myResource = tuxedoXA;
        this.myTimeService = timer;
        this.myTimeLeft = n * 1000;
        this.myLastTime = System.currentTimeMillis();
        this.myCommitterTimer = new OatmialCommitterTimer(this);
        this.myRetry = false;
    }

    public int execute() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        boolean bl2 = false;
        if (bl) {
            ntrace.doTrace((String)("[/OatmialCommitter/execute/" + Thread.currentThread()));
        }
        TuxedoLoggable tuxedoLoggable = null;
        if (this.myXid == null || this.myResource == null) {
            if (bl) {
                ntrace.doTrace((String)"]/OatmialCommitter/execute/10");
            }
            return 0;
        }
        tuxedoLoggable = TCTransactionHelper.createTuxedoLoggable((Xid)this.myXid, (int)2);
        try {
            this.myResource.recoveryCommit(this.myXid, false);
        }
        catch (XAException xAException) {
            bl2 = true;
            WTCLogger.logXAEcommitXid(xAException);
        }
        tuxedoLoggable.forget();
        if (bl2) {
            long l = System.currentTimeMillis();
            this.myTimeLeft -= l - this.myLastTime;
            this.myLastTime = l;
            if (this.myTimeLeft < 0L) {
                this.myCommitterTimer.cancel();
                if (bl) {
                    ntrace.doTrace((String)"/OatmialCommitter/execute/cancelled timer commit retry timer");
                }
            }
            if (!this.myRetry) {
                this.myRetry = true;
                this.myTimeService.schedule((TimerTask)this.myCommitterTimer, 60000L, 60000L);
                if (bl) {
                    ntrace.doTrace((String)"/OatmialCommitter/execute/scheduled next commit retry");
                }
            }
        } else {
            this.myCommitterTimer.cancel();
        }
        if (bl) {
            ntrace.doTrace((String)"]/OatmialCommitter/execute/30");
        }
        return 0;
    }

    public void setTaskName(String string) {
        this.myName = new String("OatmialCommitter$" + string);
    }

    public String getTaskName() {
        if (this.myName == null) {
            return "OatmialCommitter$unknown";
        }
        return this.myName;
    }
}

