/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.internal.TCTransactionHelper;
import com.bea.core.jatmi.intf.TuxedoLoggable;
import java.util.Timer;
import java.util.TimerTask;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.kernel.ExecuteThread;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.gwt.OatmialServices;
import weblogic.wtc.gwt.TDMRemote;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TdomTcb;
import weblogic.wtc.jatmi.TdomTranTcb;
import weblogic.wtc.jatmi.Txid;
import weblogic.wtc.jatmi.gwatmi;
import weblogic.wtc.jatmi.tcb;
import weblogic.wtc.jatmi.tcm;
import weblogic.wtc.jatmi.tfmh;

class OatmialInboundRecover
extends TimerTask {
    private Xid myXid;
    private int myOperation;
    private TDMRemote myRemoteDomain;
    private Timer myTimeService;
    private OatmialServices tos;
    private TuxedoLoggable myTransactionLoggable;
    protected static final int RECOVERED_NOLOG = 0;
    protected static final int RECOVERED_PREPARED = 1;
    protected static final int RECOVERED_COMMITTING = 2;
    protected static final int NOT_RECOVERED_PREPARED = 3;
    protected static final int NOT_RECOVERED_COMMITTING = 4;

    public OatmialInboundRecover(Xid xid, int n, TDMRemote tDMRemote, Timer timer, TuxedoLoggable tuxedoLoggable) {
        this.myXid = xid;
        this.myOperation = n;
        this.myRemoteDomain = tDMRemote;
        this.myTimeService = timer;
        this.myTransactionLoggable = tuxedoLoggable;
        this.tos = WTCService.getOatmialServices();
    }

    public void execute(ExecuteThread executeThread) throws Exception {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/OatmialInboundRecover/execute/" + Thread.currentThread()));
        }
        XAResource xAResource = null;
        TuxedoLoggable tuxedoLoggable = null;
        int n = 0;
        gwatmi gwatmi2 = null;
        int n2 = -1;
        xAResource = TCTransactionHelper.getXAResource();
        if (xAResource == null) {
            if (bl) {
                ntrace.doTrace((String)"]/OatmialInboundRecover/execute/10");
            }
            return;
        }
        switch (this.myOperation) {
            case 0: {
                if (bl) {
                    ntrace.doTrace((String)"RECOVERED_NOLOG");
                }
                try {
                    if (bl) {
                        ntrace.doTrace((String)("myXid = " + this.myXid));
                    }
                    xAResource.rollback(this.myXid);
                }
                catch (XAException xAException) {
                    WTCLogger.logWarningRecoverRollbackFailure(xAException.toString());
                }
                if (bl) {
                    ntrace.doTrace((String)"]/OatmialInboundRecover/execute/20");
                }
                return;
            }
            case 1: {
                if (bl) {
                    ntrace.doTrace((String)"RECOVERED_PREPARED");
                }
                n2 = 8;
                break;
            }
            case 2: {
                if (bl) {
                    ntrace.doTrace((String)"RECOVERED_COMMITTING");
                }
                tuxedoLoggable = this.myTransactionLoggable;
                try {
                    if (bl) {
                        ntrace.doTrace((String)("myXid = " + this.myXid));
                    }
                    xAResource.commit(this.myXid, false);
                }
                catch (XAException xAException) {
                    switch (xAException.errorCode) {
                        case 5: 
                        case 6: {
                            n = 8;
                            break;
                        }
                        default: {
                            n = 16;
                        }
                    }
                }
                n2 = 10;
                break;
            }
            case 4: {
                if (bl) {
                    ntrace.doTrace((String)"NOT_RECOVERED_COMMITTING");
                }
                tuxedoLoggable = this.myTransactionLoggable;
                n2 = 10;
                break;
            }
            case 3: {
                if (bl) {
                    ntrace.doTrace((String)"NOT_RECOVERED_PREPARED");
                }
                tuxedoLoggable = this.myTransactionLoggable;
                tuxedoLoggable.forget();
                return;
            }
            default: {
                if (bl) {
                    ntrace.doTrace((String)("]/OatmialInboundRecover/execute/30/" + this.myOperation));
                }
                return;
            }
        }
        if (this.myRemoteDomain == null) {
            if (bl) {
                ntrace.doTrace((String)"]/OatmialInboundRecover/execute/40");
            }
            return;
        }
        gwatmi2 = this.myRemoteDomain.getTsession(true);
        if (gwatmi2 == null) {
            if (tuxedoLoggable != null) {
                tuxedoLoggable.forget();
            }
            if (n2 == 10) {
                this.tos.deleteInboundRdomsAssociatedWithXid(this.myXid);
                if (bl) {
                    ntrace.doTrace((String)"]/OatmialInboundRecover/execute/50");
                }
                return;
            }
            this.myTimeService.schedule((TimerTask)this, 300000L);
            if (bl) {
                ntrace.doTrace((String)"]/OatmialInboundRecover/execute/60/rescheduled for five minutes");
            }
            return;
        }
        tfmh tfmh2 = new tfmh(1);
        TdomTcb tdomTcb = new TdomTcb(n2, 0, 0, null);
        tdomTcb.set_info(0x20 | n);
        tfmh2.tdom = new tcm(7, (tcb)tdomTcb);
        TdomTranTcb tdomTranTcb = new TdomTranTcb(new Txid(this.myXid.getGlobalTransactionId()));
        tdomTranTcb.setNwtranidparent(new String(this.myXid.getBranchQualifier()));
        tfmh2.tdomtran = new tcm(10, (tcb)tdomTranTcb);
        try {
            gwatmi2.send_transaction_reply(tfmh2);
            if (bl) {
                ntrace.doTrace((String)"reply for transaction recovery sent");
            }
        }
        catch (TPException tPException) {
            WTCLogger.logTPEsendTran((Exception)((Object)tPException));
        }
        if (tuxedoLoggable != null) {
            tuxedoLoggable.forget();
        }
        if (n2 == 10) {
            this.tos.deleteInboundRdomsAssociatedWithXid(this.myXid);
        }
        if (bl) {
            ntrace.doTrace((String)"]/OatmialInboundRecover/execute/70");
        }
    }

    public void run() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/OatmialInboundRecover/run/");
        }
        if (this.tos.getInboundRdomsAssociatedWithXid(this.myXid) == null) {
            if (bl) {
                ntrace.doTrace((String)"]/OatmialInboundRecover/run/10");
            }
            return;
        }
        try {
            this.execute(null);
        }
        catch (Exception exception) {
            if (bl) {
                ntrace.doTrace((String)("]/OatmialInboundRecover/run/20/" + exception));
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"]/OatmialInboundRecover/run/30");
        }
    }
}

