/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.internal.TCTaskHelper;
import com.bea.core.jatmi.intf.TCTask;
import java.util.TimerTask;
import weblogic.logging.Loggable;
import weblogic.management.configuration.WTCRemoteTuxDomMBean;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.gwt.ConnectingWork;
import weblogic.wtc.gwt.TDMLocalTDomain;
import weblogic.wtc.gwt.TDMRemoteTDomain;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.TPException;

class ScheduledReconnect
extends TimerTask {
    private TDMRemoteTDomain rdom;
    private long retryLeft;
    private ConnectingWork conn_work = null;
    private int state;
    private boolean connected = false;
    private static int CONN_ST_INIT = 0;
    private static int CONN_ST_ACTIVE = 1;
    private static int CONN_ST_IDLE = 2;
    private static int CONN_ST_SHUTDOWN = 3;

    ScheduledReconnect(TDMRemoteTDomain tDMRemoteTDomain, long l) {
        this.rdom = tDMRemoteTDomain;
        this.retryLeft = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectingFailure() {
        ScheduledReconnect scheduledReconnect = this;
        synchronized (scheduledReconnect) {
            this.conn_work = null;
        }
        --this.retryLeft;
        if (this.retryLeft <= 0L) {
            this.rdom.removeConnectingTaskReference();
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectingSuccess() {
        ScheduledReconnect scheduledReconnect = this;
        synchronized (scheduledReconnect) {
            this.conn_work = null;
            this.connected = true;
        }
        this.rdom.removeConnectingTaskReference();
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectingTerminate() {
        ScheduledReconnect scheduledReconnect = this;
        synchronized (scheduledReconnect) {
            this.conn_work = null;
            this.connected = false;
        }
        this.rdom.removeConnectingTaskReference();
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl;
        boolean bl2 = ntrace.isTraceEnabled((int)2);
        if (bl2) {
            ntrace.doTrace((String)("[/ScheduledReconnect/run/" + this.rdom.getAccessPoint()));
        }
        ScheduledReconnect scheduledReconnect = this;
        synchronized (scheduledReconnect) {
            bl = this.conn_work == null;
        }
        if (bl) {
            this.conn_work = new ConnectingWork(this, this.rdom);
            TCTaskHelper.schedule((TCTask)this.conn_work);
        }
        if (bl2) {
            ntrace.doTrace((String)"]/ScheduledReconnect/run/10");
        }
    }

    public static TDMRemoteTDomain create(WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean) throws TPException {
        TDMRemoteTDomain tDMRemoteTDomain;
        String string;
        String string2;
        String string3;
        boolean bl = ntrace.isMixedTraceEnabled((int)18);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/create/");
        }
        WTCService wTCService = WTCService.getWTCService();
        String string4 = wTCRemoteTuxDomMBean.getAccessPoint();
        if (string4 == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("AccessPoint", wTCRemoteTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/10/no AP");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("AccessPoint: " + string4));
        }
        if ((string3 = wTCRemoteTuxDomMBean.getAccessPointId()) == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("AccessPointId", wTCRemoteTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/20/no APId");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("AccessPointId:" + string3));
        }
        if ((string2 = wTCRemoteTuxDomMBean.getLocalAccessPoint()) == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("LocalAccessPoint", wTCRemoteTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/30/no LAP");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("LocalAccessPoint:" + string2));
        }
        if ((string = wTCRemoteTuxDomMBean.getNWAddr()) == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("NWAddr", wTCRemoteTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/40/no NWAddr");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("NWAddr:" + string));
        }
        if (bl) {
            ntrace.doTrace((String)("create rtd from " + string4));
        }
        try {
            tDMRemoteTDomain = new TDMRemoteTDomain(string4, wTCService.getUnknownTxidRply(), WTCService.getTimerService());
        }
        catch (Exception exception) {
            Loggable loggable = WTCLogger.logUEconstructTDMRemoteTDLoggable(exception.getMessage());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/50/create failed");
            }
            throw new TPException(4, loggable.getMessage());
        }
        TDMLocalTDomain tDMLocalTDomain = wTCService.getLocalDomain(string2);
        if (null == tDMLocalTDomain) {
            Loggable loggable = WTCLogger.logErrorBadTDMRemoteLTDLoggable(string2);
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/60/no LDOM");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)"valid LocalAccessPoint");
        }
        tDMRemoteTDomain.setLocalAccessPoint(string2);
        tDMRemoteTDomain.setAccessPointId(string3);
        tDMRemoteTDomain.setAclPolicy(wTCRemoteTuxDomMBean.getAclPolicy());
        tDMRemoteTDomain.setCredentialPolicy(wTCRemoteTuxDomMBean.getCredentialPolicy());
        tDMRemoteTDomain.setTpUsrFile(wTCRemoteTuxDomMBean.getTpUsrFile());
        try {
            tDMRemoteTDomain.setNWAddr(string);
        }
        catch (TPException tPException) {
            Loggable loggable = WTCLogger.logInvalidMBeanAttrLoggable("NWAddr", wTCRemoteTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/create/70/" + tPException.getMessage()));
            }
            throw new TPException(4, loggable.getMessage());
        }
        tDMRemoteTDomain.setFederationURL(wTCRemoteTuxDomMBean.getFederationURL());
        tDMRemoteTDomain.setFederationName(wTCRemoteTuxDomMBean.getFederationName());
        try {
            tDMRemoteTDomain.setCmpLimit(wTCRemoteTuxDomMBean.getCmpLimit());
        }
        catch (TPException tPException) {
            Loggable loggable = WTCLogger.logInvalidMBeanAttrLoggable("CmpLimit", wTCRemoteTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/create/80/" + tPException.getMessage()));
            }
            throw new TPException(4, loggable.getMessage());
        }
        String string5 = wTCRemoteTuxDomMBean.getMinEncryptBits();
        if (string5 != null) {
            tDMRemoteTDomain.setMinEncryptBits(Integer.parseInt(string5, 10));
        }
        if ((string5 = wTCRemoteTuxDomMBean.getMaxEncryptBits()) != null) {
            tDMRemoteTDomain.setMaxEncryptBits(Integer.parseInt(string5, 10));
        }
        tDMRemoteTDomain.setConnectionPolicy(wTCRemoteTuxDomMBean.getConnectionPolicy());
        tDMRemoteTDomain.setRetryInterval(wTCRemoteTuxDomMBean.getRetryInterval());
        tDMRemoteTDomain.setMaxRetries(wTCRemoteTuxDomMBean.getMaxRetries());
        tDMRemoteTDomain.setKeepAlive(wTCRemoteTuxDomMBean.getKeepAlive());
        tDMRemoteTDomain.setKeepAliveWait(wTCRemoteTuxDomMBean.getKeepAliveWait());
        String string6 = wTCRemoteTuxDomMBean.getAppKey();
        if (string6 == null && wTCRemoteTuxDomMBean.getTpUsrFile() != null) {
            string6 = new String("TpUsrFile");
            if (bl) {
                ntrace.doTrace((String)"Use dflt AppKey Generator");
            }
        }
        tDMRemoteTDomain.setAppKey(string6);
        tDMRemoteTDomain.setAllowAnonymous(wTCRemoteTuxDomMBean.getAllowAnonymous());
        tDMRemoteTDomain.setDefaultAppKey(wTCRemoteTuxDomMBean.getDefaultAppKey());
        if (string6 != null) {
            if (string6.equals("LDAP")) {
                tDMRemoteTDomain.setTuxedoUidKw(wTCRemoteTuxDomMBean.getTuxedoUidKw());
                tDMRemoteTDomain.setTuxedoGidKw(wTCRemoteTuxDomMBean.getTuxedoGidKw());
                if (bl) {
                    ntrace.doTrace((String)("LDAP, allow=" + wTCRemoteTuxDomMBean.getAllowAnonymous() + ",Dflt AppKey=" + wTCRemoteTuxDomMBean.getDefaultAppKey() + ",UID KW=" + wTCRemoteTuxDomMBean.getTuxedoUidKw() + ", GID KW=" + wTCRemoteTuxDomMBean.getTuxedoGidKw()));
                }
            } else if (string6.equals("Custom")) {
                String string7 = wTCRemoteTuxDomMBean.getCustomAppKeyClass();
                String string8 = wTCRemoteTuxDomMBean.getCustomAppKeyClassParam();
                if (string7 == null) {
                    Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("CustomAppKeyClass", wTCRemoteTuxDomMBean.getName());
                    loggable.log();
                    if (bl) {
                        ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/90/no custom class defined");
                    }
                    throw new TPException(4, loggable.getMessage());
                }
                if (bl) {
                    ntrace.doTrace((String)("Custom, allow=" + wTCRemoteTuxDomMBean.getAllowAnonymous() + ",Dflt AppKey=" + wTCRemoteTuxDomMBean.getDefaultAppKey() + ",Class=" + string7 + ", Parm =" + string8));
                }
                tDMRemoteTDomain.setCustomAppKeyClass(string7);
                tDMRemoteTDomain.setCustomAppKeyClassParam(string8);
            } else {
                if (!string6.equals("TpUsrFile")) {
                    Loggable loggable = WTCLogger.logInvalidMBeanAttrLoggable("AppKey", wTCRemoteTuxDomMBean.getName());
                    loggable.log();
                    if (bl) {
                        ntrace.doTrace((String)"*]/TDMRemoteTDomain/create/100/unsupported appkey");
                    }
                    throw new TPException(4, loggable.getMessage());
                }
                if (bl) {
                    ntrace.doTrace((String)("TpUsrFile, allow=" + wTCRemoteTuxDomMBean.getAllowAnonymous() + ",Dflt AppKey=" + wTCRemoteTuxDomMBean.getDefaultAppKey() + ",File=" + wTCRemoteTuxDomMBean.getTpUsrFile()));
                }
            }
        }
        tDMRemoteTDomain.setMBean(wTCRemoteTuxDomMBean);
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/create/140/success");
        }
        return tDMRemoteTDomain;
    }
}

