/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import java.util.StringTokenizer;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.management.configuration.WTCImportMBean;
import weblogic.wtc.gwt.DServiceInfo;
import weblogic.wtc.gwt.TDMLocal;
import weblogic.wtc.gwt.TDMRemote;
import weblogic.wtc.gwt.TDMRemoteTDomain;
import weblogic.wtc.gwt.WTCMBeanObject;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.TPException;

public final class TDMImport
extends WTCMBeanObject
implements BeanUpdateListener {
    static final long serialVersionUID = -1088113749163657268L;
    private String myResourceName;
    private String myLocalAccessPoint;
    private String[] myRemoteAccessPointList;
    private TDMLocal myLocalAccessPointObject;
    private TDMRemote[] myRemoteAccessPointObjectList;
    private String myRemoteName;
    private int myTranTime;
    private WTCImportMBean mBean = null;
    private boolean registered = false;
    private boolean suspended = false;
    private WTCService myWTC;
    private String myRemoteAccessPointListString = null;

    public TDMImport(String string, TDMLocal tDMLocal, TDMRemote[] tDMRemoteArray) throws Exception {
        if (string == null || tDMLocal == null) {
            throw new Exception("ResourceName and LocalAccessPoint may not be null");
        }
        this.myResourceName = string;
        if (this.myRemoteName == null || this.myRemoteName.length() == 0) {
            this.myRemoteName = string;
        }
        this.myLocalAccessPointObject = tDMLocal;
        this.myLocalAccessPoint = tDMLocal.getAccessPoint();
        int n = tDMRemoteArray.length;
        this.myRemoteAccessPointList = new String[n];
        for (int i = 0; i < n; ++i) {
            TDMRemote tDMRemote = tDMRemoteArray[i];
            if (!this.myLocalAccessPoint.equals(tDMRemote.getLocalAccessPoint())) {
                throw new Exception("A remote access point in list not connected to the local access point");
            }
            this.myRemoteAccessPointList[i] = tDMRemote.getAccessPoint();
        }
        this.myRemoteAccessPointObjectList = tDMRemoteArray;
        this.myTranTime = 30;
        this.myWTC = WTCService.getWTCService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceName() {
        this.r.lock();
        try {
            String string = this.myResourceName;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalAccessPoint() {
        this.r.lock();
        try {
            String string = this.myLocalAccessPoint;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDMLocal getLocalAccessPointObject() {
        this.r.lock();
        try {
            TDMLocal tDMLocal = this.myLocalAccessPointObject;
            return tDMLocal;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRemoteAccessPointList() {
        this.r.lock();
        try {
            String[] stringArray = this.myRemoteAccessPointList;
            return stringArray;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDMRemote[] getRemoteAccessPointObjectList() {
        this.r.lock();
        try {
            TDMRemote[] tDMRemoteArray = this.myRemoteAccessPointObjectList;
            return tDMRemoteArray;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrimaryRemoteAccessPoint() {
        this.r.lock();
        try {
            String string = this.myRemoteAccessPointList[0];
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean hasRemoteDomain(TDMRemote tDMRemote) {
        this.r.lock();
        for (int i = 0; i < this.myRemoteAccessPointList.length; ++i) {
            if (this.myRemoteAccessPointObjectList[i] != tDMRemote) continue;
            this.r.unlock();
            return true;
        }
        this.r.unlock();
        return false;
    }

    public boolean hasActiveTsession() {
        this.r.lock();
        for (int i = 0; i < this.myRemoteAccessPointList.length; ++i) {
            if (!this.myRemoteAccessPointObjectList[i].isObjectActivated() || this.myRemoteAccessPointObjectList[i].getTsession(false) == null) continue;
            this.r.unlock();
            return true;
        }
        this.r.unlock();
        return false;
    }

    public boolean hasDynamicRemotePolicy() {
        this.r.lock();
        for (int i = 0; i < this.myRemoteAccessPointList.length; ++i) {
            String string = this.myRemoteAccessPointObjectList[i].getConnectionPolicy();
            if (string == null || !string.equals("ON_STARTUP") && !string.equals("INCOMING_ONLY")) continue;
            this.r.unlock();
            return true;
        }
        this.r.unlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteName() {
        this.r.lock();
        try {
            if (this.myRemoteName == null || this.myRemoteName.length() == 0) {
                String string = this.myResourceName;
                return string;
            }
            String string = this.myRemoteName;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setRemoteName(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMImport/setRemoteName/name=" + string));
        }
        if (string != null || string.length() != 0) {
            this.w.lock();
            this.myRemoteName = string;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMImport/setRemoteName/10/changed");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/setRemoteName/15/not changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTranTime() {
        this.r.lock();
        try {
            int n = this.myTranTime;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public WTCImportMBean getMBean() {
        return this.mBean;
    }

    public void setTranTime(int n) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMImport/setTranTime/time=" + n));
        }
        if (n >= 0 && n <= Integer.MAX_VALUE) {
            this.w.lock();
            this.myTranTime = n;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMImport/setTranTime/10/changed");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/setTranTime/15/no change");
        }
    }

    public void setResourceName(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string != null && string.length() != 0) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMImport/setResourceName/ResourceName=" + string));
            }
        } else {
            if (bl) {
                ntrace.doTrace((String)"[/TDMImport/setResourceName/ResourceName=null");
                ntrace.doTrace((String)"*]/TDMImport/setResourceName/10/TPEINVAL");
            }
            throw new TPException(4, "ResourceName may not be null");
        }
        String string2 = this.myResourceName;
        this.myResourceName = string;
        this.myWTC.changeImportResourceName(this, string2);
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/setResourceName/20/DONE");
        }
    }

    public void setMBean(WTCImportMBean wTCImportMBean) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (wTCImportMBean != null) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMImport/setMBname/MBeanName=" + wTCImportMBean.getName()));
            }
            if (this.mBean != null) {
                if (this.mBean == wTCImportMBean) {
                    if (bl) {
                        ntrace.doTrace((String)"]/TDMImport/setMBname/10/same, no change");
                    }
                    return;
                }
                this.unregisterListener();
            }
            this.mBean = wTCImportMBean;
            if (bl) {
                ntrace.doTrace((String)"]/TDMImport/setMBname/20/changed");
            }
        } else {
            if (bl) {
                ntrace.doTrace((String)"[/TDMImport/setMBname/MBeanName=null");
            }
            if (this.mBean != null) {
                this.unregisterListener();
                this.mBean = null;
            }
            if (bl) {
                ntrace.doTrace((String)"]/TDMImport/setMBname/30/");
            }
        }
    }

    public void setLocalAccessPoint(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string != null && string.length() != 0) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMImport/setLocalAccessPoint/" + string));
            }
        } else {
            if (bl) {
                ntrace.doTrace((String)"[/TDMImport/setLocalAccessPoint/null");
                ntrace.doTrace((String)"*]/TDMImport/setLocalAccessPoint/10");
            }
            throw new TPException(4, "LocalAccessPoint may not be null");
        }
        this.w.lock();
        this.myLocalAccessPointObject = this.myWTC.getLocalDomain(string);
        this.myLocalAccessPoint = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/setLocalAccessPoint/20/DONE");
        }
    }

    public void setRemoteAccessPointList(String string) throws TPException {
        String[] stringArray;
        TDMRemoteTDomain[] tDMRemoteTDomainArray;
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (string == null || string.length() == 0) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMImport/setRemoteAccessPointList/null");
                ntrace.doTrace((String)"*]/TDMImport/setRemoteAccessPointList/10/List is NULL");
            }
            throw new TPException(4, "RemoteAccessPointList can not be null");
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMImport/setRemoteAccessPointList/" + string));
        }
        if (string.indexOf(44) == -1) {
            TDMRemoteTDomain tDMRemoteTDomain = this.myWTC.getRTDbyAP(string);
            if (tDMRemoteTDomain == null) {
                if (bl) {
                    ntrace.doTrace((String)("*]/TDMImport/setRemoteAccessPointList/20/Unknown RTD name " + string));
                }
                throw new TPException(4, "Unknown Remote TDomain name " + string);
            }
            tDMRemoteTDomainArray = new TDMRemoteTDomain[1];
            stringArray = new String[1];
            tDMRemoteTDomainArray[0] = tDMRemoteTDomain;
            stringArray[0] = string;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            tDMRemoteTDomainArray = new TDMRemoteTDomain[stringTokenizer.countTokens()];
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                if (n > 2) {
                    if (bl) {
                        ntrace.doTrace((String)"*]/TDMImport/setRemoteAccessPointList/40/list size limited to three");
                    }
                    throw new TPException(4, "Remote access point list cannot have more than three elements");
                }
                String string2 = stringTokenizer.nextToken();
                TDMRemoteTDomain tDMRemoteTDomain = this.myWTC.getRTDbyAP(string2);
                if (tDMRemoteTDomain == null) {
                    if (bl) {
                        ntrace.doTrace((String)("*]/TDMImport/setRemoteAccessPointList/50/Known RTDs list does not include " + string2));
                    }
                    throw new TPException(4, "Known RTDs list does not include " + string2);
                }
                tDMRemoteTDomainArray[n] = tDMRemoteTDomain;
                stringArray[n] = string2;
                ++n;
            }
        }
        this.w.lock();
        this.myRemoteAccessPointObjectList = tDMRemoteTDomainArray;
        this.myRemoteAccessPointList = stringArray;
        this.myRemoteAccessPointListString = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/setRemoteAccessPointList/60/DONE");
        }
    }

    public boolean equals(Object object) {
        String[] stringArray;
        String string;
        String string2;
        TDMImport tDMImport = (TDMImport)((Object)object);
        if (tDMImport == this) {
            return true;
        }
        this.r.lock();
        if (tDMImport == null || (string2 = tDMImport.getResourceName()) == null || (string = tDMImport.getLocalAccessPoint()) == null || (stringArray = tDMImport.getRemoteAccessPointList()) == null || stringArray.length != this.myRemoteAccessPointList.length) {
            this.r.unlock();
            return false;
        }
        if (string2.equals(this.myResourceName) && string.equals(this.myLocalAccessPoint)) {
            for (int i = 0; i < this.myRemoteAccessPointList.length; ++i) {
                if (this.myRemoteAccessPointList[i].equals(stringArray[i])) continue;
                this.r.unlock();
                return false;
            }
            this.r.unlock();
            return true;
        }
        this.r.unlock();
        return false;
    }

    public int hashCode() {
        this.r.lock();
        int n = this.myResourceName == null ? 0 : this.myResourceName.hashCode();
        int n2 = this.myLocalAccessPoint == null ? 0 : this.myLocalAccessPoint.hashCode();
        int n3 = 0;
        if (this.myRemoteAccessPointList != null) {
            int n4 = this.myRemoteAccessPointList.length;
            for (int i = 0; i < n4; ++i) {
                n3 += this.myRemoteAccessPointList[i].hashCode();
            }
        }
        this.r.unlock();
        return n + n2 + n3;
    }

    public void setRemoteAccessPointListString(String string) {
        this.myRemoteAccessPointListString = string;
    }

    public static String[] parseCommaSeparatedList(String string) {
        String[] stringArray;
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMImport/parseCommaSeparatedList/string = " + string));
        }
        if (string.indexOf(44) == -1) {
            stringArray = new String[]{string};
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                if (bl) {
                    ntrace.doTrace((String)("Token " + n + ":" + stringArray[n]));
                }
                ++n;
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/parseCommaSeparateList/10/DONE");
        }
        return stringArray;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        Object object;
        String[] stringArray;
        String string;
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        WTCImportMBean wTCImportMBean = (WTCImportMBean)beanUpdateEvent.getProposedBean();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMImport/prepareUpdate");
        }
        if (wTCImportMBean == null) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMImport/prepareUpdate/10/null MBean");
            }
            throw new BeanUpdateRejectedException("A null MBean for TDMImport!");
        }
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            string = propertyUpdateArray[i].getPropertyName();
            int n = propertyUpdateArray[i].getUpdateType();
            if (bl) {
                ntrace.doTrace((String)("i = " + i + ", opType = " + n + ", key = " + string));
            }
            if (n == 1) {
                if (string.equals("ResourceName")) {
                    string2 = wTCImportMBean.getResourceName();
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    if (!bl) continue;
                    ntrace.doTrace((String)("Resource Name:" + string2));
                    continue;
                }
                if (string.equals("LocalAccessPoint")) {
                    string3 = wTCImportMBean.getLocalAccessPoint();
                    if (string3.length() == 0) {
                        string3 = null;
                    }
                    if (!bl) continue;
                    ntrace.doTrace((String)("Local AP:" + string3));
                    continue;
                }
                if (string.equals("RemoteAccessPointList")) {
                    string4 = wTCImportMBean.getRemoteAccessPointList();
                    if (string4.length() == 0) {
                        string4 = null;
                    }
                    if (!bl) continue;
                    ntrace.doTrace((String)("Local AP:" + string4));
                    continue;
                }
                if (string.equals("RemoteName")) {
                    string5 = wTCImportMBean.getRemoteName();
                    if (string5.length() == 0) {
                        string5 = null;
                    }
                    if (!bl) continue;
                    ntrace.doTrace((String)("Remote Name:" + string5));
                    continue;
                }
                if (!bl) continue;
                ntrace.doTrace((String)("Key " + string + " not supported, ignored!"));
                continue;
            }
            if (n == 2) {
                if (!bl) continue;
                ntrace.doTrace((String)"Unexpected ADD operation, ignored!");
                continue;
            }
            if (n == 3) {
                if (!bl) continue;
                ntrace.doTrace((String)"Unexpected REMOVE operation, ignored!");
                continue;
            }
            if (bl) {
                ntrace.doTrace((String)("*]/TDMImport/prepareUpdate/20/Unknown operation " + n));
            }
            throw new BeanUpdateRejectedException("Unknown operation(" + n + ") for TDMImport.");
        }
        TDMLocal tDMLocal = null;
        string = null;
        if (string3 != null && !string3.equals(this.myLocalAccessPoint)) {
            tDMLocal = this.myWTC.getLocalDomain(string3);
            if (tDMLocal == null) {
                if (bl) {
                    ntrace.doTrace((String)("*]/TDMImport/prepareUpdate/30/LAP " + string3 + " is not configured!"));
                }
                throw new BeanUpdateRejectedException("Unknown local access point " + string3);
            }
            string = string3;
        } else {
            tDMLocal = this.myLocalAccessPointObject;
            string = this.myLocalAccessPoint;
        }
        TDMRemoteTDomain[] tDMRemoteTDomainArray = (TDMRemoteTDomain[])this.myRemoteAccessPointObjectList;
        if (string4 != null) {
            stringArray = TDMImport.parseCommaSeparatedList(string4);
            if (stringArray.length == this.myRemoteAccessPointList.length) {
                int n;
                for (n = 0; n < stringArray.length && stringArray[n].equals(this.myRemoteAccessPointList[n]); ++n) {
                }
                if (n == stringArray.length) {
                    stringArray = this.myRemoteAccessPointList;
                } else {
                    tDMRemoteTDomainArray = new TDMRemoteTDomain[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        tDMRemoteTDomainArray[n] = this.myWTC.getVTDomainSession(string, stringArray[n]);
                        if (tDMRemoteTDomainArray[n] != null) continue;
                        if (bl) {
                            ntrace.doTrace((String)("*]/TDMImport/prepareUpdate/40/Imported svc " + string2 + " is configured for a " + "existing TDomain session(" + string + ", " + stringArray[n] + ")!"));
                        }
                        throw new BeanUpdateRejectedException("Remote TDomain Session(" + string + ", " + stringArray[n] + ") not defined.");
                    }
                }
            }
        } else {
            stringArray = this.myRemoteAccessPointList;
        }
        if (string2 != null && (object = this.myWTC.getImport(string2, string, stringArray[0])) != null && object != this) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMImport/prepareUpdate/50/Imported svc " + string2 + " already configured!"));
            }
            throw new BeanUpdateRejectedException("Imported resouce " + string2 + " already exists for TDomain session(" + string + ", " + stringArray[0] + ")!");
        }
        this.w.lock();
        if (string2 != null) {
            object = this.myResourceName;
            this.myResourceName = string2;
            this.myWTC.changeImportResourceName(this, (String)object);
        }
        if (string3 != null) {
            this.myLocalAccessPointObject = tDMLocal;
            this.myLocalAccessPoint = string;
        }
        if (stringArray != this.myRemoteAccessPointList) {
            this.myRemoteAccessPointList = stringArray;
            this.myRemoteAccessPointObjectList = tDMRemoteTDomainArray;
            this.myRemoteAccessPointListString = string4;
        }
        if (string5 != null) {
            this.myRemoteName = string5;
        }
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/prepareUpdate/60/DONE");
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMImport/activeUpdate");
            ntrace.doTrace((String)"]/TDMImport/activeUpdate/10/DONE");
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMImport/rollbackUpdate");
            ntrace.doTrace((String)"]/TDMImport/rollbackUpdate/10/DONE");
        }
    }

    public void registerListener() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMImport/registerListener");
        }
        if (this.mBean != null && !this.registered) {
            if (bl) {
                ntrace.doTrace((String)("TDMimport: add Bean Update Listener: " + (Object)((Object)this)));
            }
            ((AbstractDescriptorBean)this.mBean).addBeanUpdateListener((BeanUpdateListener)this);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/registerListener/10/DONE");
        }
    }

    public void unregisterListener() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMImport/unregisterListener");
        }
        if (this.mBean != null && this.registered) {
            if (bl) {
                ntrace.doTrace((String)("TDMImport: remove Bean Update Listener: " + (Object)((Object)this)));
            }
            ((AbstractDescriptorBean)this.mBean).removeBeanUpdateListener((BeanUpdateListener)this);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/unregisterListener/10/DONE");
        }
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public int getStatus() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMImport/getStatus/");
        }
        if (this.suspended) {
            if (bl) {
                ntrace.doTrace((String)"]/TDMImport/getStatus/10/SUSPENDED");
            }
            return 1;
        }
        if (this.hasActiveTsession() || !this.hasDynamicRemotePolicy()) {
            if (bl) {
                ntrace.doTrace((String)"]/TDMImport/getStatus/30/AVAILABLE");
            }
            return 3;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/getStatus/40/UNAVAILABLE");
        }
        return 2;
    }

    public boolean match(String string, String string2) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMImport/match/lap = " + string + ", raplist = " + string2));
        }
        if (this.myLocalAccessPoint.equals(string)) {
            if (string2 == null) {
                if (bl) {
                    ntrace.doTrace((String)"]/TDMImport/match/10/true");
                }
                return true;
            }
            if (this.myRemoteAccessPointListString != null && this.myRemoteAccessPointListString.equals(string2)) {
                if (bl) {
                    ntrace.doTrace((String)"]/TDMImport/match/20/true");
                }
                return true;
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMImport/match/30/false");
        }
        return false;
    }

    public DServiceInfo getServiceInfo() {
        return new DServiceInfo(this.myResourceName, this.myLocalAccessPoint, 1, this.getStatus());
    }
}

