/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import java.util.HashSet;
import weblogic.wtc.gwt.TDMRemote;
import weblogic.wtc.gwt.WTCMBeanObject;
import weblogic.wtc.jatmi.TPException;

public abstract class TDMLocal
extends WTCMBeanObject {
    private String myAccessPoint;
    private String myWlsClusterName;
    private String myAccessPointId;
    private String myType;
    private String mySecurity;
    private String myConnectionPolicy;
    private long myMaxRetries;
    private long myRetryInterval;
    private String myConnPrincipalName;
    private long myBlockTime;
    private HashSet myRemoteDomains;

    public TDMLocal(String string) throws Exception {
        if (string == null) {
            throw new Exception("AccessPoint cannot be null");
        }
        this.myAccessPoint = string;
        this.myRemoteDomains = new HashSet();
        this.myBlockTime = 60000L;
        this.myMaxRetries = -1L;
        this.myRetryInterval = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessPoint() {
        this.r.lock();
        try {
            String string = this.myAccessPoint;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public String getWlsClusterName() {
        return this.myWlsClusterName;
    }

    public boolean setWlsClusterName(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setWlsClusterName/name=" + string));
        }
        this.myWlsClusterName = string;
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocal/setWlsClusterName/15/true");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessPointId() {
        this.r.lock();
        try {
            String string = this.myAccessPointId;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setAccessPoint(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMLocal/setAccessPoint/id=null");
                ntrace.doTrace((String)"*]/TDMLocal/setAccessPoint/10/TPEINVAL");
            }
            throw new TPException(4, "null AccessPoint found in one of the local domain");
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setAccessPoint/id=" + string));
        }
        this.w.lock();
        this.myAccessPoint = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocal/setAccessPoint/20/SUCCESS");
        }
    }

    public void setAccessPointId(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMLocal/setAccessPointId/id=null");
                ntrace.doTrace((String)"*]/TDMLocal/setAccessPointId/10/TPEINVAL");
            }
            throw new TPException(4, "null AccessPointId found in one of the local domain");
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setAccessPointId/id=" + string));
        }
        this.w.lock();
        this.myAccessPointId = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocal/setAccessPointId/20/SUCCESS");
        }
    }

    public synchronized String getType() {
        return this.myType;
    }

    public synchronized void setType(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMLocal/setType/type=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMLocal/setType/type=null");
            }
        }
        if (string != null) {
            this.myType = string;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocal/setType/10/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecurity() {
        this.r.lock();
        try {
            String string = this.mySecurity;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setSecurity(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMLocal/setSecurity/security=null");
                ntrace.doTrace((String)"]/TDMLocal/setSecurity/10/TPEINVAL");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setSecurity/security=" + string));
        }
        if (string.equals("NONE") || string.equals("APP_PW") || string.equals("DM_PW")) {
            this.w.lock();
            this.mySecurity = string;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocal/setSecurity/20/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMLocal/setSecurity/25/TPEINVAL");
        }
        throw new TPException(4, "Invalid Domain Security type \"" + string + "\" found in local domain " + this.getAccessPointId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectionPolicy() {
        this.r.lock();
        try {
            String string = this.myConnectionPolicy;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setConnectionPolicy(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMLocal/setConnectionPolicy/policy=null");
                ntrace.doTrace((String)"]/TDMLocal/setConnectionPolicy/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setConnectionPolicy/policy=" + string));
        }
        if (string.equals("ON_DEMAND") || string.equals("ON_STARTUP") || string.equals("INCOMING_ONLY")) {
            this.w.lock();
            this.myConnectionPolicy = string;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocal/setConnectionPolicy/20/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMLocal/setConnectionPolicy/30/TPEINVAL");
        }
        throw new TPException(4, "Invalid ConnectionPolicy \"" + string + "\" found in local domain " + this.getAccessPointId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnPrincipalName() {
        this.r.lock();
        try {
            if (this.myConnPrincipalName == null) {
                String string = this.myAccessPointId;
                return string;
            }
            String string = this.myConnPrincipalName;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setConnPrincipalName(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string != null) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMLocal/setConnPrincipalName/name=" + string));
            }
            this.myConnPrincipalName = string;
        } else if (bl) {
            ntrace.doTrace((String)"[/TDMLocal/setConnPrincipalName/name=null");
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocal/setConnPrincipalName/10/SUCCESS");
        }
    }

    public long getRetryInterval() {
        long l = Long.MAX_VALUE;
        this.r.lock();
        if (this.myConnectionPolicy.equals("ON_STARTUP")) {
            l = this.myRetryInterval;
            if (this.myMaxRetries != 0L && l == -1L) {
                l = 60L;
            }
        }
        this.r.unlock();
        return l;
    }

    public void setRetryInterval(long l) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setRetryInterval/name=" + l));
        }
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            this.w.lock();
            this.myRetryInterval = l;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocal/setRetryInterval/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMLocal/setRetryInterval/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid RetryInterval value " + l + " found in one of the local domain" + this.getAccessPointId());
    }

    public long getMaxRetries() {
        long l = 0L;
        this.r.lock();
        if (this.myConnectionPolicy.equals("ON_STARTUP") && (l = this.myMaxRetries) == -1L) {
            l = Long.MAX_VALUE;
        }
        this.r.unlock();
        return l;
    }

    public void setMaxRetries(long l) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setMaxRetries/retries=" + l));
        }
        if (l >= 0L && l <= Long.MAX_VALUE) {
            this.w.lock();
            this.myMaxRetries = l;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocal/setMaxRetries/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMLocal/setMaxRetries/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid MAXRETRY value \"" + l + "\" found in local domain " + this.getAccessPointId());
    }

    public void setBlockTime(long l) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocal/setBlockTime/time=" + l));
        }
        if (l < 0L) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocal/setBlockTime/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid block time value \"" + l + "\" found in local domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.myBlockTime = l;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocal/setBlockTime/20/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlockTime() {
        this.r.lock();
        try {
            long l = this.myBlockTime;
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    public synchronized boolean add_remote_domain(TDMRemote tDMRemote) {
        return this.myRemoteDomains.add(tDMRemote);
    }

    public synchronized void remove_remote_domain(TDMRemote tDMRemote) {
        this.myRemoteDomains.remove((Object)tDMRemote);
    }

    public synchronized TDMRemote[] get_remote_domains() {
        return this.myRemoteDomains.toArray(new TDMRemote[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        TDMLocal tDMLocal = (TDMLocal)((Object)object);
        String string = tDMLocal.getAccessPoint();
        this.r.lock();
        try {
            if (this.myAccessPoint == null || tDMLocal == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = string.equals(this.myAccessPoint);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.r.lock();
        try {
            if (this.myAccessPoint == null) {
                int n = 0;
                return n;
            }
            int n = this.myAccessPoint.hashCode();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }
}

