/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import java.util.ArrayList;
import java.util.StringTokenizer;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.logging.Loggable;
import weblogic.management.configuration.WTCLocalTuxDomMBean;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.config.WTCLocalAccessPoint;
import weblogic.wtc.gwt.OatmialListener;
import weblogic.wtc.gwt.TDMLocal;
import weblogic.wtc.gwt.TDMRemoteTDomain;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.TPException;

public class TDMLocalTDomain
extends TDMLocal
implements BeanUpdateListener {
    static final long serialVersionUID = -8456049645166331478L;
    private String[] myNWAddr;
    private String[] ipaddress;
    private int[] port;
    private int myCmpLimit;
    private int MinEncryptionBits;
    private int MaxEncryptionBits;
    private boolean myInteroperate;
    private WTCLocalTuxDomMBean mBean = null;
    private OatmialListener oatmialListener = null;
    private boolean registered = false;
    private int keepAlive = -1;
    private int keepAliveWait;
    private String origNWAddr;
    private boolean isSSL = false;
    private boolean[] useSDP;

    public TDMLocalTDomain(String string) throws Exception {
        super(string);
        super.setType("TDOMAIN");
        this.setSecurity("NONE");
        this.setConnectionPolicy("ON_DEMAND");
        this.setCmpLimit(Integer.MAX_VALUE);
        this.setMinEncryptBits(0);
        this.setMaxEncryptBits(128);
        this.setInteroperate("No");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNWAddr() {
        this.r.lock();
        try {
            String string = this.myNWAddr[0];
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNWAddr(int n) {
        if (n < 0) {
            return null;
        }
        this.r.lock();
        try {
            if (n >= this.myNWAddr.length) {
                String string = null;
                return string;
            }
            String string = this.myNWAddr[n];
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setNWAddr(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMLocalTDomain/setNWAddr/addr=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMLocalTDomain/setNWAddr/addr=null");
            }
        }
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setNWAddr/10/TPEINVAL");
            }
            throw new TPException(4, "null NWAddr found in local domain " + this.getAccessPointId());
        }
        if (!string.startsWith("//") && !string.toLowerCase().startsWith("sdp://")) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setNWAddr/20/TPEINVAL");
            }
            throw new TPException(4, "Invalid NWAddr format \"" + string + "\" found in local domain " + this.getAccessPointId());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            if (!TDMRemoteTDomain.isNWAddrFormat(stringArray[i])) {
                if (bl) {
                    ntrace.doTrace((String)"*]/TDMLocalTDomain/setNWAddr/30/TPEINVAL");
                }
                throw new TPException(4, "Invalid NWAddr format \"" + string + "\" found in local domain " + this.getAccessPointId());
            }
            blArray[i] = false;
            if (stringArray[i].toLowerCase().startsWith("sdp://")) {
                stringArray[i] = stringArray[i].substring(4);
                blArray[i] = true;
            }
            int n2 = stringArray[i].indexOf(58);
            stringArray2[i] = stringArray[i].substring(2, n2);
            String string2 = stringArray[i].substring(n2 + 1);
            nArray[i] = Integer.parseInt(string2, 10);
        }
        this.w.lock();
        this.myNWAddr = stringArray;
        this.ipaddress = stringArray2;
        this.port = nArray;
        this.origNWAddr = string;
        this.useSDP = blArray;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setNWAddr/40/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] get_ipaddress() {
        this.r.lock();
        try {
            String[] stringArray = this.ipaddress;
            return stringArray;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get_port() {
        this.r.lock();
        try {
            int[] nArray = this.port;
            return nArray;
        }
        finally {
            this.r.unlock();
        }
    }

    public WTCLocalTuxDomMBean getMBean() {
        return this.mBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCmpLimit() {
        this.r.lock();
        try {
            int n = this.myCmpLimit;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setCmpLimit(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/setCmpLimit/limit=" + n));
        }
        if (n < 0 || n > Integer.MAX_VALUE) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setCmpLimit/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid compression limit value " + n + " found in local domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.myCmpLimit = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setCmpLimit/20/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinEncryptBits() {
        this.r.lock();
        try {
            if (this.MinEncryptionBits >= 256 && !this.isSSL) {
                int n = 128;
                return n;
            }
            int n = this.MinEncryptionBits;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setMinEncryptBits(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/setMinEncryptBits/bits=" + n));
        }
        if (n == 0 || n == 40 || n == 56 || n == 112 || n == 128 || n == 256) {
            this.w.lock();
            this.MinEncryptionBits = n;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocalTDomain/setMinEncryptBits/5/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMLocalTDomain/setMinEncryptBits/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid MIN Encryption bit value " + this.MinEncryptionBits + " found in local domain " + this.getAccessPointId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEncryptBits() {
        this.r.lock();
        try {
            if (this.MaxEncryptionBits >= 256 && !this.isSSL) {
                int n = 128;
                return n;
            }
            int n = this.MaxEncryptionBits;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setMaxEncryptBits(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/setMaxEncryptBits/bits=" + n));
        }
        if (n == 0 || n == 40 || n == 56 || n == 112 || n == 128 || n == 256) {
            this.w.lock();
            this.MaxEncryptionBits = n;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocalTDomain/setMaxEncryptBits/5/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMLocalTDomain/setMaxEncryptBits/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid MAX Encryption bit value " + this.MaxEncryptionBits + " found in local domain " + this.getAccessPointId());
    }

    public String getInteroperate() {
        if (this.myInteroperate) {
            return "YES";
        }
        return "NO";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInteroperate() {
        this.r.lock();
        try {
            boolean bl = this.myInteroperate;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setInteroperate(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMLocalTDomain/setInteroperate/interop=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMLocalTDomain/setInteroperate/interop=null");
            }
        }
        if (string != null) {
            if (string.compareToIgnoreCase("Yes") == 0) {
                this.w.lock();
                this.myInteroperate = true;
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"]/TDMLocalTDomain/setInteroperate/5/SUCCESS");
                }
                return;
            }
            if (string.compareToIgnoreCase("No") == 0) {
                this.w.lock();
                this.myInteroperate = false;
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"]/TDMLocalTDomain/setInteroperate/10/SUCCESS");
                }
                return;
            }
        }
        if (string != null) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setInteroperate/15/TPEINVAL");
            }
            throw new TPException(4, "Invalid Interoperate value specified \"" + string + "\" found in local domain " + this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setInteroperate/20/SUCCESS");
        }
    }

    public void setType(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMLocalTDomain/setType/type=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMLocalTDomain/setType/type=null");
            }
        }
        if (string != null && string.equals("TDOMAIN")) {
            super.setType(string);
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocalTDomain/setType/5/SUCCESS");
            }
            return;
        }
        if (string != null) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setType/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid Domain type \"" + string + "\" found in local domain " + this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setType/20/SUCCESS");
        }
    }

    public void setKeepAlive(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/setKeepAlive/ka =" + n));
        }
        if (n < 0 || n > Integer.MAX_VALUE) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setKeepAlive/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid KeepAlive value \"" + n + "\" found in local domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.keepAlive = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setKeepAlive/20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepAlive() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/getKeepAlive");
        }
        this.r.lock();
        try {
            int n = this.keepAlive;
            if (n == -1) {
                n = 0;
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocalTDomain/getKeepAlive/10");
            }
            this.r.unlock();
        }
    }

    public void setKeepAliveWait(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/setKeepAliveWait/kaw =" + n));
        }
        if (n < 0 || n > Integer.MAX_VALUE) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/setKeepAliveWait/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid KeepAliveWait value \"" + n + "\" found in local domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.keepAliveWait = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setKeepAliveWait/20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepAliveWait() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/getKeepAliveWait");
        }
        this.r.lock();
        try {
            int n = this.keepAlive == -1 || this.keepAliveWait == -1 ? 0 : this.keepAliveWait;
            int n2 = n;
            return n2;
        }
        finally {
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocalTDomain/getKeepAliveWait/10");
            }
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseSSL() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/isUseSSL");
        }
        this.r.lock();
        try {
            boolean bl2 = this.isSSL;
            return bl2;
        }
        finally {
            if (bl) {
                ntrace.doTrace((String)"]/TDMLocalTDomain/isUseSSL/10");
            }
            this.r.unlock();
        }
    }

    public void setMBean(WTCLocalTuxDomMBean wTCLocalTuxDomMBean) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (wTCLocalTuxDomMBean != null) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMLocalTDomain/setMBname/MBeanName=" + wTCLocalTuxDomMBean.getName()));
            }
            if (this.mBean != null) {
                if (this.mBean == wTCLocalTuxDomMBean) {
                    if (bl) {
                        ntrace.doTrace((String)"]/TDMLocalTDomain/setMBname/10/no change");
                    }
                    return;
                }
                this.unregisterListener();
            }
            this.mBean = wTCLocalTuxDomMBean;
            String string = wTCLocalTuxDomMBean.getUseSSL();
            if (string.equals("TwoWay") || string.equals("OneWay")) {
                this.isSSL = true;
            }
        } else {
            if (bl) {
                ntrace.doTrace((String)"[/TDMLocalTDomain/setMBname/MBeanName=null");
            }
            if (this.mBean != null) {
                this.unregisterListener();
                this.mBean = null;
            }
            this.isSSL = false;
        }
        if (!(this.isSSL || this.MinEncryptionBits < 256 && this.MaxEncryptionBits < 256)) {
            WTCLogger.logInfoLLEEncryptBitsDowngrade(this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setMBname/20/DONE");
        }
    }

    public void checkConfigIntegrity() throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/checkConfigIntegrity/ldom=" + this.getAccessPointId()));
        }
        if (this.MinEncryptionBits > this.MaxEncryptionBits) {
            Loggable loggable = WTCLogger.logMinEncryptBitsGreaterThanMaxEncryptBitsLoggable("Local", this.getAccessPointId());
            loggable.log();
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/checkConfigIntegrity/20/true");
        }
    }

    public void setOatmialListener(OatmialListener oatmialListener) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/setOatmialListener/10/BEGIN");
        }
        this.oatmialListener = oatmialListener;
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/setOatmialListener/20/DONE");
        }
    }

    public OatmialListener getOatmialListener() {
        return this.oatmialListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] get_useSDP() {
        this.r.lock();
        try {
            boolean[] blArray = this.useSDP;
            return blArray;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean hasActiveTsession() {
        TDMRemoteTDomain[] tDMRemoteTDomainArray = (TDMRemoteTDomain[])this.get_remote_domains();
        for (int i = 0; i < tDMRemoteTDomainArray.length; ++i) {
            if (tDMRemoteTDomainArray[i].getTsession(false) == null) continue;
            return true;
        }
        return false;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        int n;
        TDMLocalTDomain tDMLocalTDomain;
        int n2;
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        WTCLocalTuxDomMBean wTCLocalTuxDomMBean = (WTCLocalTuxDomMBean)beanUpdateEvent.getProposedBean();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        long l = -1L;
        long l2 = -1L;
        Object var13_11 = null;
        long l3 = -1L;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        String string6 = null;
        String string7 = null;
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/prepareUpdate");
        }
        if (wTCLocalTuxDomMBean == null) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/prepareUpdate/10/null MBean");
            }
            throw new BeanUpdateRejectedException("A null MBean for TDMLocalTuxDom!");
        }
        for (n2 = 0; n2 < propertyUpdateArray.length; ++n2) {
            String string8 = propertyUpdateArray[n2].getPropertyName();
            int n8 = propertyUpdateArray[n2].getUpdateType();
            if (bl) {
                ntrace.doTrace((String)("i = " + n2 + ", optype = " + n8 + ", key = " + string8));
            }
            if (n8 == 1) {
                String string9;
                if (string8.equals("AccessPointId")) {
                    string3 = wTCLocalTuxDomMBean.getAccessPointId();
                    if (!bl) continue;
                    ntrace.doTrace((String)("AccessPointId: " + string3));
                    continue;
                }
                if (string8.equals("AccessPoint")) {
                    string2 = wTCLocalTuxDomMBean.getAccessPoint();
                    if (!bl) continue;
                    ntrace.doTrace((String)("AccessPoint: " + string2));
                    continue;
                }
                if (string8.equals("NWAddr")) {
                    string = wTCLocalTuxDomMBean.getNWAddr();
                    if (!bl) continue;
                    ntrace.doTrace((String)("NWAddr: " + string));
                    continue;
                }
                if (string8.equals("Security")) {
                    string4 = wTCLocalTuxDomMBean.getSecurity();
                    if (!bl) continue;
                    ntrace.doTrace((String)("Security: " + string4));
                    continue;
                }
                if (string8.equals("ConnectionPolicy")) {
                    string5 = wTCLocalTuxDomMBean.getConnectionPolicy();
                    if (!bl) continue;
                    ntrace.doTrace((String)("ConnectionPolicy: " + string5));
                    continue;
                }
                if (string8.equals("Interoperate")) {
                    string6 = wTCLocalTuxDomMBean.getInteroperate();
                    if (!bl) continue;
                    ntrace.doTrace((String)("Interoperate: " + string6));
                    continue;
                }
                if (string8.equals("RetryInterval")) {
                    l2 = wTCLocalTuxDomMBean.getRetryInterval();
                    if (!bl) continue;
                    ntrace.doTrace((String)("RetryInterval: " + l2));
                    continue;
                }
                if (string8.equals("MaxRetries")) {
                    l = wTCLocalTuxDomMBean.getMaxRetries();
                    if (!bl) continue;
                    ntrace.doTrace((String)("MaxRetries: " + l));
                    continue;
                }
                if (string8.equals("BlockTime")) {
                    l3 = wTCLocalTuxDomMBean.getBlockTime();
                    if (!bl) continue;
                    ntrace.doTrace((String)("BlockTime: " + l3));
                    continue;
                }
                if (string8.equals("CmpLimit")) {
                    n3 = wTCLocalTuxDomMBean.getCmpLimit();
                    if (!bl) continue;
                    ntrace.doTrace((String)("CmpLimit: " + n3));
                    continue;
                }
                if (string8.equals("MinEncryptBits")) {
                    string9 = wTCLocalTuxDomMBean.getMinEncryptBits();
                    n4 = Integer.parseInt(string9, 10);
                    if (!bl) continue;
                    ntrace.doTrace((String)("MinEncryptBits: " + n4));
                    continue;
                }
                if (string8.equals("MaxEncryptBits")) {
                    string9 = wTCLocalTuxDomMBean.getMaxEncryptBits();
                    n5 = Integer.parseInt(string9, 10);
                    if (!bl) continue;
                    ntrace.doTrace((String)("MaxEncryptBits: " + n5));
                    continue;
                }
                if (string8.equals("KeepAlive")) {
                    n6 = wTCLocalTuxDomMBean.getKeepAlive();
                    if (!bl) continue;
                    ntrace.doTrace((String)("KeepAlive: " + n6));
                    continue;
                }
                if (string8.equals("KeepAliveWait")) {
                    n6 = wTCLocalTuxDomMBean.getKeepAliveWait();
                    if (!bl) continue;
                    ntrace.doTrace((String)("KeepAliveWait: " + n7));
                    continue;
                }
                if (!string8.equals("UseSSL")) continue;
                string7 = wTCLocalTuxDomMBean.getUseSSL();
                if (!bl) continue;
                ntrace.doTrace((String)("UseSSL: " + string7));
                continue;
            }
            if (n8 == 2) {
                if (!bl) continue;
                ntrace.doTrace((String)"Unexpected ADD operation, ignored!");
                continue;
            }
            if (n8 == 3) {
                if (!bl) continue;
                ntrace.doTrace((String)"Unexpected REMOVE operation, ignored!");
                continue;
            }
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/20/Unknown operation " + n8));
            }
            throw new BeanUpdateRejectedException("Unknown operation(" + n8 + ") for TDMResources.");
        }
        if (string2 != null && !this.getAccessPoint().equals(string2) && (tDMLocalTDomain = WTCService.getWTCService().getLocalDomain(string2)) != null) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/30/LAP  " + string2 + " already exists!"));
            }
            throw new BeanUpdateRejectedException("LocalTuxDom" + string2 + " already exists!");
        }
        if (string7 != null) {
            this.isSSL = !string7.equals("Off");
        }
        if (n4 != -1 && n4 != this.MinEncryptionBits) {
            if (n4 != 0 && n4 != 40 && n4 != 56 && n4 != 128 && n4 != 256) {
                if (bl) {
                    ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/40/Invalid MinEncryptionBits " + n4));
                }
                throw new BeanUpdateRejectedException("Invalid MinEncryptionBits value:" + n4);
            }
            n2 = n4;
        } else {
            n2 = this.MinEncryptionBits;
        }
        if (n5 != -1 && n5 != this.MaxEncryptionBits) {
            if (n5 != 0 && n5 != 40 && n5 != 56 && n5 != 128 && n5 != 256) {
                if (bl) {
                    ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/50/Invalid MaxEncryptionBits " + n5));
                }
                throw new BeanUpdateRejectedException("Invalid MaxEncryptionBits value:" + n5);
            }
            n = n5;
        } else {
            n = this.MaxEncryptionBits;
        }
        if ((n5 != -1 || n4 != -1) && n < n2) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/60/MaxEncryptionBits (" + n + ") less than MinEncryptionBits (" + n2 + " )"));
            }
            throw new BeanUpdateRejectedException("MaxEncryptionBits value less than MinEncryptionBits value");
        }
        if (!(string4 == null || string4.equals("NONE") || string4.equals("APP_PW") || string4.equals("DM_PW"))) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/70/Invalid security value  " + string4));
            }
            throw new BeanUpdateRejectedException("Invalid security value: " + string4);
        }
        if (!(string5 == null || string5.equals("ON_DEMAND") || string5.equals("ON_STARTUP") || string5.equals("INCOMING_ONLY"))) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/80/Invalid connection policy " + string5));
            }
            throw new BeanUpdateRejectedException("Invalid connection policy: " + string5);
        }
        if (string6 != null && string6.compareToIgnoreCase("Yes") == 0 && string6.compareToIgnoreCase("No") == 0) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/90/Invalid interoperate value " + string6));
            }
            throw new BeanUpdateRejectedException("Invalid interoperate value: " + string6);
        }
        try {
            if (string2 != null) {
                this.setAccessPoint(string2);
            }
            if (string3 != null) {
                this.setAccessPointId(string3);
            }
            if (string != null) {
                this.setNWAddr(string);
            }
            if (string4 != null) {
                this.setSecurity(string4);
            }
            if (string5 != null) {
                this.setConnectionPolicy(string5);
            }
            if (l != -1L) {
                this.setMaxRetries(l);
            }
            if (l2 != -1L) {
                this.setRetryInterval(l2);
            }
            if (l3 != -1L) {
                this.setBlockTime(l3);
            }
            if (n3 != -1) {
                this.setCmpLimit(n3);
            }
            if (n4 != -1) {
                this.setMinEncryptBits(n4);
            }
            if (n5 != -1) {
                this.setMaxEncryptBits(n5);
            }
            if (string6 != null) {
                this.setInteroperate(string6);
            }
            if (n6 != -1) {
                this.setKeepAlive(n6);
            }
            if (n7 != -1) {
                this.setKeepAliveWait(n7);
            }
        }
        catch (TPException tPException) {
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/100/Exception: " + tPException.getMessage()));
            }
            throw new BeanUpdateRejectedException(tPException.getMessage());
        }
        if (!(string7 == null && n4 == -1 && n5 == -1 || this.isSSL || this.MinEncryptionBits < 256 && this.MaxEncryptionBits < 256)) {
            WTCLogger.logInfoLLEEncryptBitsDowngrade(this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/prepareUpdate/110/DONE");
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/activeUpdate");
            ntrace.doTrace((String)"]/TDMLocalTDomain/activeUpdate/10/DONE");
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/rollbackUpdate");
            ntrace.doTrace((String)"]/TDMLocalTDomain/rollbackUpdate/10/DONE");
        }
    }

    public void registerListener() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/registerListener");
        }
        if (this.mBean != null && !this.registered) {
            if (bl) {
                ntrace.doTrace((String)("TDMLocalTDomain: add Bean Update Listener: " + (Object)((Object)this)));
            }
            ((AbstractDescriptorBean)this.mBean).addBeanUpdateListener((BeanUpdateListener)this);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/registerListener/10/DONE");
        }
    }

    public void unregisterListener() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMLocalTDomain/unregisterListener");
        }
        if (this.mBean != null && this.registered) {
            if (bl) {
                ntrace.doTrace((String)("TDMLocalTDomain: remove Bean Update Listener: " + (Object)((Object)this)));
            }
            ((AbstractDescriptorBean)this.mBean).removeBeanUpdateListener((BeanUpdateListener)this);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/unregisterListener/10/DONE");
        }
    }

    public static TDMLocalTDomain create(WTCLocalTuxDomMBean wTCLocalTuxDomMBean) throws TPException {
        TDMLocalTDomain tDMLocalTDomain;
        String string;
        String string2;
        String string3 = wTCLocalTuxDomMBean.getAccessPoint();
        boolean bl = ntrace.isMixedTraceEnabled((int)18);
        if (bl) {
            ntrace.doTrace((String)("[/TDMLocalTDomain/create/" + string3));
        }
        if (string3 == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("AccessPoint", wTCLocalTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/create/10/no AP");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("AccessPoint: " + string3));
        }
        if ((string2 = wTCLocalTuxDomMBean.getAccessPointId()) == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("AccessPointId", wTCLocalTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/create/20/no APId");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("AccessPointId:" + string2));
        }
        if ((string = wTCLocalTuxDomMBean.getNWAddr()) == null) {
            Loggable loggable = WTCLogger.logUndefinedMBeanAttrLoggable("NWAddr", wTCLocalTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/create/30/no NWAddr");
            }
            throw new TPException(4, loggable.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)("NWAddr:" + string));
        }
        if (bl) {
            ntrace.doTrace((String)("create ltd from " + string3));
        }
        try {
            tDMLocalTDomain = new TDMLocalTDomain(string3);
        }
        catch (Exception exception) {
            Loggable loggable = WTCLogger.logUEconstructTDMLocalTDLoggable(exception.getMessage());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMLocalTDomain/create/40/create failed");
            }
            throw new TPException(4, loggable.getMessage());
        }
        tDMLocalTDomain.setAccessPointId(string2);
        tDMLocalTDomain.setSecurity(wTCLocalTuxDomMBean.getSecurity());
        tDMLocalTDomain.setConnectionPolicy(wTCLocalTuxDomMBean.getConnectionPolicy());
        tDMLocalTDomain.setInteroperate(wTCLocalTuxDomMBean.getInteroperate());
        tDMLocalTDomain.setRetryInterval(wTCLocalTuxDomMBean.getRetryInterval());
        tDMLocalTDomain.setMaxRetries(wTCLocalTuxDomMBean.getMaxRetries());
        tDMLocalTDomain.setBlockTime(wTCLocalTuxDomMBean.getBlockTime() * 1000L);
        try {
            tDMLocalTDomain.setNWAddr(string);
        }
        catch (TPException tPException) {
            Loggable loggable = WTCLogger.logInvalidMBeanAttrLoggable("NWAddr", wTCLocalTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/create/50/bad NWAddr:" + tPException.getMessage()));
            }
            throw new TPException(4, loggable.getMessage());
        }
        try {
            tDMLocalTDomain.setCmpLimit(wTCLocalTuxDomMBean.getCmpLimit());
        }
        catch (TPException tPException) {
            Loggable loggable = WTCLogger.logInvalidMBeanAttrLoggable("CmpLimit", wTCLocalTuxDomMBean.getName());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/create/60/bad CMPLIMIT:" + tPException.getMessage()));
            }
            throw new TPException(4, loggable.getMessage());
        }
        String string4 = wTCLocalTuxDomMBean.getMinEncryptBits();
        if (string4 != null) {
            tDMLocalTDomain.setMinEncryptBits(Integer.parseInt(string4, 10));
        }
        if ((string4 = wTCLocalTuxDomMBean.getMaxEncryptBits()) != null) {
            tDMLocalTDomain.setMaxEncryptBits(Integer.parseInt(string4, 10));
        }
        tDMLocalTDomain.setKeepAlive(wTCLocalTuxDomMBean.getKeepAlive());
        tDMLocalTDomain.setKeepAliveWait(wTCLocalTuxDomMBean.getKeepAliveWait());
        tDMLocalTDomain.setMBean(wTCLocalTuxDomMBean);
        if (bl) {
            ntrace.doTrace((String)"]/TDMLocalTDomain/create/70/success");
        }
        return tDMLocalTDomain;
    }

    public ArrayList assembleConfigObject() throws TPException {
        WTCLocalAccessPoint wTCLocalAccessPoint = new WTCLocalAccessPoint();
        String[] stringArray = new String[]{this.origNWAddr};
        wTCLocalAccessPoint.setNetworkAddr(stringArray);
        wTCLocalAccessPoint.setEndPointGroup(this.myNWAddr);
        wTCLocalAccessPoint.fillFromSource(this);
        this.addConfigObj(wTCLocalAccessPoint);
        return this.getConfigObjList();
    }
}

