/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.config.TuxedoConnectorRAP;
import weblogic.wtc.gwt.TDMLocal;
import weblogic.wtc.gwt.WTCMBeanObject;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TuxXidRply;
import weblogic.wtc.jatmi.gwatmi;

public abstract class TDMRemote
extends WTCMBeanObject
implements TuxedoConnectorRAP {
    static final long serialVersionUID = 8838736910331494533L;
    private String myAccessPoint;
    private String myAccessPointId;
    private String myLocalAccessPoint;
    private String myType;
    private String myAclPolicy;
    private String myConnPrincipalName;
    private String myCredentialPolicy;
    private String myTpUsrFile;
    private String myConnectionPolicy;
    private long myMaxRetries;
    private long myRetryInterval;
    private int myConnPolicyConfigState;
    private TDMLocal myLocalAccessPointObject;
    private TuxXidRply myXidRplyObj;
    public static final int NOTDEFINED_STATE = 0;
    public static final int DEFINED_STATE = 1;
    public static final int DEFAULT_STATE = 2;
    public static final int FORCEDEFAULT_STATE = 3;

    public TDMRemote(String string, TuxXidRply tuxXidRply) throws Exception {
        if (string == null) {
            throw new Exception("AccessPoint may not be null");
        }
        this.myAccessPoint = string;
        this.myXidRplyObj = tuxXidRply;
        this.myConnPolicyConfigState = 0;
        this.myMaxRetries = -1L;
        this.myRetryInterval = -1L;
    }

    public TuxXidRply getUnknownXidRplyObj() {
        return this.myXidRplyObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessPoint() {
        this.r.lock();
        try {
            String string = this.myAccessPoint;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessPointId() {
        this.r.lock();
        try {
            String string = this.myAccessPointId;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setAccessPointId(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemote/setAccessPointId/id=null");
                ntrace.doTrace((String)"*]TDMRemote/setAccessPointId/10/TPEINVAL");
            }
            throw new TPException(4, "null AccessPointId found in one of the remotedomain.");
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setAccessPointId/id=" + string));
        }
        this.w.lock();
        this.myAccessPointId = string;
        this.myConnPrincipalName = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setAccessPointId/20/SUCCESS");
        }
    }

    public void setAccessPoint(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemote/setAccessPoint/name=null");
                ntrace.doTrace((String)"*]/TDMRemote/setAccessPoint/10/TPEINVAL");
            }
            throw new TPException(4, "null AccessPoint found in one of the remote domains");
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setAccessPoint/name=" + string));
        }
        this.w.lock();
        this.myAccessPoint = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setAccessPoint/20/SUCCESS");
        }
    }

    public synchronized String getType() {
        return this.myType;
    }

    public synchronized void setType(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemote/setType/type=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemote/setType/type=null");
            }
        }
        if (string != null) {
            this.myType = string;
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setType/10/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getConnectionPolicy() {
        this.r.lock();
        try {
            if ((this.myConnectionPolicy == null || this.myConnectionPolicy.equals("LOCAL")) && this.myLocalAccessPointObject != null) {
                String string = this.myLocalAccessPointObject.getConnectionPolicy();
                return string;
            }
            String string = this.myConnectionPolicy;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigConnectionPolicy() {
        this.r.lock();
        try {
            if (this.myConnPolicyConfigState == 3) {
                String string = "LOCAL";
                return string;
            }
            String string = this.myConnectionPolicy;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setConnectionPolicy(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemote/setConnectionPolicy/policy=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemote/setConnectionPolicy/policy=null");
            }
        }
        if (string == null || string.equals("LOCAL")) {
            if (string == null) {
                this.setConnPolicyConfigState(2);
            } else {
                this.setConnPolicyConfigState(3);
            }
            if (this.myLocalAccessPointObject != null) {
                string = this.myLocalAccessPointObject.getConnectionPolicy();
            }
        } else if (string.equals("ON_DEMAND") || string.equals("ON_STARTUP") || string.equals("INCOMING_ONLY")) {
            this.setConnPolicyConfigState(1);
        } else {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemote/setConnectionPolicy/40/TPEINVAL");
            }
            throw new TPException(4, "Invalid ConnectionPolicy \"" + string + "\" found in remote domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.myConnectionPolicy = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setConnectionPolicy/50/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnPolicyConfigState() {
        this.r.lock();
        try {
            int n = this.myConnPolicyConfigState;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean setConnPolicyConfigState(int n) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setConnPolicyConfigState/state=" + n));
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.w.lock();
                this.myConnPolicyConfigState = n;
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"]/TDMRemote/setConnPolicyConfigState/10/true");
                }
                return true;
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setConnPolicyConfigState/15/false");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAclPolicy() {
        this.r.lock();
        try {
            String string = this.myAclPolicy;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setAclPolicy(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemote/setAclPolicy/policy=null");
                ntrace.doTrace((String)"]/TDMRemote/setAclPolicy/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setAclPolicy/policy=" + string));
        }
        if (string.equals("LOCAL") || string.equals("GLOBAL")) {
            this.w.lock();
            this.myAclPolicy = string;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemote/setAclPolicy/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setAclPolicy/15/false");
        }
        throw new TPException(4, "Invalid AclPolicy \"" + string + "\" found in remote domain " + this.getAccessPointId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCredentialPolicy() {
        this.r.lock();
        try {
            String string = this.myCredentialPolicy;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setCredentialPolicy(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemote/setCredentialPolicy/policy=null");
                ntrace.doTrace((String)"]/TDMRemote/setCredentialPolicy/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setCredentialPolicy/policy=" + string));
        }
        if (string.equals("LOCAL") || string.equals("GLOBAL")) {
            this.w.lock();
            this.myCredentialPolicy = string;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemote/setCredentialPolicy/20/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMRemote/setCredentialPolicy/30/false");
        }
        throw new TPException(4, "Invalid CredentialPolicy \"" + string + "\" found in remote domain " + this.getAccessPointId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTpUsrFile() {
        this.r.lock();
        try {
            String string = this.myTpUsrFile;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setTpUsrFile(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMRemote/setTpUsrFile/file=" + string));
                ntrace.doTrace((String)"]/TDMRemote/setTpUsrFile/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemote/setTpUsrFile/file=null");
        }
        this.w.lock();
        this.myTpUsrFile = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setTpUsrFile/20/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalAccessPoint() {
        this.r.lock();
        try {
            String string = this.myLocalAccessPoint;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setLocalAccessPoint(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemote/setLocalAccessPoint/accesspoint=null");
                ntrace.doTrace((String)"*]/TDMRemote/setLocalAccessPoint/10/TPEINVAL");
            }
            throw new TPException(4, "null LocalAccessPoint found in remote domain " + this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setLocalAccessPoint/accesspoint=" + string));
        }
        this.w.lock();
        if (this.myLocalAccessPoint != null) {
            if (this.myLocalAccessPoint.equals(string)) {
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"]/TDMRemote/setLocalAccessPoint/10/no change");
                }
                return;
            }
            if (this.myLocalAccessPointObject != null) {
                this.myLocalAccessPointObject.remove_remote_domain(this);
                this.myLocalAccessPointObject = null;
            }
            TDMLocal tDMLocal = this.myLocalAccessPointObject;
            this.myLocalAccessPointObject = WTCService.getWTCService().getLocalDomain(string);
            if (this.myLocalAccessPointObject == null || !this.myLocalAccessPointObject.add_remote_domain(this)) {
                this.myLocalAccessPointObject = tDMLocal;
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"*]/TDMRemote/setLocalAccessPoint/20/TPEINVAL");
                }
                throw new TPException(4, "Failed to add remote domain " + this.myAccessPoint + " to local domain " + string);
            }
        } else {
            this.myLocalAccessPointObject = WTCService.getWTCService().getLocalDomain(string);
            if (this.myLocalAccessPointObject == null || !this.myLocalAccessPointObject.add_remote_domain(this)) {
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"*]/TDMRemote/setLocalAccessPoint/30/TPEINVAL");
                }
                throw new TPException(4, "Failed to add remote domain " + this.myAccessPoint + " to local domain " + string);
            }
        }
        this.myLocalAccessPoint = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setLocalAccessPoint/40/changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDMLocal getLocalAccessPointObject() {
        this.r.lock();
        try {
            TDMLocal tDMLocal = this.myLocalAccessPointObject;
            return tDMLocal;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setLocalAccessPointObject(TDMLocal tDMLocal) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (tDMLocal == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemote/setLocalAccessPointObject/lapObject=null");
                ntrace.doTrace((String)"*]/TDMRemote/setLocalAccessPointObject/10/TPEINVAL");
            }
            throw new TPException(4, "null LocalAccessPoint found in remote domain " + this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setLocalAccessPointObject/accesspoint=" + tDMLocal.getAccessPoint()));
        }
        this.w.lock();
        if (this.myLocalAccessPointObject != null) {
            if (this.myLocalAccessPointObject.equals((Object)tDMLocal)) {
                this.w.unlock();
                if (bl) {
                    ntrace.doTrace((String)"]/TDMRemote/setLocalAccessPointObject/10/no change");
                }
                return;
            }
            this.myLocalAccessPointObject.remove_remote_domain(this);
        }
        if (!tDMLocal.add_remote_domain(this)) {
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemote/setLocalAccessPoint/20/TPESYSTEM");
            }
            throw new TPException(12, "Failed to add remote domain " + this.myAccessPoint + " to local domain " + tDMLocal.getAccessPoint());
        }
        this.myLocalAccessPointObject = tDMLocal;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemote/setLocalAccessPoint/30/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnPrincipalName() {
        this.r.lock();
        try {
            String string = this.myConnPrincipalName;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setConnPrincipalName(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string != null) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMRemote/setConnPrincipalName/name=" + string));
            }
            this.w.lock();
            this.myConnPrincipalName = string;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemote/setConnPrincipalName/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemote/setConnPrincipalName/name=null");
            ntrace.doTrace((String)"]/TDMRemote/setConnPrincipalName/20/FAILURE");
        }
    }

    public long getRetryInterval() {
        long l = 0L;
        this.r.lock();
        if (this.myConnectionPolicy.equals("ON_STARTUP")) {
            l = this.myRetryInterval;
            if (this.myMaxRetries != 0L && l == -1L) {
                l = 60L;
            }
        } else if (this.myConnectionPolicy.equals("LOCAL") && this.myLocalAccessPointObject != null) {
            l = this.myLocalAccessPointObject.getRetryInterval();
        }
        this.r.unlock();
        return l;
    }

    public void setRetryInterval(long l) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setRetryInterval/interval=" + l));
        }
        if (l >= -1L && l <= Integer.MAX_VALUE) {
            this.w.lock();
            this.myRetryInterval = l;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemote/setRetryInterval/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMRemote/setRetryInterval/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid RetryInterval  value" + l + " found in remote domain " + this.getAccessPointId());
    }

    public long getMaxRetries() {
        long l = 0L;
        this.r.lock();
        if (this.myConnectionPolicy.equals("ON_STARTUP")) {
            l = this.myMaxRetries;
            if (l == -1L) {
                l = Long.MAX_VALUE;
            }
        } else if (this.myConnectionPolicy.equals("LOCAL") && this.myLocalAccessPointObject != null) {
            l = this.myLocalAccessPointObject.getMaxRetries();
        }
        this.r.unlock();
        return l;
    }

    public void setMaxRetries(long l) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemote/setMaxRetries/retries=" + l));
        }
        if (l >= -1L && l <= Long.MAX_VALUE) {
            this.w.lock();
            this.myMaxRetries = l;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemote/setMaxRetries/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMRemote/setMaxRetries/15/TPEINVAL");
        }
        throw new TPException(4, "Invalid MaxRetry value " + l + " found in remote domain " + this.getAccessPointId());
    }

    public boolean equals(Object object) {
        TDMLocal tDMLocal;
        TDMRemote tDMRemote = (TDMRemote)((Object)object);
        return this.myAccessPoint != null && this.myLocalAccessPoint != null && tDMRemote != null && (tDMLocal = tDMRemote.getLocalAccessPointObject()) != null && this.myAccessPoint.equals(tDMRemote.getAccessPoint()) && this.myLocalAccessPoint.equals(tDMLocal.getAccessPoint());
    }

    public synchronized int hashCode() {
        if (this.myAccessPoint == null) {
            return 0;
        }
        return this.myAccessPoint.hashCode();
    }

    abstract gwatmi getTsession(boolean var1);

    abstract void setTsession(gwatmi var1);

    abstract boolean getTimedOut();
}

