/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.internal.TCLicenseManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.logging.Loggable;
import weblogic.management.configuration.WTCRemoteTuxDomMBean;
import weblogic.security.utils.MBeanKeyStoreConfiguration;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.gwt.OatmialServices;
import weblogic.wtc.gwt.ScheduledReconnect;
import weblogic.wtc.gwt.TDMLocalTDomain;
import weblogic.wtc.gwt.TDMPasswd;
import weblogic.wtc.gwt.TDMRemote;
import weblogic.wtc.gwt.WLSInvoke;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.gwt.atntdom80;
import weblogic.wtc.gwt.gwdsession;
import weblogic.wtc.jatmi.InvokeSvc;
import weblogic.wtc.jatmi.OnTerm;
import weblogic.wtc.jatmi.PasswordUtils;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPINIT;
import weblogic.wtc.jatmi.TuxXidRply;
import weblogic.wtc.jatmi.atn;
import weblogic.wtc.jatmi.gwatmi;

public class TDMRemoteTDomain
extends TDMRemote
implements OnTerm,
BeanUpdateListener {
    static final long serialVersionUID = -6844147720547859282L;
    private String[] myNWAddr;
    private String[] ipaddress;
    private InetAddress[] myInetAddr;
    private int[] port;
    private boolean need_ia = true;
    private String federationURL = null;
    private String federationName = null;
    private int myCmpLimit;
    private int MinEncryptionBits;
    private int MaxEncryptionBits;
    private gwdsession myDsession;
    private Timer myTimeService;
    private String myAppKeyType;
    private boolean myAllowAnonymous;
    private int myDfltAppKey;
    private String myUidKw = null;
    private String myGidKw = null;
    private String myAppKeyClass = null;
    private String myParam = null;
    private WTCRemoteTuxDomMBean mBean = null;
    private boolean registered = false;
    private int keepAlive = -2;
    private int keepAliveWait = -1;
    private final TimedMutex lock = new TimedMutex();
    private boolean timedOut;
    private boolean[] useSDP;
    ScheduledReconnect connectingTask = null;

    public TDMRemoteTDomain(String string, TuxXidRply tuxXidRply, Timer timer) throws Exception {
        super(string, tuxXidRply);
        super.setType("TDOMAIN");
        this.setAclPolicy("LOCAL");
        this.setCredentialPolicy("LOCAL");
        this.setCmpLimit(Integer.MAX_VALUE);
        this.setMinEncryptBits(0);
        this.setMaxEncryptBits(128);
        this.myTimeService = timer;
        this.myDfltAppKey = -1;
        this.myAllowAnonymous = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNWAddr() {
        this.r.lock();
        try {
            String string = this.myNWAddr[0];
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNWAddr(int n) {
        if (n < 0) {
            return null;
        }
        this.r.lock();
        try {
            if (n >= this.myNWAddr.length) {
                String string = null;
                return string;
            }
            String string = this.myNWAddr[n];
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setNWAddr(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setNWAddr/addr=null");
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/setNWAddr/10/TPEINVAL");
            }
            throw new TPException(4, "null NWAddr found in remote domain " + this.getAccessPointId());
        }
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setNWAddr/addr=" + string));
        }
        this.parseNWAddr(string, false);
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setNWAddr/40/SUCCESS");
        }
    }

    public static boolean isNWAddrFormat(String string) {
        int n;
        if (string == null || !string.startsWith("//") && !string.toLowerCase().startsWith("sdp://")) {
            return false;
        }
        if (string.toLowerCase().startsWith("sdp://")) {
            string = string.substring(4);
        }
        if ((n = string.indexOf(58)) < 3 || n + 1 >= string.length()) {
            return false;
        }
        String string2 = string.substring(2, n);
        if (Character.isDigit(string2.charAt(0))) {
            int n2 = 0;
            int n3 = 0;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                try {
                    n3 = Integer.parseInt(string3, 10);
                    if (n3 < 0 || n3 > 255) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n2;
            }
            if (n2 != 4) {
                return false;
            }
        }
        try {
            if (Integer.parseInt(string.substring(n + 1), 10) < 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private void parseNWAddr(String string, boolean bl) throws TPException {
        boolean bl2 = ntrace.isTraceEnabled((int)16);
        if (string == null) {
            if (bl2) {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/parseNWAddr/addr=null");
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/parseNWAddr/10/TPEINVAL");
            }
            throw new TPException(4, "null NWAddr found in remote domain " + this.getAccessPointId());
        }
        if (bl2) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/parseNWAddr/addr=" + string + ", validate = " + bl));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            if (!TDMRemoteTDomain.isNWAddrFormat(stringArray[i])) {
                if (bl2) {
                    ntrace.doTrace((String)"*]/TDMRemoteTDomain/parseNWAddr/20/TPEINVAL");
                }
                throw new TPException(4, "Unsupported NWAddr format \"" + string + "\" found in remote domain " + this.getAccessPointId());
            }
            blArray[i] = false;
            if (stringArray[i].toLowerCase().startsWith("sdp://")) {
                stringArray[i] = stringArray[i].substring(4);
                blArray[i] = true;
            }
            if (bl) continue;
            int n2 = stringArray[i].indexOf(58);
            stringArray2[i] = stringArray[i].substring(2, n2);
            String string2 = stringArray[i].substring(n2 + 1);
            nArray[i] = Integer.parseInt(string2, 10);
        }
        if (!bl) {
            this.w.lock();
            this.myNWAddr = stringArray;
            this.ipaddress = stringArray2;
            this.port = nArray;
            this.myInetAddr = null;
            this.need_ia = true;
            this.useSDP = blArray;
            this.w.unlock();
        }
        if (bl2) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/parseNWAddr/40/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFederationURL() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getFederationURL/");
        }
        this.r.lock();
        try {
            if (bl) {
                ntrace.doTrace((String)("]/TDMRemoteTDomain/getFederationURL/10/" + this.federationURL));
            }
            String string = this.federationURL;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean setFederationURL(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setFederationURL/url=" + string));
        }
        this.w.lock();
        if (string == null || string.length() == 0) {
            this.federationURL = null;
            if (bl) {
                ntrace.doTrace((String)"set to null");
            }
        } else {
            this.federationURL = string;
        }
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setFederationURL/10");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFederationName() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getFederationName/");
        }
        this.r.lock();
        try {
            if (bl) {
                ntrace.doTrace((String)("]/TDMRemoteTDomain/getFederationName/10/" + this.federationName));
            }
            String string = this.federationName;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean setFederationName(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setFederationName/name=" + string));
        }
        this.w.lock();
        if (string == null || string.length() == 0) {
            this.federationName = null;
            if (bl) {
                ntrace.doTrace((String)"set to null");
            }
        } else {
            this.federationName = string;
        }
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/setFederationName/10");
        }
        return true;
    }

    public gwdsession getDomainSession() {
        return this.myDsession;
    }

    public synchronized boolean getTimedOut() {
        return this.timedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] get_useSDP() {
        this.r.lock();
        try {
            boolean[] blArray = this.useSDP;
            return blArray;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public gwatmi getTsession(boolean bl) {
        boolean bl2 = ntrace.isTraceEnabled((int)2);
        if (bl2) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/getTsession/" + this.getAccessPoint() + ", create = " + bl));
        }
        TDMLocalTDomain tDMLocalTDomain = (TDMLocalTDomain)this.getLocalAccessPointObject();
        tDMLocalTDomain.getBlockTime();
        Object object = this;
        synchronized (object) {
            this.timedOut = false;
            if (bl || this.myDsession != null && this.myDsession.get_is_connected()) {
                if (bl) {
                    if (!this.lock.acquire(tDMLocalTDomain.getBlockTime())) {
                        if (bl2) {
                            ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/03/Timeout");
                        }
                        this.timedOut = true;
                        return null;
                    }
                } else {
                    this.lock.acquire(0L);
                }
            } else if (!this.lock.attempt()) {
                if (bl2) {
                    ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/05/null");
                }
                return null;
            }
        }
        object = null;
        try {
            try {
                int n;
                if (this.myDsession != null && this.myDsession.getIsTerminated()) {
                    this.myDsession = null;
                }
                if (this.myDsession != null) {
                    if (bl2) {
                        ntrace.doTrace((String)("]/TDMRemoteTDomain/getTsession/10/" + this.myDsession));
                    }
                    object = this.myDsession;
                    throw new DoneException();
                }
                if (!bl) {
                    if (bl2) {
                        ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/20/null");
                    }
                    object = null;
                    throw new DoneException();
                }
                if (this.getConnectionPolicy().equals("INCOMING_ONLY")) {
                    if (bl2) {
                        ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/30/null");
                    }
                    object = null;
                    throw new DoneException();
                }
                if (this.myNWAddr == null || (n = this.myNWAddr.length) == 0) {
                    if (bl2) {
                        ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/40/null");
                    }
                    object = null;
                    throw new DoneException();
                }
                if (this.myInetAddr == null) {
                    this.myInetAddr = new InetAddress[n];
                    this.need_ia = true;
                }
                if (this.need_ia) {
                    this.need_ia = false;
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (this.myInetAddr[i] != null) continue;
                        try {
                            this.myInetAddr[i] = InetAddress.getByName(this.ipaddress[i]);
                            continue;
                        }
                        catch (UnknownHostException unknownHostException) {
                            this.myInetAddr[i] = null;
                            this.need_ia = true;
                            if (bl2) {
                                ntrace.doTrace((String)("unknown host(" + this.ipaddress[i] + ") skip it"));
                            }
                            ++n2;
                        }
                    }
                    if (n2 == n) {
                        WTCLogger.logWarnNoValidHostAddress(this.getAccessPointId());
                        if (bl2) {
                            ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/45/null");
                        }
                        object = null;
                        throw new DoneException();
                    }
                }
                OatmialServices oatmialServices = WTCService.getOatmialServices();
                try {
                    String string;
                    String string2;
                    String string3;
                    Object object2;
                    Object object3;
                    tDMLocalTDomain = (TDMLocalTDomain)this.getLocalAccessPointObject();
                    atntdom80 atntdom802 = new atntdom80(tDMLocalTDomain.getConnPrincipalName());
                    WLSInvoke wLSInvoke = new WLSInvoke(tDMLocalTDomain, this);
                    this.myDsession = new gwdsession(oatmialServices.getTimeService(), this.myInetAddr, this.port, (atn)atntdom802, (InvokeSvc)wLSInvoke, WTCService.getUniqueGwdsessionId(), this.getUnknownXidRplyObj());
                    this.myDsession.set_BlockTime(tDMLocalTDomain.getBlockTime());
                    this.myDsession.setTerminationHandler(this);
                    this.myDsession.set_compression_threshold(tDMLocalTDomain.getCmpLimit());
                    String string4 = tDMLocalTDomain.getAccessPoint();
                    String string5 = this.getAccessPoint();
                    String string6 = tDMLocalTDomain.getSecurity();
                    this.myDsession.set_sess_sec(string6);
                    this.myDsession.setDesiredName(tDMLocalTDomain.getConnPrincipalName());
                    this.myDsession.set_dom_target_name(this.getConnPrincipalName());
                    this.myDsession.set_local_domain_name(string4);
                    this.myDsession.setRemoteDomainId(this.getAccessPointId());
                    this.myDsession.setInteroperate(tDMLocalTDomain.isInteroperate());
                    this.myDsession.setKeepAlive(this.getKeepAlive());
                    this.myDsession.setKeepAliveWait(this.getKeepAliveWait());
                    this.myDsession.setAclPolicy(this.getAclPolicy());
                    this.myDsession.setCredentialPolicy(this.getCredentialPolicy());
                    this.myDsession.setAppKey(this.myAppKeyType);
                    if (this.myAppKeyType == null || this.myAppKeyType.equals("TpUsrFile")) {
                        this.myDsession.setTpUserFile(this.getTpUsrFile());
                    } else if (this.myAppKeyType.equals("LDAP")) {
                        this.myDsession.setUidKw(this.myUidKw);
                        this.myDsession.setGidKw(this.myGidKw);
                    } else {
                        this.myDsession.setCustomAppKeyClass(this.myAppKeyClass);
                        this.myDsession.setCustomAppKeyClassParam(this.myParam);
                    }
                    this.myDsession.setAllowAnonymous(this.myAllowAnonymous);
                    this.myDsession.setDfltAppKey(this.myDfltAppKey);
                    if (string6.equals("DM_PW")) {
                        object3 = WTCService.getWTCService().getTDMPasswd(string4, string5);
                        object2 = WTCService.getPasswordKey();
                        string3 = WTCService.getEncryptionType();
                        string2 = PasswordUtils.decryptPassword((String)object2, ((TDMPasswd)((Object)object3)).getLocalPasswordIV(), ((TDMPasswd)((Object)object3)).getLocalPassword(), string3);
                        string = PasswordUtils.decryptPassword((String)object2, ((TDMPasswd)((Object)object3)).getRemoteIV(), ((TDMPasswd)((Object)object3)).getRemotePassword(), string3);
                        if (string2 == null || string == null) {
                            this.myDsession = null;
                            WTCLogger.logErrorTDomainPassword(string4, string5);
                            if (bl2) {
                                ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/60/null");
                            }
                            object = null;
                            throw new DoneException();
                        }
                        this.myDsession.setLocalPassword(string2);
                        this.myDsession.setRemotePassword(string);
                    } else if (string6.equals("APP_PW")) {
                        object3 = WTCService.getAppPasswordPWD();
                        object2 = WTCService.getAppPasswordIV();
                        string3 = WTCService.getPasswordKey();
                        string = PasswordUtils.decryptPassword(string3, (String)object2, (String)object3, string2 = WTCService.getEncryptionType());
                        if (string == null) {
                            this.myDsession = null;
                            if (bl2) {
                                ntrace.doTrace((String)"]/TDMRemoteTDomain/getTsession/65/null");
                            }
                            object = null;
                            throw new DoneException();
                        }
                        this.myDsession.setApplicationPassword(string);
                    }
                    int n3 = 1;
                    if (tDMLocalTDomain.getMBean().getUseSSL().equals("TwoWay") || tDMLocalTDomain.getMBean().getUseSSL().equals("OneWay")) {
                        this.myDsession.setUseSSL(true);
                        if (tDMLocalTDomain.getMBean().getKeyStoresLocation().equals("WLS Stores")) {
                            object2 = MBeanKeyStoreConfiguration.getInstance();
                            string3 = ((MBeanKeyStoreConfiguration)object2).getKeyStores();
                            string2 = null;
                            string = null;
                            Object var21_25 = null;
                            this.myDsession.setIdentityKeyStoreType(((MBeanKeyStoreConfiguration)object2).getCustomIdentityKeyStoreType());
                            this.myDsession.setIdentityKeyStore(((MBeanKeyStoreConfiguration)object2).getCustomIdentityKeyStoreFileName());
                            this.myDsession.setIdentityKeyStorePassphrase(((MBeanKeyStoreConfiguration)object2).getCustomIdentityKeyStorePassPhrase());
                            this.myDsession.setIdentityKeyAlias(((MBeanKeyStoreConfiguration)object2).getCustomIdentityAlias());
                            this.myDsession.setIdentityKeyPassphrase(((MBeanKeyStoreConfiguration)object2).getCustomIdentityPrivateKeyPassPhrase());
                            if ("CustomIdentityAndCustomTrust".equals(string3)) {
                                this.myDsession.setTrustKeyStoreType(((MBeanKeyStoreConfiguration)object2).getCustomTrustKeyStoreType());
                                this.myDsession.setTrustKeyStore(((MBeanKeyStoreConfiguration)object2).getCustomTrustKeyStoreFileName());
                                this.myDsession.setTrustKeyStorePassphrase(((MBeanKeyStoreConfiguration)object2).getCustomTrustKeyStorePassPhrase());
                            } else {
                                this.myDsession.setTrustKeyStoreType(null);
                                this.myDsession.setTrustKeyStore(null);
                                this.myDsession.setTrustKeyStorePassphrase(null);
                            }
                        } else {
                            this.myDsession.setIdentityKeyStoreType("jks");
                            this.myDsession.setIdentityKeyStore(tDMLocalTDomain.getMBean().getIdentityKeyStoreFileName());
                            this.myDsession.setIdentityKeyStorePassphrase(tDMLocalTDomain.getMBean().getIdentityKeyStorePassPhrase());
                            this.myDsession.setIdentityKeyAlias(tDMLocalTDomain.getMBean().getPrivateKeyAlias());
                            this.myDsession.setIdentityKeyPassphrase(tDMLocalTDomain.getMBean().getPrivateKeyPassPhrase());
                            this.myDsession.setTrustKeyStoreType("jks");
                            this.myDsession.setTrustKeyStore(tDMLocalTDomain.getMBean().getTrustKeyStoreFileName());
                            this.myDsession.setTrustKeyStorePassphrase(tDMLocalTDomain.getMBean().getTrustKeyStorePassPhrase());
                        }
                        this.myDsession.setMinEncryptBits(tDMLocalTDomain.getMinEncryptBits());
                        this.myDsession.setMaxEncryptBits(tDMLocalTDomain.getMaxEncryptBits());
                    } else {
                        n3 = TCLicenseManager.decideEncryptionLevel((int)16, (int)this.MinEncryptionBits, (int)this.MaxEncryptionBits);
                    }
                    this.myDsession.setEncryptionFlags(n3);
                    this.myDsession.setUseSDP(this.useSDP);
                    TPINIT tPINIT = new TPINIT();
                    tPINIT.usrname = tDMLocalTDomain.getAccessPointId();
                    this.myDsession.tpinit(tPINIT);
                }
                catch (TPException tPException) {
                    if (this.myDsession != null) {
                        this.myDsession._dom_drop();
                        this.myDsession = null;
                    }
                    if (bl2) {
                        ntrace.doTrace((String)("]/TDMRemoteTDomain/getTsession/70/null/" + (Object)((Object)tPException)));
                    }
                    if (tPException.gettperrno() == 13) {
                        this.timedOut = true;
                    }
                    object = null;
                    throw new DoneException();
                }
                catch (Exception exception) {
                    if (this.myDsession != null) {
                        this.myDsession._dom_drop();
                        this.myDsession = null;
                    }
                    if (bl2) {
                        ntrace.doTrace((String)("]/TDMRemoteTDomain/getTsession/80/null/" + exception));
                    }
                    object = null;
                    throw new DoneException();
                }
                if (bl2) {
                    ntrace.doTrace((String)("]/TDMRemoteTDomain/getTsession/90/" + this.myDsession));
                }
                object = this.myDsession;
                throw new DoneException();
            }
            catch (DoneException doneException) {
                if (bl2) {
                    ntrace.doTrace((String)("/TDMRemoteTDomain/getTsession/100/" + (Object)object));
                }
                this.lock.release();
            }
        }
        catch (Throwable throwable) {
            this.lock.release();
            throw throwable;
        }
        return object;
    }

    public void setTsession(gwatmi gwatmi2) {
        this.myDsession = (gwdsession)gwatmi2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCmpLimit() {
        this.r.lock();
        try {
            int n = this.myCmpLimit;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setCmpLimit(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setCmpLimit/limit=" + n));
        }
        if (n < 0 || n > Integer.MAX_VALUE) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/setCmpLimit/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid compression limit value \"" + n + "\" found in remote domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.myCmpLimit = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setCmpLimit/20/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getMinEncryptBits() {
        this.r.lock();
        try {
            int n = this.MinEncryptionBits;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setMinEncryptBits(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setMinEncryptBits/numbits=" + n));
        }
        if (n == 0 || n == 56 || n == 40 || n == 128) {
            this.w.lock();
            this.MinEncryptionBits = n;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/setMinEncryptBits/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMRemoteTDomain/setMinEncryptBits/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid MinEncryptionBits " + this.MinEncryptionBits + " found in remote domain " + this.getAccessPointId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEncryptBits() {
        this.r.lock();
        try {
            int n = this.MaxEncryptionBits;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setMaxEncryptBits(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setMaxEncryptBits/numbits=" + n));
        }
        if (n == 0 || n == 56 || n == 40 || n == 128) {
            this.w.lock();
            this.MaxEncryptionBits = n;
            this.w.unlock();
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/setMaxEncryptBits/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMRemoteTDomain/setMaxEncryptBits/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid MaxEncryptionBits \"" + this.MaxEncryptionBits + "\" found in remote domain " + this.getAccessPointId());
    }

    public void setType(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setType/type=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setType/type=null");
            }
        }
        if (string != null && string.equals("TDOMAIN")) {
            super.setType(string);
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/setType/10/SUCCESS");
            }
            return;
        }
        if (bl) {
            ntrace.doTrace((String)"*]/TDMRemoteTDomain/setType/20/TPEINVAL");
        }
        throw new TPException(4, "Invalid Domain Type \"" + string + "\" found in remote domain " + this.getAccessPointId());
    }

    public void setAppKey(String string) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setAppKey/type=" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setAppKey/type=null");
            }
        }
        if (!(string == null || string.equals("TpUsrFile") || string.equals("LDAP") || string.equals("Custom"))) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/setAppKey/20/TPEINVAL");
            }
            throw new TPException(4, "Invalid AppKey generator plug-in Type \"" + string + "\" found in remote domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.myAppKeyType = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setAppKey/10/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppKey() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getAppKey/");
        }
        this.r.lock();
        try {
            if (bl) {
                if (this.myAppKeyType != null) {
                    ntrace.doTrace((String)("]/TDMRemoteTDomain/getAppKey/10/" + this.myAppKeyType));
                } else {
                    ntrace.doTrace((String)"]/TDMRemoteTDomain/getAppKey/10/null");
                }
            }
            String string = this.myAppKeyType;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setAllowAnonymous(boolean bl) {
        boolean bl2 = ntrace.isTraceEnabled((int)16);
        if (bl2) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setAllowAnonymous/" + bl));
        }
        this.w.lock();
        this.myAllowAnonymous = bl;
        this.w.unlock();
        if (bl2) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setAllowAnonymous/10/SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAllowAnonymous() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getAllowAnonymous/");
        }
        this.r.lock();
        try {
            boolean bl2 = this.myAllowAnonymous;
            return bl2;
        }
        finally {
            this.r.unlock();
            if (bl) {
                ntrace.doTrace((String)("]/TDMRemoteTDomain/getAllowAnonymous/10/" + this.myAllowAnonymous));
            }
        }
    }

    public boolean isAllowAnonymous() {
        return this.getAllowAnonymous();
    }

    public void setDefaultAppKey(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setDefaultAppKey/" + n));
        }
        this.w.lock();
        this.myDfltAppKey = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setDefaultAppKey/10/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultAppKey() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getDefaultAppKey/");
        }
        if (bl) {
            ntrace.doTrace((String)("]/TDMRemoteTDomain/getDefaultAppKey/10/" + this.myDfltAppKey));
        }
        this.r.lock();
        try {
            int n = this.myDfltAppKey;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setTuxedoUidKw(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setTuxedoUidKw/" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setTuxedoUidKw/null");
            }
        }
        this.w.lock();
        this.myUidKw = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setTuxedoUidKw/10/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTuxedoUidKw() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getTuxedoUidKw/");
        }
        if (bl) {
            ntrace.doTrace((String)("]/TDMRemoteTDomain/setTuxedoUidKw/10/" + this.myUidKw));
        }
        this.r.lock();
        try {
            String string = this.myUidKw;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setTuxedoGidKw(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setTuxedoGidKw/" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setTuxedoGidKw/null");
            }
        }
        this.w.lock();
        this.myGidKw = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setTuxedoGidKw/10/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTuxedoGidKw() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getTuxedoGidKw/");
            ntrace.doTrace((String)("]/TDMRemoteTDomain/getTuxedoGidKw/10/" + this.myGidKw));
        }
        this.r.lock();
        try {
            String string = this.myGidKw;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setCustomAppKeyClass(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setCustomAppKey/" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setCustomAppKey/null");
            }
        }
        this.w.lock();
        this.myAppKeyClass = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setCustomAppKey/10/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCustomAppKeyClass() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getCustomAppKeyClass/");
        }
        if (bl) {
            ntrace.doTrace((String)("]/TDMRemoteTDomain/getCustomAppKeyClass/10/" + this.myAppKeyClass));
        }
        this.r.lock();
        try {
            String string = this.myAppKeyClass;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public void setCustomAppKeyClassParam(String string) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            if (string != null) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setCustomAppKeyClassParam/" + string));
            } else {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setCustomAppKeyClassParam/null");
            }
        }
        this.w.lock();
        this.myParam = string;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setCustomAppKeyClassParam/10/");
        }
    }

    void setKeepAlive(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setKeepAlive/ka =" + n));
        }
        if (n < -1 || n > Integer.MAX_VALUE) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/setKeepAlive/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid KeepAlive value \"" + n + "\" found in local domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.keepAlive = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setKeepAlive/20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepAlive() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getKeepAlive");
        }
        this.r.lock();
        try {
            int n = this.keepAlive;
            if (n == -2) {
                n = 0;
            } else if (n == -1) {
                TDMLocalTDomain tDMLocalTDomain = (TDMLocalTDomain)this.getLocalAccessPointObject();
                int n2 = tDMLocalTDomain.getKeepAlive();
                return n2;
            }
            int n3 = n;
            return n3;
        }
        finally {
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/getKeepAlive/10");
            }
            this.r.unlock();
        }
    }

    void setKeepAliveWait(int n) throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/setKeepAliveWait/kaw =" + n));
        }
        if (n < 0 || n > Integer.MAX_VALUE) {
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/setKeepAliveWait/10/TPEINVAL");
            }
            throw new TPException(4, "Invalid KeepAliveWait value \"" + n + "\" found in local domain " + this.getAccessPointId());
        }
        this.w.lock();
        this.keepAliveWait = n;
        this.w.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/setKeepAliveWait/20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeepAliveWait() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getKeepAliveWait");
        }
        this.r.lock();
        try {
            int n;
            if (this.keepAlive == -1) {
                TDMLocalTDomain tDMLocalTDomain = (TDMLocalTDomain)this.getLocalAccessPointObject();
                n = tDMLocalTDomain.getKeepAliveWait();
            } else {
                n = this.keepAlive == -2 || this.keepAliveWait == -1 ? 0 : this.keepAliveWait;
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/getKeepAliveWait/10");
            }
            this.r.unlock();
        }
    }

    public void setMBean(WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (wTCRemoteTuxDomMBean != null) {
            if (bl) {
                ntrace.doTrace((String)("[/TDMRemoteTDomain/setMBname/MBeanName=" + wTCRemoteTuxDomMBean.getName()));
            }
            if (this.mBean != null) {
                if (this.mBean == wTCRemoteTuxDomMBean) {
                    if (bl) {
                        ntrace.doTrace((String)"]/TDMRemoteTDomain/setMBname/no change");
                    }
                    return;
                }
                this.unregisterListener();
            }
            this.mBean = wTCRemoteTuxDomMBean;
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/setMBname/20/change & activated");
            }
        } else {
            if (bl) {
                ntrace.doTrace((String)"[/TDMRemoteTDomain/setMBname/MBeanName=null");
            }
            if (this.mBean != null) {
                this.unregisterListener();
                this.mBean = null;
            }
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/setMBname/30/remove & deactivated");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCustomAppKeyClassParam() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/getCustomAppKeyClassParam/");
            ntrace.doTrace((String)("]/TDMRemoteTDomain/getCustomAppKeyClassParam/" + this.myParam));
        }
        this.r.lock();
        try {
            String string = this.myParam;
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public WTCRemoteTuxDomMBean getMBean() {
        return this.mBean;
    }

    public void onTerm(int n) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/onTerm/" + n));
        }
        this.myDsession = null;
        switch (n) {
            case 1: 
            case 3: {
                break;
            }
            default: {
                if (bl) {
                    ntrace.doTrace((String)"]/TDMRemoteTDomain/onTerm/10");
                }
                return;
            }
        }
        String string = this.getConnectionPolicy();
        if (string == null || !string.equals("ON_STARTUP")) {
            if (bl) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/onTerm/20");
            }
            return;
        }
        if (n == 1) {
            this.outboundConnect(false);
        } else {
            this.outboundConnect(true);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/onTerm/30");
        }
    }

    private void outboundConnect(boolean bl) {
        boolean bl2 = ntrace.isTraceEnabled((int)2);
        if (bl2) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/outboundConnect/" + this.getAccessPointId()));
        }
        if (this.getTsession(false) != null) {
            if (bl2) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/10");
            }
            return;
        }
        if (this.connectingTask != null) {
            if (bl2) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/20");
            }
            return;
        }
        long l = this.getMaxRetries();
        if (l < 0L) {
            String string = null;
            string = this.getConnectionPolicy();
            if (string != null && !string.equals("ON_STARTUP")) {
                this.connectingTask = new ScheduledReconnect(this, 0L);
                try {
                    this.myTimeService.schedule((TimerTask)this.connectingTask, 0L);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    WTCLogger.logTTEstdSchedule(illegalArgumentException.getMessage());
                    if (bl2) {
                        ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/30");
                    }
                    return;
                }
            }
            if (bl2) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/40");
            }
            return;
        }
        long l2 = this.getRetryInterval() * 1000L;
        String string = this.getConnectionPolicy();
        if (string != null && string.equals("ON_DEMAND")) {
            this.getTsession(true);
            if (bl2) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/45");
            }
            return;
        }
        this.connectingTask = new ScheduledReconnect(this, l);
        try {
            if (bl) {
                this.myTimeService.scheduleAtFixedRate((TimerTask)this.connectingTask, l2, l2);
            } else {
                this.myTimeService.scheduleAtFixedRate((TimerTask)this.connectingTask, 0L, l2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            WTCLogger.logTTEstdSchedule(illegalArgumentException.getMessage());
            if (bl2) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/50");
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            WTCLogger.logTTEstdSchedule(illegalStateException.getMessage());
            if (bl2) {
                ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/60");
            }
            return;
        }
        if (bl2) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/outboundConnect/70");
        }
    }

    public void startConnection() throws TPException {
        String string;
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/startConnection/");
        }
        if ((string = this.getConnectionPolicy()) == null || string.equals("INCOMING_ONLY")) {
            Loggable loggable = WTCLogger.logErrorIncomingOnlyLoggable(this.getAccessPointId());
            loggable.log();
            if (bl) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/startConnection/10/INCOMING_ONLY");
            }
            throw new TPException(12, loggable.getMessage());
        }
        this.outboundConnect(false);
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/startConnection/DONE");
        }
    }

    public void checkConfigIntegrity() throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/TDMRemoteTDomain/checkConfigIntegrity/rdom=" + this.getAccessPointId()));
        }
        this.r.lock();
        if (this.MinEncryptionBits > this.MaxEncryptionBits) {
            this.r.unlock();
            Loggable loggable = WTCLogger.logMinEncryptBitsGreaterThanMaxEncryptBitsLoggable("Remote", this.getAccessPointId());
            loggable.log();
            throw new TPException(4, loggable.getMessage());
        }
        this.r.unlock();
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/checkConfigIntegrity/20/true");
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        TDMRemoteTDomain tDMRemoteTDomain;
        String string;
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean = (WTCRemoteTuxDomMBean)beanUpdateEvent.getProposedBean();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = this.myCmpLimit;
        int n2 = this.MinEncryptionBits;
        int n3 = this.MaxEncryptionBits;
        String string5 = null;
        boolean bl = this.myAllowAnonymous;
        int n4 = this.myDfltAppKey;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        Object var22_22 = null;
        String string15 = null;
        String string16 = null;
        long l = -1L;
        long l2 = -1L;
        int n5 = -1;
        int n6 = -1;
        boolean bl2 = ntrace.isTraceEnabled((int)16);
        if (bl2) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/prepareUpdate");
        }
        if (wTCRemoteTuxDomMBean == null) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TDMRemoteTDomain/prepareUpdate/10/null MBean");
            }
            throw new BeanUpdateRejectedException("A null MBean for TDMRemoteTuxDom!");
        }
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            string = propertyUpdateArray[i].getPropertyName();
            int n7 = propertyUpdateArray[i].getUpdateType();
            if (bl2) {
                ntrace.doTrace((String)("i = " + i + ", optype = " + n7 + ", key = " + string));
            }
            if (n7 == 1) {
                String string17;
                if (string.equals("AccessPointId")) {
                    string12 = wTCRemoteTuxDomMBean.getAccessPointId();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("AccessPointId: " + string12));
                    continue;
                }
                if (string.equals("AccessPoint")) {
                    string11 = wTCRemoteTuxDomMBean.getAccessPoint();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("AccessPoint: " + string11));
                    continue;
                }
                if (string.equals("NWAddr")) {
                    string2 = wTCRemoteTuxDomMBean.getNWAddr();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("NWAddr: " + string2));
                    continue;
                }
                if (string.equals("LocalAccessPoint")) {
                    string10 = wTCRemoteTuxDomMBean.getLocalAccessPoint();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("LocalAccessPoint: " + string10));
                    continue;
                }
                if (string.equals("ConnectionPolicy")) {
                    string16 = wTCRemoteTuxDomMBean.getConnectionPolicy();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("ConnectionPolicy: " + string16));
                    continue;
                }
                if (string.equals("AclPolicy")) {
                    string13 = wTCRemoteTuxDomMBean.getAclPolicy();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("AclPolicy: " + string13));
                    continue;
                }
                if (string.equals("CredentialPolicy")) {
                    string14 = wTCRemoteTuxDomMBean.getCredentialPolicy();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("CredentialPolicy: " + string14));
                    continue;
                }
                if (string.equals("TpUsrFile")) {
                    string15 = wTCRemoteTuxDomMBean.getTpUsrFile();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("TpUsrFile: " + string15));
                    continue;
                }
                if (string.equals("AppKey")) {
                    string5 = wTCRemoteTuxDomMBean.getAppKey();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("AppKey: " + string5));
                    continue;
                }
                if (string.equals("DefaultAppKey")) {
                    n4 = wTCRemoteTuxDomMBean.getDefaultAppKey();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("DefaultAppKey: " + n4));
                    continue;
                }
                if (string.equals("AllowAnonymous")) {
                    bl = wTCRemoteTuxDomMBean.getAllowAnonymous();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("AllowAnonymous: " + bl));
                    continue;
                }
                if (string.equals("TuxedoUidKw")) {
                    string6 = wTCRemoteTuxDomMBean.getTuxedoUidKw();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("TuxedoUidKw: " + string6));
                    continue;
                }
                if (string.equals("TuxedoGidKw")) {
                    string7 = wTCRemoteTuxDomMBean.getTuxedoGidKw();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("TuxedoGidKw: " + string7));
                    continue;
                }
                if (string.equals("CustomAppKeyClass")) {
                    string8 = wTCRemoteTuxDomMBean.getCustomAppKeyClass();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("CustomAppKeyClass: " + string8));
                    continue;
                }
                if (string.equals("CustomAppKeyClassParam")) {
                    string9 = wTCRemoteTuxDomMBean.getCustomAppKeyClassParam();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("CustomAppKeyClassParam: " + string9));
                    continue;
                }
                if (string.equals("FederationURL")) {
                    string3 = wTCRemoteTuxDomMBean.getFederationURL();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("FederationURL: " + string3));
                    continue;
                }
                if (string.equals("FederationName")) {
                    string4 = wTCRemoteTuxDomMBean.getFederationName();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("FederationName: " + string4));
                    continue;
                }
                if (string.equals("RetryInterval")) {
                    l2 = wTCRemoteTuxDomMBean.getRetryInterval();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("ConnectionPolicy: " + string16));
                    continue;
                }
                if (string.equals("MaxRetries")) {
                    l = wTCRemoteTuxDomMBean.getMaxRetries();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("MaxRetries: " + l));
                    continue;
                }
                if (string.equals("CmpLimit")) {
                    n = wTCRemoteTuxDomMBean.getCmpLimit();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("CmpLimit: " + n));
                    continue;
                }
                if (string.equals("MinEncryptBits")) {
                    string17 = wTCRemoteTuxDomMBean.getMinEncryptBits();
                    n2 = Integer.parseInt(string17, 10);
                    if (!bl2) continue;
                    ntrace.doTrace((String)("MinEncryptBits: " + n2));
                    continue;
                }
                if (string.equals("MaxEncryptBits")) {
                    string17 = wTCRemoteTuxDomMBean.getMaxEncryptBits();
                    n3 = Integer.parseInt(string17, 10);
                    if (!bl2) continue;
                    ntrace.doTrace((String)("MaxEncryptBits: " + n3));
                    continue;
                }
                if (string.equals("KeepAlive")) {
                    n5 = wTCRemoteTuxDomMBean.getKeepAlive();
                    if (!bl2) continue;
                    ntrace.doTrace((String)("KeepAlive: " + n5));
                    continue;
                }
                if (!string.equals("KeepAliveWait")) continue;
                n6 = wTCRemoteTuxDomMBean.getKeepAliveWait();
                if (!bl2) continue;
                ntrace.doTrace((String)("KeepAliveWait: " + n6));
                continue;
            }
            if (n7 == 2) {
                if (!bl2) continue;
                ntrace.doTrace((String)"Unexpected ADD operation, ignored!");
                continue;
            }
            if (n7 == 3) {
                if (!bl2) continue;
                ntrace.doTrace((String)"Unexpected REMOVE operation, ignored!");
                continue;
            }
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMLocalTDomain/prepareUpdate/20/Unknown operation " + n7));
            }
            throw new BeanUpdateRejectedException("Unknown operation(" + n7 + ") for TDMResources.");
        }
        WTCService wTCService = WTCService.getWTCService();
        if (string11 != null && !string11.equals(this.getLocalAccessPoint()) && wTCService.getLocalDomain(string11) == null) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/30/LAP (" + string10 + ") not defined!"));
            }
            throw new BeanUpdateRejectedException("Local Access Point " + string10 + " is not configured.");
        }
        String string18 = string = string10 == null ? this.getLocalAccessPoint() : string10;
        if ((string10 != null || string11 != null) && (tDMRemoteTDomain = wTCService.getVTDomainSession(string, string11)) != null && tDMRemoteTDomain != this) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/40/duplicate TDomain session(" + string10 + ", " + string11 + ")."));
            }
            throw new BeanUpdateRejectedException("Duplicate TDomain Session(" + string10 + ", " + string11 + ").");
        }
        if (n2 != this.MinEncryptionBits && n2 != 0 && n2 != 40 && n2 != 56 && n2 != 128) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/50/invalid MinEncryptBits value(" + n2 + ")."));
            }
            throw new BeanUpdateRejectedException("Invalid MinEncryptBits Value: " + n2);
        }
        if (n3 != this.MaxEncryptionBits && n3 != 0 && n3 != 40 && n3 != 56 && n3 != 128) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/60/invalid MinEncryptBits value(" + n2 + ")."));
            }
            throw new BeanUpdateRejectedException("Invalid MaxEncryptBits Value: " + n3);
        }
        if (n3 < n2) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/70/MinEncryptBits value(" + n2 + ") greater than MaxEncryptBits value(" + n3 + ")."));
            }
            throw new BeanUpdateRejectedException("MinEncryptBits value greater than MaxEncryptBits value for RemoteTuxDom " + string11 == null ? this.getAccessPoint() : string11);
        }
        if (!(string16 == null || string16.equals("LOCAL") || string16.equals("ON_DEMAND") || string16.equals("ON_STARTUP") || string16.equals("INCOMING_ONLY"))) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/80/Invalid Connection Policy value: " + string16));
            }
            throw new BeanUpdateRejectedException("Invalid Connection Policy Value: " + string16);
        }
        if (string13 != null && !string13.equals("LOCAL") && !string13.equals("GLOBAL")) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/90/Invalid ACL Policy value: " + string13));
            }
            throw new BeanUpdateRejectedException("Invalid ACL Policy Value: " + string13);
        }
        if (string14 != null && !string14.equals("LOCAL") && !string14.equals("GLOBAL")) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/100/Invalid Credential Policy value: " + string14));
            }
            throw new BeanUpdateRejectedException("Invalid Credential Policy Value: " + string14);
        }
        if (string2 != null) {
            try {
                this.parseNWAddr(string2, true);
            }
            catch (TPException tPException) {
                if (bl2) {
                    ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/110/invalid NWAddr format(" + string2 + ")."));
                }
                throw new BeanUpdateRejectedException(tPException.getMessage());
            }
        }
        try {
            if (string11 != null) {
                this.setAccessPoint(string11);
            }
            if (string10 != null) {
                this.setLocalAccessPoint(string10);
            }
            if (string12 != null) {
                this.setAccessPointId(string12);
            }
            if (string13 != null) {
                this.setAclPolicy(string13);
            }
            if (string14 != null) {
                this.setCredentialPolicy(string14);
            }
            if (string15 != null) {
                this.setTpUsrFile(string15);
            }
            if (string3 != null) {
                this.setFederationURL(string3);
            }
            if (string4 != null) {
                this.setFederationName(string4);
            }
            if (n != this.myCmpLimit) {
                this.setCmpLimit(n);
            }
            if (n2 != this.MinEncryptionBits) {
                this.setMinEncryptBits(n2);
            }
            if (n3 != this.MaxEncryptionBits) {
                this.setMaxEncryptBits(n3);
            }
            if (string16 != null) {
                this.setConnectionPolicy(string16);
            }
            if (l2 != -1L) {
                this.setRetryInterval(l2);
            }
            if (l != -1L) {
                this.setMaxRetries(l);
            }
            if (string5 != null) {
                this.setAppKey(string5);
            }
            if (bl != this.myAllowAnonymous) {
                this.setAllowAnonymous(bl);
            }
            if (n4 != this.myDfltAppKey) {
                this.setDefaultAppKey(n4);
            }
            if (string6 != null) {
                this.setTuxedoUidKw(string6);
            }
            if (string7 != null) {
                this.setTuxedoGidKw(string7);
            }
            if (string8 != null) {
                this.setCustomAppKeyClass(string8);
            }
            if (string9 != null) {
                this.setCustomAppKeyClassParam(string9);
            }
            if (n5 != -1) {
                this.setKeepAlive(n5);
                if (this.myDsession != null) {
                    this.myDsession.setKeepAlive(this.getKeepAlive());
                }
            }
            if (n6 != -1) {
                this.setKeepAliveWait(n6);
                if (this.myDsession != null) {
                    this.myDsession.setKeepAliveWait(this.getKeepAliveWait());
                }
            }
        }
        catch (TPException tPException) {
            if (bl2) {
                ntrace.doTrace((String)("*]/TDMRemoteTDomain/prepareUpdate/120/change failed for RemoteTuxDom: " + this.getAccessPoint()));
            }
            throw new BeanUpdateRejectedException(tPException.getMessage());
        }
        if (bl2) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/prepareUpdate/130/DONE");
        }
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/activateUpdate");
            ntrace.doTrace((String)"]/TDMRemoteTDomain/activateUpdate/10/DONE");
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = ntrace.isTraceEnabled((int)16);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/rollbackUpdate");
            ntrace.doTrace((String)"]/TDMRemoteTDomain/rollbackUpdate/10/DONE");
        }
    }

    public void registerListener() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/registerListener");
        }
        if (this.mBean != null && !this.registered) {
            if (bl) {
                ntrace.doTrace((String)("TDMRemoteTDomain: add Bean Update Listener: " + (Object)((Object)this)));
            }
            ((AbstractDescriptorBean)this.mBean).addBeanUpdateListener((BeanUpdateListener)this);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/registerListener/10/DONE");
        }
    }

    public void unregisterListener() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/unregisterListener");
        }
        if (this.mBean != null && this.registered) {
            if (bl) {
                ntrace.doTrace((String)("TDMRemoteTD: remove Bean Update Listener: " + (Object)((Object)this)));
            }
            ((AbstractDescriptorBean)this.mBean).removeBeanUpdateListener((BeanUpdateListener)this);
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/unregisterListener/10/DONE");
        }
    }

    public void removeConnectingTaskReference() {
        this.connectingTask = null;
    }

    public boolean hasConnectingTask() {
        return this.connectingTask != null;
    }

    public void terminateConnectingTask() {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/TDMRemoteTDomain/terminateConnectingTask/0");
        }
        if (this.connectingTask != null) {
            this.connectingTask.connectingTerminate();
        }
        if (bl) {
            ntrace.doTrace((String)"]/TDMRemoteTDomain/terminateConnectingTask/10/DONE");
        }
    }

    public void setNetworkAddr(String[] stringArray) {
    }

    public String[] getNetworkAddr() {
        return this.myNWAddr;
    }

    private final class TimedMutex {
        private boolean locked = false;

        private TimedMutex() {
        }

        public synchronized boolean acquire(long l) {
            if (l == 0L) {
                while (this.locked) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.notify();
                    }
                }
            } else if (this.locked) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                }
                if (this.locked) {
                    return false;
                }
            }
            this.locked = true;
            return true;
        }

        public synchronized boolean attempt() {
            if (this.locked) {
                return false;
            }
            this.locked = true;
            return true;
        }

        public synchronized void release() {
            this.locked = false;
            this.notify();
        }

        public boolean isLocked() {
            return this.locked;
        }
    }

    private class DoneException
    extends Exception {
        static final long serialVersionUID = -6282186224051838441L;

        private DoneException() {
        }
    }
}

