/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.apache.xerces.parsers.DOMParser;
import weblogic.jndi.Environment;
import weblogic.management.DistributedManagementException;
import weblogic.management.MBeanCreationException;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WTCExportMBean;
import weblogic.management.configuration.WTCImportMBean;
import weblogic.management.configuration.WTCLocalTuxDomMBean;
import weblogic.management.configuration.WTCPasswordMBean;
import weblogic.management.configuration.WTCRemoteTuxDomMBean;
import weblogic.management.configuration.WTCResourcesMBean;
import weblogic.management.configuration.WTCServerMBean;
import weblogic.management.configuration.WTCtBridgeGlobalMBean;
import weblogic.management.configuration.WTCtBridgeRedirectMBean;

public final class WTCMigrateCF {
    private int ltdcnt = 0;
    private File c_fname = null;
    private HashMap accessMap = new HashMap();
    private HashMap accessLMap = new HashMap();
    private HashMap accessRMap = new HashMap();
    private HashMap accessIdMap = new HashMap();
    private String currSection = null;
    private MBeanHome configHome = null;
    private String serverName = null;
    private String domainName = null;
    private ServerMBean srvrmb = null;
    private String wtcsmbNm = null;
    private WTCServerMBean wtcsmb;
    private static boolean DebugOn = false;
    private static boolean DeployOn = false;
    private static String[] myFldTbls16;
    private static String[] myFldTbls32;
    private static String[] myViewTbls16;
    private static String[] myViewTbls32;
    private static final String localDomainSection = "T_DM_LOCAL_TDOMAIN";
    private static final String remoteDomainSection = "T_DM_REMOTE_TDOMAIN";
    private static final String exportSection = "T_DM_EXPORT";
    private static final String importSection = "T_DM_IMPORT";
    private static final String passwdSection = "T_DM_PASSWORD";
    private static final String resourceSection = "T_DM_RESOURCES";
    private static final String redirSection = "fromto";
    private static final String tbglobalSection = "tBridge";

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: weblogic.wtc.gwt.WTCMigrateCF -url URL -username USERNAME -password PASSWORD -infile CONFIGWTC [-server SERVERNAME] [-domain DOMAIN] [-protocol PROTOCOL] [-deploy]");
            return;
        }
        WTCMigrateCF wTCMigrateCF = new WTCMigrateCF();
        if (System.getProperty("weblogic.wtc.migrateDebug") != null) {
            DebugOn = true;
        }
        wTCMigrateCF.migrate(stringArray);
    }

    WTCMigrateCF() {
    }

    void migrate(String[] stringArray) {
        int n;
        block38: {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-url")) {
                    if (DebugOn) {
                        System.out.println("URL: " + stringArray[n + 1]);
                    }
                    string = stringArray[n + 1];
                    continue;
                }
                if (stringArray[n].equals("-username")) {
                    if (DebugOn) {
                        System.out.println("USERNAME: " + stringArray[n + 1]);
                    }
                    string2 = stringArray[n + 1];
                    continue;
                }
                if (stringArray[n].equals("-password")) {
                    if (DebugOn) {
                        System.out.println("PASSWORD: " + stringArray[n + 1]);
                    }
                    string3 = stringArray[n + 1];
                    continue;
                }
                if (stringArray[n].equals("-infile")) {
                    if (DebugOn) {
                        System.out.println("INFILE: " + stringArray[n + 1]);
                    }
                    string4 = stringArray[n + 1];
                    continue;
                }
                if (stringArray[n].equals("-server")) {
                    if (DebugOn) {
                        System.out.println("SERVERNAME: " + stringArray[n + 1]);
                    }
                    this.serverName = stringArray[n + 1];
                    continue;
                }
                if (stringArray[n].equals("-domain")) {
                    if (DebugOn) {
                        System.out.println("DOMAINNAME: " + stringArray[n + 1]);
                    }
                    this.domainName = stringArray[n + 1];
                    continue;
                }
                if (stringArray[n].equals("-deploy")) {
                    if (DebugOn) {
                        System.out.println("DEPLOY is set: ");
                    }
                    DeployOn = true;
                    continue;
                }
                if (!stringArray[n].equals("-protocol")) continue;
                if (DebugOn) {
                    System.out.println("PROTOCOL: " + stringArray[n + 1]);
                }
                string5 = stringArray[n + 1];
            }
            if (string == null || string2 == null || string3 == null || string4 == null) {
                System.out.println("Usage: weblogic.wtc.gwt.WTCMigrateCF -url URL -username USERNAME -password PASSWORD -infile BDMCONFIG [-server SERVERNAME] [-domain DOMAIN] [-deploy]");
                return;
            }
            n = 1;
            try {
                Environment environment = new Environment();
                if (string5 == null) {
                    environment.setProviderUrl("t3:" + string);
                } else {
                    environment.setProviderUrl(string5 + ":" + string);
                }
                environment.setSecurityPrincipal(string2);
                environment.setSecurityCredentials(string3);
                Context context = environment.getInitialContext();
                this.configHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
                this.c_fname = new File(string4);
                System.out.println("Migrating WTC config file: " + this.c_fname.getPath());
                int n2 = (int)(Math.random() * 1000000.0);
                this.wtcsmbNm = "WTCServer-" + n2;
                if (this.serverName == null && this.domainName == null) {
                    this.serverName = this.configHome.getMBeanServer().getServerName();
                    this.domainName = this.configHome.getDomainName();
                } else if (this.serverName == null) {
                    this.serverName = this.configHome.getMBeanServer().getServerName();
                } else if (this.domainName == null) {
                    this.domainName = this.configHome.getDomainName();
                }
                this.srvrmb = (ServerMBean)this.configHome.getAdminMBean(this.serverName, "Server", this.domainName);
                this.wtcsmb = (WTCServerMBean)this.configHome.createAdminMBean(this.wtcsmbNm, "WTCServer", this.domainName);
                System.out.println("Using domain " + this.domainName + " and server " + this.serverName);
                if (!this.loadFile(this.c_fname)) {
                    System.out.println("ERROR: Migration failed for configuration file!");
                    return;
                }
                if (!DeployOn) break block38;
                try {
                    NamingEnumeration<Binding> namingEnumeration = context.listBindings("tuxedo.services");
                    if (namingEnumeration.hasMore()) {
                        DeployOn = false;
                        System.out.println("WARNING: Ignoring deploy option! Only one WTCServerMBean deployment permitted(at a time per server)");
                    }
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (DeployOn) {
                    this.wtcsmb.addTarget(this.srvrmb);
                }
            }
            catch (NamingException namingException) {
                System.out.println("NamingException ERROR: " + namingException.toString());
                n = 0;
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("NullPointerException ERROR: " + nullPointerException.toString());
                n = 0;
            }
            catch (MBeanCreationException mBeanCreationException) {
                System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
                n = 0;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
                n = 0;
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
                n = 0;
            }
            catch (DistributedManagementException distributedManagementException) {
                System.out.println("DistributedManagementException ERROR: " + distributedManagementException.toString());
                n = 0;
            }
            catch (ManagementException managementException) {
                System.out.println("ManagementException ERROR: " + managementException.toString());
                n = 0;
            }
        }
        if (n == 1) {
            System.out.println("The WTC configuration file migration is done!");
            System.out.println("No error found!!!");
        }
    }

    private boolean loadFile(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            InputSource inputSource = new InputSource(fileReader);
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            ((Reader)fileReader).close();
            fileReader = null;
            inputSource = null;
            Document document = dOMParser.getDocument();
            dOMParser = null;
            if (document == null) {
                System.out.println("ERROR: Parser returned null for Config doc.");
                return false;
            }
            if (!this.extractInfo(document)) {
                System.out.println("ERROR: Failed to extract the config attributes.");
                return false;
            }
            document = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: File not found, reason(" + fileNotFoundException.toString() + ")!");
            return false;
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IO Exception, reason(" + iOException.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (SAXException sAXException) {
            System.out.println("ERROR: SAX Exception, reason(" + sAXException.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ERROR: Invalid number format(" + numberFormatException.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception, reason(" + exception.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        return true;
    }

    private boolean extractInfo(Document document) throws Exception {
        String string;
        Element element;
        Node node;
        Element element2 = document.getDocumentElement();
        if (element2 == null) {
            System.out.println("ERROR: No top element from file " + this.c_fname.getPath());
            return false;
        }
        String string2 = element2.getTagName();
        if (string2 == null || !string2.equals("WTC_CONFIG")) {
            System.out.println("ERROR: Bad top element name \"" + string2 + "\" from config file " + this.c_fname.getPath());
            return false;
        }
        Node node2 = null;
        Element element3 = null;
        for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            element = (Element)node;
            string = element.getTagName();
            if (string.equals("BDMCONFIG")) {
                node2 = element;
                continue;
            }
            if (!string.equals(tbglobalSection)) continue;
            element3 = element;
        }
        if (node2 == null) {
            System.out.println("ERROR: No BDMCONFIG element in config file " + this.c_fname.getPath());
            return false;
        }
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string = (element = (Element)node).getTagName()).equals(localDomainSection)) continue;
            ++this.ltdcnt;
        }
        if (this.ltdcnt == 0) {
            System.out.println("ERROR: Requires at least one local domain defined.");
            return false;
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string = (element = (Element)node).getTagName()).equals(localDomainSection)) continue;
            bl = this.setupLocalTD(element, n2);
            if (!bl) {
                System.out.println("ERROR: Could not complete processing of element " + string);
                return false;
            }
            ++n2;
        }
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string = (element = (Element)node).getTagName()).equals(remoteDomainSection)) continue;
            bl = this.setupRemoteTD(element, n);
            if (!bl) {
                System.out.println("ERROR: Could not complete processing of element " + string);
                return false;
            }
            ++n;
        }
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            element = (Element)node;
            string = element.getTagName();
            if (string.equals(exportSection)) {
                bl = this.setupExport(element, n4);
                if (bl) {
                    ++n4;
                }
            } else if (string.equals(importSection)) {
                bl = this.setupImport(element, n5);
                if (bl) {
                    ++n5;
                }
            } else if (string.equals(passwdSection)) {
                bl = this.setupPasswd(element, n3);
                if (bl) {
                    ++n3;
                }
            } else if (string.equals(resourceSection)) {
                bl = this.setupResources(element);
            }
            if (bl) continue;
            System.out.println("ERROR: Could not complete processing of element " + string);
            return false;
        }
        if (element3 == null) {
            return true;
        }
        bl = this.setupTBGlobal(element3);
        if (!bl) {
            System.out.println("ERROR: Could not complete tBridge Global processing.");
            return false;
        }
        Element element4 = null;
        for (node = element3.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            element = (Element)node;
            string = element.getTagName();
            if (element4 != null || !string.equals("redirect")) continue;
            element4 = element;
            int n6 = 0;
            for (Node node3 = element4.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                Element element5;
                String string3;
                if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string3 = (element5 = (Element)node3).getTagName()).equals(redirSection)) continue;
                bl = this.setupRedirect(element5, n6);
                if (!bl) {
                    System.out.println("ERROR: Could not complete tBridge Redirect processing.");
                    return false;
                }
                ++n6;
            }
            break;
        }
        return true;
    }

    private boolean setupLocalTD(Element element, int n) throws Exception {
        String string = "ltd" + n;
        System.out.println("Processing LTDMBEAN : " + string + " started.");
        String string2 = this.currSection;
        this.currSection = localDomainSection;
        try {
            WTCLocalTuxDomMBean wTCLocalTuxDomMBean = (WTCLocalTuxDomMBean)this.configHome.createAdminMBean(string, "WTCLocalTuxDom", this.domainName, this.wtcsmb);
            String string3 = this.getEAVal(element, "AccessPoint");
            wTCLocalTuxDomMBean.setAccessPoint(string3);
            if (this.accessMap.put(string3, wTCLocalTuxDomMBean) != null) {
                System.out.println("ERROR: Duplicated AccessPoint " + string3 + " found in Local TDomain definitions!");
                this.currSection = string2;
                throw new Exception("Duplicated LTD AccessPoint");
            }
            this.accessLMap.put(string3, wTCLocalTuxDomMBean);
            String string4 = this.getSubElemText(element, "AccessPointId", true);
            if (this.accessIdMap.put(string4, wTCLocalTuxDomMBean) != null) {
                System.out.println("ERROR: Duplicated AccessPointId " + string4 + " found in Local TDomain definitions!");
                this.currSection = string2;
                throw new Exception("Duplicated LTD AccessPointId");
            }
            wTCLocalTuxDomMBean.setAccessPointId(string4);
            wTCLocalTuxDomMBean.setNWAddr(this.getSubElemText(element, "NWAddr", true));
            String string5 = this.getSubElemText(element, "Security", false);
            if (string5 != null) {
                wTCLocalTuxDomMBean.setSecurity(string5);
            }
            if ((string5 = this.getSubElemText(element, "ConnectionPolicy", false)) != null) {
                wTCLocalTuxDomMBean.setConnectionPolicy(string5);
            }
            if ((string5 = this.getSubElemText(element, "Interoperate", false)) != null) {
                wTCLocalTuxDomMBean.setInteroperate(string5);
            }
            if ((string5 = this.getSubElemText(element, "RetryInterval", false)) != null) {
                wTCLocalTuxDomMBean.setRetryInterval(Long.parseLong(string5, 10));
            }
            if ((string5 = this.getSubElemText(element, "MaxRetries", false)) != null) {
                wTCLocalTuxDomMBean.setMaxRetries(Long.parseLong(string5, 10));
            }
            if ((string5 = this.getSubElemText(element, "BlockTime", false)) != null) {
                wTCLocalTuxDomMBean.setBlockTime(Long.parseLong(string5));
            }
            if ((string5 = this.getSubElemText(element, "CmpLimit", false)) != null) {
                wTCLocalTuxDomMBean.setCmpLimit(Integer.parseInt(string5, 10));
            }
            int n2 = -1;
            string5 = this.getSubElemText(element, "MinEncryptBits", false);
            if (string5 != null) {
                n2 = Integer.parseInt(string5, 10);
                wTCLocalTuxDomMBean.setMinEncryptBits(string5);
            }
            int n3 = -1;
            string5 = this.getSubElemText(element, "MaxEncryptBits", false);
            if (string5 != null) {
                n3 = Integer.parseInt(string5, 10);
                wTCLocalTuxDomMBean.setMaxEncryptBits(string5);
            }
            if (n2 != -1 && n3 != -1 && n2 > n3) {
                System.out.println("ERROR: MinEncryptBits > MaxEncryptBits  found in Local TDomain definition!");
                this.currSection = string2;
                throw new Exception("MinEncryptBits > MaxEncryptBits");
            }
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string2;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string2;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string2;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCLocalTuxDomMBean , reason(" + exception.toString() + ")!");
            this.currSection = string2;
            throw exception;
        }
        this.currSection = string2;
        System.out.println("Processing LTDMBEAN : " + string + " done.");
        return true;
    }

    private boolean setupRemoteTD(Element element, int n) throws Exception {
        String string = "rtd" + n;
        System.out.println("Processing RTDMBEAN : " + string + " started.");
        String string2 = this.currSection;
        this.currSection = remoteDomainSection;
        try {
            WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean = (WTCRemoteTuxDomMBean)this.configHome.createAdminMBean(string, "WTCRemoteTuxDom", this.domainName, this.wtcsmb);
            String string3 = this.getEAVal(element, "AccessPoint");
            wTCRemoteTuxDomMBean.setAccessPoint(string3);
            if (this.accessMap.put(string3, wTCRemoteTuxDomMBean) != null) {
                System.out.println("ERROR: Duplicated AccessPoint " + string3 + " found in Remote TDomain definition!");
                this.currSection = string2;
                throw new Exception("Duplicated RTD AccessPoint");
            }
            this.accessRMap.put(string3, wTCRemoteTuxDomMBean);
            String string4 = this.getSubElemText(element, "LocalAccessPoint", true);
            if (!this.accessLMap.containsKey(string4)) {
                System.out.println("ERROR: Undefined LocalAccessPoint " + string4 + " found in Remote TDomain definition!");
                this.currSection = string2;
                throw new Exception("Undefined RTD LocalAccessPoint");
            }
            wTCRemoteTuxDomMBean.setLocalAccessPoint(string4);
            String string5 = this.getSubElemText(element, "AccessPointId", true);
            StringBuffer stringBuffer = new StringBuffer(string5).append(string4);
            String string6 = stringBuffer.toString();
            if (this.accessIdMap.put(string6, wTCRemoteTuxDomMBean) != null) {
                System.out.println("ERROR: Duplicated combination of RemoteAccessPointId(" + string5 + ") and Local AccessPoint(" + string4 + ") found in Remote TDomain definitions!");
                this.currSection = string2;
                throw new Exception("Duplicated RTD AccessPointId");
            }
            wTCRemoteTuxDomMBean.setAccessPointId(string5);
            wTCRemoteTuxDomMBean.setNWAddr(this.getSubElemText(element, "NWAddr", true));
            String string7 = this.getSubElemText(element, "AclPolicy", false);
            if (string7 != null) {
                wTCRemoteTuxDomMBean.setAclPolicy(string7);
            }
            if ((string7 = this.getSubElemText(element, "CredentialPolicy", false)) != null) {
                wTCRemoteTuxDomMBean.setCredentialPolicy(string7);
            }
            if ((string7 = this.getSubElemText(element, "TpUsrFile", false)) != null) {
                wTCRemoteTuxDomMBean.setTpUsrFile(string7);
            }
            if ((string7 = this.getSubElemText(element, "CmpLimit", false)) != null) {
                wTCRemoteTuxDomMBean.setCmpLimit(Integer.parseInt(string7, 10));
            }
            int n2 = -1;
            string7 = this.getSubElemText(element, "MinEncryptBits", false);
            if (string7 != null) {
                n2 = Integer.parseInt(string7, 10);
                wTCRemoteTuxDomMBean.setMinEncryptBits(string7);
            }
            int n3 = -1;
            string7 = this.getSubElemText(element, "MaxEncryptBits", false);
            if (string7 != null) {
                n3 = Integer.parseInt(string7, 10);
                wTCRemoteTuxDomMBean.setMaxEncryptBits(string7);
            }
            if (n2 != -1 && n3 != -1 && n2 > n3) {
                System.out.println("ERROR: MinEncryptBits > MaxEncryptBits  found in Remote TDomain definition!");
                this.currSection = string2;
                throw new Exception("MinEncryptBits > MaxEncryptBits");
            }
            string7 = this.getSubElemText(element, "ConnectionPolicy", false);
            if (string7 != null) {
                wTCRemoteTuxDomMBean.setConnectionPolicy(string7);
            }
            if ((string7 = this.getSubElemText(element, "RetryInterval", false)) != null) {
                wTCRemoteTuxDomMBean.setRetryInterval(Long.parseLong(string7, 10));
            }
            if ((string7 = this.getSubElemText(element, "MaxRetries", false)) != null) {
                wTCRemoteTuxDomMBean.setMaxRetries(Long.parseLong(string7, 10));
            }
            if ((string7 = this.getSubElemText(element, "FederationURL", false)) != null) {
                wTCRemoteTuxDomMBean.setFederationURL(string7);
            }
            if ((string7 = this.getSubElemText(element, "FederationName", false)) != null) {
                wTCRemoteTuxDomMBean.setFederationName(string7);
            }
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string2;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string2;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string2;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCRemoteTuxDomMBean , reason(" + exception.toString() + ")!");
            this.currSection = string2;
            throw exception;
        }
        this.currSection = string2;
        System.out.println("Processing RTDMBEAN : " + string + " done.");
        return true;
    }

    private boolean setupExport(Element element, int n) throws Exception {
        String string = "exp" + n;
        System.out.println("Processing EXPMBEAN : " + string + " started.");
        String string2 = this.currSection;
        this.currSection = exportSection;
        try {
            WTCExportMBean wTCExportMBean = (WTCExportMBean)this.configHome.createAdminMBean(string, "WTCExport", this.domainName, this.wtcsmb);
            String string3 = this.getEAVal(element, "LocalAccessPoint");
            if (!this.accessLMap.containsKey(string3)) {
                System.out.println("ERROR: Undefined LocalAccessPoint " + string3 + " found in Export definition!");
                this.currSection = string2;
                throw new Exception("Undefined Export LocalAccessPoint");
            }
            wTCExportMBean.setLocalAccessPoint(string3);
            wTCExportMBean.setResourceName(this.getEAVal(element, "ResourceName"));
            String string4 = this.getSubElemText(element, "RemoteName", false);
            if (string4 != null) {
                wTCExportMBean.setRemoteName(string4);
            }
            if ((string4 = this.getSubElemText(element, "EJBName", false)) != null) {
                wTCExportMBean.setEJBName(string4);
            }
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string2;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string2;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string2;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCExport , reason(" + exception.toString() + ")!");
            this.currSection = string2;
            throw exception;
        }
        this.currSection = string2;
        System.out.println("Processing EXPMBEAN : " + string + " done.");
        return true;
    }

    private boolean setupImport(Element element, int n) throws Exception {
        String string = "imp" + n;
        System.out.println("Processing IMPMBEAN : " + string + " started.");
        String string2 = this.currSection;
        this.currSection = importSection;
        try {
            String string3;
            WTCImportMBean wTCImportMBean = (WTCImportMBean)this.configHome.createAdminMBean(string, "WTCImport", this.domainName, this.wtcsmb);
            String string4 = this.getEAVal(element, "LocalAccessPoint");
            if (!this.accessLMap.containsKey(string4)) {
                System.out.println("ERROR: Undefined LocalAccessPoint " + string4 + " found in Import definition!");
                this.currSection = string2;
                throw new Exception("Undefined Import LocalAccessPoint");
            }
            wTCImportMBean.setLocalAccessPoint(string4);
            wTCImportMBean.setResourceName(this.getEAVal(element, "ResourceName"));
            String string5 = this.getSubElemText(element, "RemoteName", false);
            if (string5 != null) {
                wTCImportMBean.setRemoteName(string5);
            }
            if ((string3 = this.getEAVal(element, "RemoteAccessPointList")).indexOf(44) == -1) {
                if (!this.accessRMap.containsKey(string3)) {
                    System.out.println("ERROR: Undefined RemoteAccessPoint " + string3 + " in Import RemoteAccessPointList definition!");
                    this.currSection = string2;
                    throw new Exception("Undefined Import RemoteAccessPoint");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (this.accessRMap.containsKey(string6)) continue;
                    System.out.println("ERROR: Undefined RemoteAccessPoint " + string6 + " in Import RemoteAccessPointList definition!");
                    this.currSection = string2;
                    throw new Exception("Undefined Import RemoteAccessPoint");
                }
            }
            wTCImportMBean.setRemoteAccessPointList(string3);
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string2;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string2;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string2;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCImport , reason(" + exception.toString() + ")!");
            this.currSection = string2;
            throw exception;
        }
        this.currSection = string2;
        System.out.println("Processing IMPMBEAN : " + string + " done.");
        return true;
    }

    private boolean setupPasswd(Element element, int n) throws Exception {
        String string = "pwd" + n;
        System.out.println("Processing PASSWDMBEAN : " + string + " started.");
        String string2 = this.currSection;
        this.currSection = passwdSection;
        try {
            WTCPasswordMBean wTCPasswordMBean = (WTCPasswordMBean)this.configHome.createAdminMBean(string, "WTCPassword", this.domainName, this.wtcsmb);
            String string3 = this.getEAVal(element, "LocalAccessPoint");
            if (!this.accessLMap.containsKey(string3)) {
                System.out.println("ERROR: Undefined LocalAccessPoint " + string3 + " found in Export definition!");
                this.currSection = string2;
                throw new Exception("Undefined Export LocalAccessPoint");
            }
            wTCPasswordMBean.setLocalAccessPoint(string3);
            String string4 = this.getEAVal(element, "RemoteAccessPoint");
            if (!this.accessRMap.containsKey(string4)) {
                System.out.println("ERROR: Undefined RemoteAccessPoint " + string4 + " found in Password definition!");
                this.currSection = string2;
                throw new Exception("Undefined Password RemoteAccessPoint");
            }
            wTCPasswordMBean.setRemoteAccessPoint(string4);
            wTCPasswordMBean.setLocalPassword(this.getSubElemText(element, "LocalPassword", true));
            wTCPasswordMBean.setLocalPasswordIV(this.getSubEAVal(element, "LocalPassword", "IV"));
            wTCPasswordMBean.setRemotePassword(this.getSubElemText(element, "RemotePassword", true));
            wTCPasswordMBean.setRemotePasswordIV(this.getSubEAVal(element, "RemotePassword", "IV"));
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string2;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string2;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string2;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCPassword , reason(" + exception.toString() + ")!");
            this.currSection = string2;
            throw exception;
        }
        this.currSection = string2;
        System.out.println("Processing PASSWDMBEAN : " + string + " done.");
        return true;
    }

    private boolean setupResources(Element element) throws Exception {
        WTCResourcesMBean wTCResourcesMBean;
        System.out.println("Processing RESMBEAN started");
        String string = this.currSection;
        this.currSection = resourceSection;
        try {
            wTCResourcesMBean = (WTCResourcesMBean)this.configHome.createAdminMBean("res1", "WTCResources", this.domainName, this.wtcsmb);
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string;
            throw new Exception(mBeanCreationException.toString());
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2;
            Node node2;
            String string3;
            Element element2;
            String string4;
            Node node3;
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            Element element3 = (Element)node;
            String string5 = element3.getTagName();
            int n = 0;
            int n2 = 0;
            if (string5.equals("FieldTables")) {
                n = 0;
                n2 = 0;
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string4 = (element2 = (Element)node3).getTagName()).equals("FldTblClass")) continue;
                    string3 = this.getEAVal(element2, "Type");
                    if (string3 == null) {
                        System.out.println("ERROR: Type for the Field Table is not specified!");
                        this.currSection = string;
                        return false;
                    }
                    if (string3.equals("fml32")) {
                        ++n2;
                        continue;
                    }
                    if (!string3.equals("fml16")) continue;
                    ++n;
                }
                if (n != 0) {
                    myFldTbls16 = new String[n];
                }
                if (n2 != 0) {
                    myFldTbls32 = new String[n2];
                }
                n = 0;
                n2 = 0;
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string4 = (element2 = (Element)node3).getTagName()).equals("FldTblClass")) continue;
                    node2 = element2.getFirstChild();
                    if (node2 == null) {
                        System.out.println("ERROR: Can not get TNODE!");
                        this.currSection = string;
                        return false;
                    }
                    string2 = node2.getNodeValue();
                    if (string2 == null) {
                        System.out.println("ERROR: Can not get FldTbl NODE value!");
                        this.currSection = string;
                        return false;
                    }
                    try {
                        string3 = this.getEAVal(element2, "Type");
                        if (string3.equals("fml32")) {
                            WTCMigrateCF.myFldTbls32[n2] = string2.trim();
                            ++n2;
                            continue;
                        }
                        if (string3.equals("fml16")) {
                            WTCMigrateCF.myFldTbls16[n] = string2.trim();
                            ++n;
                            continue;
                        }
                        System.out.println("WARNING: Unknown Type label for FldTblClass: " + string3);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: Can not get Resources FldTbl Typeobject, reason(" + exception.toString() + ")!");
                        this.currSection = string;
                        throw exception;
                    }
                }
                try {
                    if (n != 0) {
                        wTCResourcesMBean.setFldTbl16Classes(myFldTbls16);
                    }
                    if (n2 == 0) continue;
                    wTCResourcesMBean.setFldTbl32Classes(myFldTbls32);
                    continue;
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
                    this.currSection = string;
                    throw new Exception(invalidAttributeValueException.toString());
                }
            }
            if (string5.equals("ViewTables")) {
                n = 0;
                n2 = 0;
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string4 = (element2 = (Element)node3).getTagName()).equals("ViewTblClass")) continue;
                    string3 = this.getEAVal(element2, "Type");
                    if (string3 == null) {
                        System.out.println("ERROR: Type for the Field Table is not  specified!");
                        this.currSection = string;
                        return false;
                    }
                    if (string3.equals("view32")) {
                        ++n2;
                        continue;
                    }
                    if (!string3.equals("view16")) continue;
                    ++n;
                }
                if (n != 0) {
                    myViewTbls16 = new String[n];
                }
                if (n2 != 0) {
                    myViewTbls32 = new String[n2];
                }
                n = 0;
                n2 = 0;
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string4 = (element2 = (Element)node3).getTagName()).equals("ViewTblClass")) continue;
                    node2 = element2.getFirstChild();
                    if (node2 == null) {
                        System.out.println("ERROR: Can not get TNODE!");
                        this.currSection = string;
                        return false;
                    }
                    string2 = node2.getNodeValue();
                    if (string2 == null) {
                        System.out.println("ERROR: Can not get ViewTbl NODE value!");
                        this.currSection = string;
                        return false;
                    }
                    try {
                        string3 = this.getEAVal(element2, "Type");
                        if (string3.equals("view32")) {
                            WTCMigrateCF.myViewTbls32[n2] = string2.trim();
                            ++n2;
                            continue;
                        }
                        if (string3.equals("view16")) {
                            WTCMigrateCF.myViewTbls16[n] = string2.trim();
                            ++n;
                            continue;
                        }
                        System.out.println("WARNING: Unknown Type label for ViewTblClass: " + string3);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: Getting Resources ViewTbl Type, reason(" + exception.toString() + ")!");
                        this.currSection = string;
                        throw exception;
                    }
                }
                try {
                    if (n != 0) {
                        wTCResourcesMBean.setViewTbl16Classes(myViewTbls16);
                    }
                    if (n2 == 0) continue;
                    wTCResourcesMBean.setViewTbl32Classes(myViewTbls32);
                    continue;
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
                    this.currSection = string;
                    throw new Exception(invalidAttributeValueException.toString());
                }
            }
            if (!string5.equals("AppPassword")) continue;
            try {
                node2 = element3.getFirstChild();
                if (node2 == null) {
                    System.out.println("ERROR: No TNODE for AppPassword was found!");
                    this.currSection = string;
                    return false;
                }
                String string6 = node2.getNodeValue();
                if (string6 == null) {
                    System.out.println("ERROR: Failed to get AppPassword text!");
                    this.currSection = string;
                    return false;
                }
                wTCResourcesMBean.setAppPassword(string6.trim());
                wTCResourcesMBean.setAppPasswordIV(this.getEAVal(element3, "IV"));
                continue;
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
                this.currSection = string;
                throw new Exception(invalidAttributeValueException.toString());
            }
            catch (Exception exception) {
                System.out.println("ERROR: Couldn't handle Resources App Passwd/IV info, reason(" + exception.toString() + ")!");
                this.currSection = string;
                throw exception;
            }
        }
        this.currSection = string;
        System.out.println("Processing RESMBEAN done");
        return true;
    }

    private boolean setupRedirect(Element element, int n) throws Exception {
        String string = "redir" + n;
        System.out.println("Processing REDIRECTMBEAN : " + string + " started.");
        String string2 = this.currSection;
        this.currSection = redirSection;
        try {
            WTCtBridgeRedirectMBean wTCtBridgeRedirectMBean = (WTCtBridgeRedirectMBean)this.configHome.createAdminMBean(string, "WTCtBridgeRedirect", this.domainName, this.wtcsmb);
            wTCtBridgeRedirectMBean.setDirection(this.getSubElemText(element, "direction", true));
            String string3 = this.getSubElemText(element, "translateFML", false);
            if (string3 != null) {
                if (string3.equalsIgnoreCase("NO")) {
                    string3 = "NO";
                }
                wTCtBridgeRedirectMBean.setTranslateFML(string3);
            }
            if ((string3 = this.getSubElemText(element, "replyQ", false)) != null) {
                wTCtBridgeRedirectMBean.setReplyQ(string3);
            }
            if ((string3 = this.getSubElemText(element, "metadataFile", false)) != null) {
                wTCtBridgeRedirectMBean.setMetaDataFile(string3);
            }
            Element element2 = this.getSubElem(element, "source", true);
            wTCtBridgeRedirectMBean.setSourceName(this.getSubElemText(element2, "Name", true));
            string3 = this.getSubElemText(element2, "AccessPoint", false);
            if (string3 != null) {
                wTCtBridgeRedirectMBean.setSourceAccessPoint(string3);
            }
            if ((string3 = this.getSubElemText(element2, "Qspace", false)) != null) {
                wTCtBridgeRedirectMBean.setSourceQspace(string3);
            }
            element2 = this.getSubElem(element, "target", true);
            wTCtBridgeRedirectMBean.setTargetName(this.getSubElemText(element2, "Name", true));
            string3 = this.getSubElemText(element2, "AccessPoint", false);
            if (string3 != null) {
                wTCtBridgeRedirectMBean.setTargetAccessPoint(string3);
            }
            if ((string3 = this.getSubElemText(element2, "Qspace", false)) != null) {
                wTCtBridgeRedirectMBean.setTargetQspace(string3);
            }
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string2;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string2;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string2;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCtBridgeRedirect , reason(" + exception.toString() + ")!");
            this.currSection = string2;
            throw exception;
        }
        this.currSection = string2;
        System.out.println("Processing REDIRECTMBEAN : " + string + " done.");
        return true;
    }

    private boolean setupTBGlobal(Element element) throws Exception {
        System.out.println("Processing TBGLOBALMBEAN started.");
        String string = this.currSection;
        this.currSection = tbglobalSection;
        try {
            WTCtBridgeGlobalMBean wTCtBridgeGlobalMBean = (WTCtBridgeGlobalMBean)this.configHome.createAdminMBean("tbgbl1", "WTCtBridgeGlobal", this.domainName, this.wtcsmb);
            String string2 = this.getSubElemText(element, "transactional", false);
            if (string2 != null) {
                wTCtBridgeGlobalMBean.setTransactional(string2);
            }
            if ((string2 = this.getSubElemText(element, "timeout", false)) != null) {
                wTCtBridgeGlobalMBean.setTimeout(Integer.parseInt(string2, 10));
            }
            if ((string2 = this.getSubElemText(element, "retries", false)) != null) {
                wTCtBridgeGlobalMBean.setRetries(Integer.parseInt(string2, 10));
            }
            if ((string2 = this.getSubElemText(element, "retryDelay", false)) != null) {
                wTCtBridgeGlobalMBean.setRetryDelay(Integer.parseInt(string2, 10));
            }
            if ((string2 = this.getSubElemText(element, "wlsErrorDestination", false)) != null) {
                wTCtBridgeGlobalMBean.setWlsErrorDestination(string2);
            }
            if ((string2 = this.getSubElemText(element, "tuxErrorQueue", false)) != null) {
                wTCtBridgeGlobalMBean.setTuxErrorQueue(string2);
            }
            if ((string2 = this.getSubElemText(element, "deliveryModeOverride", false)) != null) {
                wTCtBridgeGlobalMBean.setDeliveryModeOverride(string2);
            }
            if ((string2 = this.getSubElemText(element, "defaultreplyDeliveryMode", false)) != null) {
                wTCtBridgeGlobalMBean.setDefaultReplyDeliveryMode(string2);
            }
            if ((string2 = this.getSubElemText(element, "userID", false)) != null) {
                wTCtBridgeGlobalMBean.setUserId(string2);
            }
            if ((string2 = this.getSubElemText(element, "allowNonStandardTypes", false)) != null) {
                wTCtBridgeGlobalMBean.setAllowNonStandardTypes(string2);
            }
            wTCtBridgeGlobalMBean.setJndiFactory(this.getSubElemText(element, "jndiFactory", true));
            wTCtBridgeGlobalMBean.setJmsFactory(this.getSubElemText(element, "jmsFactory", true));
            wTCtBridgeGlobalMBean.setTuxFactory(this.getSubElemText(element, "tuxFactory", true));
            String string3 = this.getPmaps(element, "TuxtoJms");
            if (string3 != null) {
                wTCtBridgeGlobalMBean.setTuxToJmsPriorityMap(string3);
            }
            if ((string3 = this.getPmaps(element, "JmstoTux")) != null) {
                wTCtBridgeGlobalMBean.setJmsToTuxPriorityMap(string3);
            }
        }
        catch (MBeanCreationException mBeanCreationException) {
            System.out.println("MBeanCreationException ERROR: " + mBeanCreationException.toString());
            this.currSection = string;
            throw new Exception(mBeanCreationException.toString());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            System.out.println("InvalidattributeException ERROR: " + invalidAttributeValueException.toString());
            this.currSection = string;
            throw new Exception(invalidAttributeValueException.toString());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            System.out.println("InstanceNotFoundException ERROR: " + instanceNotFoundException.toString());
            this.currSection = string;
            throw new Exception(instanceNotFoundException.toString());
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create WTCtBridgeGlobal , reason(" + exception.toString() + ")!");
            this.currSection = string;
            throw exception;
        }
        this.currSection = string;
        System.out.println("Processing TBGLOBALMBEAN done.");
        return true;
    }

    private String getPmaps(Element element, String string) throws Exception {
        if (DebugOn) {
            System.out.println("getPmaps entry: " + string);
        }
        if (element == null) {
            System.out.println("ERROR: The tBridge input was not defined.");
            throw new Exception("Element should always be defined");
        }
        Element element2 = this.getSubElem(element, "priorityMapping", false);
        if (element2 == null) {
            return null;
        }
        Element element3 = this.getSubElem(element2, string, true);
        String string2 = null;
        for (Node node = element3.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element4;
            String string3;
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string3 = (element4 = (Element)node).getTagName()).equals("pMap")) continue;
            String string4 = this.getSubElemText(element4, "value", true);
            String string5 = this.getSubElemText(element4, "range", true);
            string2 = string2 == null ? string4 + ":" + string5 : string2 + "|" + string4 + ":" + string5;
        }
        if (DebugOn) {
            System.out.println("getPmaps returns: " + string2);
        }
        return string2;
    }

    private String getEAVal(Element element, String string) throws Exception {
        String string2;
        if (DebugOn) {
            System.out.println("getEAVal entry: " + string);
        }
        if ((string2 = element.getAttribute(string)) == null) {
            System.out.println("ERROR: The element " + element.getTagName() + " does not have an attribute " + string + " defined!");
            throw new Exception("Element missing attribute");
        }
        if (DebugOn) {
            System.out.println("getEAVal returns: " + string2);
        }
        return string2;
    }

    private String getSubElemText(Element element, String string, boolean bl) throws Exception {
        NodeList nodeList;
        if (DebugOn) {
            System.out.println("getSubElemText entry: " + string);
        }
        if ((nodeList = element.getElementsByTagName(string)).getLength() != 1) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " does not have one(and only one) sub element of the tag name " + string + "!");
                throw new Exception("Count error on subelements");
            }
            return null;
        }
        Node node = nodeList.item(0);
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " has zero sub element of the tag name " + string + "!");
                throw new Exception("Missing subelement");
            }
            return null;
        }
        String string2 = node2.getNodeValue();
        if (string2 == null) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " has the sub element of the tag name " + string + " without value!");
                throw new Exception("Missing subelement value");
            }
            return null;
        }
        if (DebugOn) {
            System.out.println("getSubElemText returns: " + string2);
        }
        return string2.trim();
    }

    private String getSubEAVal(Element element, String string, String string2) throws Exception {
        NodeList nodeList;
        if (DebugOn) {
            System.out.println("getSubEAVal entry: " + string + " " + string2);
        }
        if ((nodeList = element.getElementsByTagName(string)).getLength() != 1) {
            System.out.println("ERROR: The parent element " + element.getTagName() + " does not have one(and only one) sub element of the tag name " + string + "!");
            throw new Exception("Missing subelement");
        }
        Element element2 = (Element)nodeList.item(0);
        String string3 = element2.getAttribute(string2);
        if (string3 == null) {
            System.out.println("ERROR: The element " + element.getTagName() + " does not have an attribute " + string + " defined!");
            throw new Exception("Missing subelement value");
        }
        if (DebugOn) {
            System.out.println("getSubEAVal returns: " + string3);
        }
        return string3;
    }

    private Element getSubElem(Element element, String string, boolean bl) throws Exception {
        NodeList nodeList;
        if (DebugOn) {
            System.out.println("getSubElem entry: " + string);
        }
        if ((nodeList = element.getElementsByTagName(string)).getLength() != 1) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " does not have one(and only one) sub element of the tag name " + string + "!");
                throw new Exception("Missing subelement");
            }
            return null;
        }
        if (DebugOn) {
            System.out.println("getSubElem returns: ");
        }
        return (Element)nodeList.item(0);
    }
}

