/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.wtc.gwt.WTCService;

public final class WTCServerLifeCycleImpl
extends AbstractServerService {
    private WTCService wtcService;

    public void start() throws ServiceFailureException {
        try {
            this.wtcService = WTCService.getService();
            this.wtcService.initializeCommon();
            this.wtcService.resumeCommon();
        }
        catch (Throwable throwable) {
            throw new ServiceFailureException("WTC service failed in initialization", throwable);
        }
    }

    public void stop() throws ServiceFailureException {
        try {
            this.wtcService.suspend(false);
            this.shutdown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ServiceFailureException("Failed to suspend WTC service. The first Throwable is " + throwable);
        }
    }

    public void halt() throws ServiceFailureException {
        try {
            this.wtcService.suspend(true);
            this.shutdown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ServiceFailureException("Failed to suspend WTC service. The first Throwable is " + throwable);
        }
    }

    private void shutdown() throws ServiceFailureException {
        try {
            this.wtcService.shutdownCommon();
        }
        catch (Exception exception) {
            throw new ServiceFailureException("WTCService failed to shutdown ", (Throwable)exception);
        }
    }
}

