/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.gwt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.apache.xerces.parsers.DOMParser;
import weblogic.wtc.gwt.RDomainListEntry;
import weblogic.wtc.gwt.TDMExport;
import weblogic.wtc.gwt.TDMImport;
import weblogic.wtc.gwt.TDMLocal;
import weblogic.wtc.gwt.TDMLocalTDomain;
import weblogic.wtc.gwt.TDMPasswd;
import weblogic.wtc.gwt.TDMRemote;
import weblogic.wtc.gwt.TDMRemoteTDomain;
import weblogic.wtc.gwt.WTCMBeanObject;
import weblogic.wtc.jatmi.FldTbl;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.ViewHelper;

public final class WTCValidateCF {
    private Hashtable myImportedServices = new Hashtable();
    private Hashtable myExportedServices = new Hashtable();
    private FldTbl[] myFldTbls16;
    private FldTbl[] myFldTbls32;
    private TDMLocalTDomain[] ltd_list;
    private TDMRemoteTDomain[] rtd_list;
    private TDMPasswd[] pwd_list;
    private String myAppPwIV;
    private String myAppPwPWD;
    private int ltdcnt = 0;
    private int rtdcnt = 0;
    private int pwdcnt = 0;
    private File c_fname = null;
    private HashMap accessMap = new HashMap();
    private String currSection = null;
    private static final String localDomainSection = "T_DM_LOCAL_TDOMAIN";
    private static final String remoteDomainSection = "T_DM_REMOTE_TDOMAIN";
    private static final String exportSection = "T_DM_EXPORT";
    private static final String importSection = "T_DM_IMPORT";
    private static final String passwdSection = "T_DM_PASSWORD";
    private static final String resourceSection = "T_DM_RESOURCES";

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: WTCValidateCF <BDMCONFIG>");
            return;
        }
        String string = stringArray[0];
        WTCValidateCF wTCValidateCF = new WTCValidateCF();
        wTCValidateCF.checkSyntax(string);
    }

    WTCValidateCF() {
    }

    void checkSyntax(String string) {
        try {
            this.c_fname = new File(string);
            System.out.println("Validating Config file " + this.c_fname.getPath() + "...");
            if (!this.loadFile(this.c_fname)) {
                System.out.println("ERROR: Validation failed for configuration XML file!");
                return;
            }
            System.out.println("The XML configuration file validation is done!");
            System.out.println("No error found!!!");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ERROR: " + nullPointerException.toString());
        }
    }

    private boolean loadFile(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            InputSource inputSource = new InputSource(fileReader);
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            ((Reader)fileReader).close();
            fileReader = null;
            inputSource = null;
            Document document = dOMParser.getDocument();
            dOMParser = null;
            if (document == null) {
                System.out.println("ERROR: Parser returned null for Config doc.");
                return false;
            }
            if (!this.extractInfo(document)) {
                System.out.println("ERROR: Failed to extract the config attributes.");
                return false;
            }
            document = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: File not found, reason(" + fileNotFoundException.toString() + ")!");
            return false;
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IO Exception, reason(" + iOException.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (SAXException sAXException) {
            System.out.println("ERROR: SAX Exception, reason(" + sAXException.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (TPException tPException) {
            System.out.println("ERROR: TP Exception, reason(" + tPException.getMessage() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ERROR: Invalid number format(" + numberFormatException.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception, reason(" + exception.toString() + ")!");
            if (this.currSection != null) {
                System.out.println("INFO: error occurred in " + this.currSection + " element.");
            }
            return false;
        }
        return true;
    }

    private boolean extractInfo(Document document) throws TPException {
        Element element;
        String string;
        Node node;
        Element element2 = document.getDocumentElement();
        if (element2 == null) {
            System.out.println("ERROR: No top element from file " + this.c_fname.getPath());
            return false;
        }
        String string2 = element2.getTagName();
        if (string2 == null || !string2.equals("WTC_CONFIG")) {
            System.out.println("ERROR: Bad top element name \"" + string2 + "\" from config file " + this.c_fname.getPath());
            return false;
        }
        Node node2 = null;
        for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string = (element = (Element)node).getTagName()).equals("tBridge")) continue;
            System.out.println("INFO: tBridge is configured.");
            break;
        }
        for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string = (element = (Element)node).getTagName()).equals("BDMCONFIG")) continue;
            node2 = element;
            break;
        }
        if (node2 == null) {
            System.out.println("ERROR: No BDMCONFIG element in config file " + this.c_fname.getPath());
            return false;
        }
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            element = (Element)node;
            string = element.getTagName();
            if (string.equals(localDomainSection)) {
                ++this.ltdcnt;
                continue;
            }
            if (string.equals(remoteDomainSection)) {
                ++this.rtdcnt;
                continue;
            }
            if (!string.equals(passwdSection)) continue;
            ++this.pwdcnt;
        }
        if (this.ltdcnt == 0) {
            System.out.println("ERROR: Requires at least one local domain defined.");
            return false;
        }
        this.ltd_list = new TDMLocalTDomain[this.ltdcnt];
        if (this.rtdcnt != 0) {
            this.rtd_list = new TDMRemoteTDomain[this.rtdcnt];
        }
        if (this.pwdcnt != 0) {
            this.pwd_list = new TDMPasswd[this.pwdcnt];
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element) || !(string = (element = (Element)node).getTagName()).equals(localDomainSection)) continue;
            bl = this.setupTDMLocalTD(element, n2);
            if (!bl) {
                System.out.println("ERROR: Could not complete processing of element " + string);
                return false;
            }
            ++n2;
        }
        for (node = node2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            element = (Element)node;
            string = element.getTagName();
            if (string.equals(remoteDomainSection)) {
                bl = this.setupTDMRemoteTD(element, n);
                if (bl) {
                    ++n;
                }
            } else if (string.equals(exportSection)) {
                bl = this.setupTDMExport(element);
            } else if (string.equals(importSection)) {
                bl = this.setupTDMImport(element);
            } else if (string.equals(passwdSection)) {
                bl = this.setupTDMPasswd(element, n3);
                if (bl) {
                    ++n3;
                }
            } else if (string.equals(resourceSection)) {
                bl = this.setupTDMResources(element);
            }
            if (bl) continue;
            System.out.println("ERROR: Could not complete processing of element " + string);
            return false;
        }
        if (!this.crossChecking()) {
            System.out.println("ERROR: Second phase processing failed.");
            return false;
        }
        return true;
    }

    private boolean setupTDMLocalTD(Element element, int n) throws TPException {
        TDMLocalTDomain tDMLocalTDomain;
        String string = this.currSection;
        this.currSection = localDomainSection;
        String string2 = this.getEAVal(element, "AccessPoint");
        try {
            tDMLocalTDomain = new TDMLocalTDomain(string2);
            if (this.accessMap.put(string2, tDMLocalTDomain) != null) {
                System.out.println("ERROR: Duplicated AccessPoint " + string2 + " found in Local TDomain definition!");
                this.currSection = string;
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create TDMLocalTDomain " + string2 + ", reason(" + exception.toString() + ")!");
            this.currSection = string;
            return false;
        }
        tDMLocalTDomain.setWlsClusterName(this.getSubElemText(element, "WlsClusterName", true));
        tDMLocalTDomain.setAccessPointId(this.getSubElemText(element, "AccessPointId", true));
        tDMLocalTDomain.setNWAddr(this.getSubElemText(element, "NWAddr", true));
        tDMLocalTDomain.setType(this.getSubElemText(element, "Type", false));
        tDMLocalTDomain.setSecurity(this.getSubElemText(element, "Security", false));
        tDMLocalTDomain.setConnectionPolicy(this.getSubElemText(element, "ConnectionPolicy", false));
        tDMLocalTDomain.setInteroperate(this.getSubElemText(element, "Interoperate", false));
        String string3 = this.getSubElemText(element, "RetryInterval", false);
        string3 = this.getSubElemText(element, "RetryInterval", false);
        if (string3 != null) {
            tDMLocalTDomain.setRetryInterval(Long.parseLong(string3, 10));
        }
        if ((string3 = this.getSubElemText(element, "MaxRetries", false)) != null) {
            tDMLocalTDomain.setMaxRetries(Long.parseLong(string3, 10));
        }
        if ((string3 = this.getSubElemText(element, "BlockTime", false)) != null) {
            tDMLocalTDomain.setBlockTime(Long.parseLong(string3) * 1000L);
        }
        if ((string3 = this.getSubElemText(element, "CmpLimit", false)) != null) {
            tDMLocalTDomain.setCmpLimit(Integer.parseInt(string3, 10));
        }
        if ((string3 = this.getSubElemText(element, "MinEncryptBits", false)) != null) {
            tDMLocalTDomain.setMinEncryptBits(Integer.parseInt(string3, 10));
        }
        if ((string3 = this.getSubElemText(element, "MaxEncryptBits", false)) != null) {
            tDMLocalTDomain.setMaxEncryptBits(Integer.parseInt(string3, 10));
        }
        this.ltd_list[n] = tDMLocalTDomain;
        this.currSection = string;
        return true;
    }

    private boolean setupTDMRemoteTD(Element element, int n) throws TPException {
        TDMRemoteTDomain tDMRemoteTDomain;
        String string = this.currSection;
        this.currSection = remoteDomainSection;
        String string2 = this.getEAVal(element, "AccessPoint");
        try {
            tDMRemoteTDomain = new TDMRemoteTDomain(string2, null, null);
            if (this.accessMap.put(string2, tDMRemoteTDomain) != null) {
                System.out.println("ERROR: Duplicated AccessPoint " + string2 + " found in Remote TDomain definition!");
                this.currSection = string;
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create TDMRemoteTDomain " + string2 + ", reason(" + exception.toString() + ")!");
            this.currSection = string;
            return false;
        }
        String string3 = this.getSubElemText(element, "LocalAccessPoint", true);
        int n2 = this.getLTDindex(string3);
        if (n2 == -1) {
            if (string3 != null) {
                System.out.println("ERROR: The local TDomain " + string3 + " for remote TDomain " + tDMRemoteTDomain.getAccessPoint() + " can not be found!");
            } else {
                System.out.println("ERROR: The local TDomain is not specified for remote TDomain " + tDMRemoteTDomain.getAccessPoint() + "!");
            }
            this.currSection = string;
            return false;
        }
        tDMRemoteTDomain.setLocalAccessPoint(string3);
        tDMRemoteTDomain.setAccessPointId(this.getSubElemText(element, "AccessPointId", true));
        tDMRemoteTDomain.setNWAddr(this.getSubElemText(element, "NWAddr", true));
        tDMRemoteTDomain.setType(this.getSubElemText(element, "Type", false));
        tDMRemoteTDomain.setAclPolicy(this.getSubElemText(element, "AclPolicy", false));
        tDMRemoteTDomain.setCredentialPolicy(this.getSubElemText(element, "CredentialPolicy", false));
        tDMRemoteTDomain.setTpUsrFile(this.getSubElemText(element, "TpUsrFile", false));
        String string4 = this.getSubElemText(element, "CmpLimit", false);
        if (string4 != null) {
            tDMRemoteTDomain.setCmpLimit(Integer.parseInt(string4, 10));
        }
        if ((string4 = this.getSubElemText(element, "MinEncryptBits", false)) != null) {
            tDMRemoteTDomain.setMinEncryptBits(Integer.parseInt(string4, 10));
        }
        if ((string4 = this.getSubElemText(element, "MaxEncryptBits", false)) != null) {
            tDMRemoteTDomain.setMaxEncryptBits(Integer.parseInt(string4, 10));
        }
        if ((string4 = this.getSubElemText(element, "ConnectionPolicy", false)) == null || string4.equals("LOCAL")) {
            if (string4 == null) {
                tDMRemoteTDomain.setConnPolicyConfigState(2);
            } else {
                tDMRemoteTDomain.setConnPolicyConfigState(3);
            }
            string4 = this.ltd_list[n2].getConnectionPolicy();
        } else {
            tDMRemoteTDomain.setConnPolicyConfigState(1);
        }
        tDMRemoteTDomain.setConnectionPolicy(string4);
        string4 = this.getSubElemText(element, "RetryInterval", false);
        if (string4 != null) {
            tDMRemoteTDomain.setRetryInterval(Long.parseLong(string4, 10));
        } else {
            tDMRemoteTDomain.setRetryInterval(this.ltd_list[n2].getRetryInterval());
        }
        string4 = this.getSubElemText(element, "MaxRetries", false);
        if (string4 != null) {
            tDMRemoteTDomain.setMaxRetries(Long.parseLong(string4, 10));
        } else {
            tDMRemoteTDomain.setMaxRetries(this.ltd_list[n2].getMaxRetries());
        }
        this.rtd_list[n] = tDMRemoteTDomain;
        this.currSection = string;
        return true;
    }

    private boolean setupTDMExport(Element element) {
        TDMExport tDMExport;
        String string = this.currSection;
        this.currSection = exportSection;
        String string2 = this.getEAVal(element, "LocalAccessPoint");
        int n = this.getLTDindex(string2);
        if (n == -1) {
            if (string2 != null) {
                System.out.println("ERROR: The Local TDomain " + string2 + " for exported service " + this.getEAVal(element, "ResourceName") + " can not be found!");
            } else {
                System.out.println("ERROR: The Local TDomain is not specified for exported service " + this.getEAVal(element, "ResourceName") + "!");
            }
            this.currSection = string;
            return false;
        }
        TDMLocalTDomain tDMLocalTDomain = this.ltd_list[n];
        try {
            tDMExport = new TDMExport(this.getEAVal(element, "ResourceName"), tDMLocalTDomain);
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create TDMExport for exported service " + this.getEAVal(element, "ResourceName"));
            this.currSection = string;
            return false;
        }
        tDMExport.setRemoteName(this.getSubElemText(element, "RemoteName", false));
        tDMExport.setEJBName(this.getSubElemText(element, "EJBName", false));
        this.currSection = string;
        return true;
    }

    private boolean setupTDMImport(Element element) throws TPException {
        Object object;
        TDMRemote[] tDMRemoteArray;
        String string = this.currSection;
        this.currSection = importSection;
        String string2 = this.getEAVal(element, "LocalAccessPoint");
        int n = this.getLTDindex(string2);
        if (n == -1) {
            if (string2 != null) {
                System.out.println("ERROR: The local TDomain " + string2 + " for imported service " + this.getEAVal(element, "ResourceName") + " can not be found!");
            } else {
                System.out.println("ERROR: The local TDomain is not specified for imported service " + this.getEAVal(element, "ResourceName") + "!");
            }
            this.currSection = string;
            return false;
        }
        TDMLocalTDomain tDMLocalTDomain = this.ltd_list[n];
        String string3 = this.getEAVal(element, "RemoteAccessPointList");
        if (string3.indexOf(44) == -1) {
            int n2 = this.getRTDindex(string3);
            if (n2 == -1) {
                System.out.println("ERROR: The remote TDomain list " + string3 + " is not defined for imported service " + this.getEAVal(element, "ResourceName") + "!");
                this.currSection = string;
                return false;
            }
            TDMRemoteTDomain tDMRemoteTDomain = this.rtd_list[n2];
            tDMRemoteTDomain.setLocalAccessPoint(string2);
            tDMRemoteArray = new TDMRemoteTDomain[]{tDMRemoteTDomain};
        } else {
            object = new StringTokenizer(string3, ",");
            tDMRemoteArray = new TDMRemoteTDomain[((StringTokenizer)object).countTokens()];
            int n3 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                int n4 = this.getRTDindex(string4);
                if (n4 == -1) {
                    System.out.println("ERROR: The remote TDomain " + string4 + " is not defined for imported service " + this.getEAVal(element, "ResourceName") + "!");
                    this.currSection = string;
                    return false;
                }
                TDMRemoteTDomain tDMRemoteTDomain = this.rtd_list[n4];
                tDMRemoteTDomain.setLocalAccessPoint(string2);
                tDMRemoteArray[n3] = tDMRemoteTDomain;
                ++n3;
            }
        }
        try {
            object = new TDMImport(this.getEAVal(element, "ResourceName"), tDMLocalTDomain, tDMRemoteArray);
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not create TDMImport for imported service " + this.getEAVal(element, "ResourceName"));
            return false;
        }
        ((TDMImport)((Object)object)).setRemoteName(this.getSubElemText(element, "RemoteName", false));
        String string5 = this.getSubElemText(element, "TranTime", false);
        if (string5 != null) {
            ((TDMImport)((Object)object)).setTranTime(Integer.parseInt(string5, 10));
        }
        this.currSection = string;
        return true;
    }

    private boolean setupTDMPasswd(Element element, int n) {
        TDMPasswd tDMPasswd;
        String string = this.currSection;
        this.currSection = passwdSection;
        String string2 = this.getEAVal(element, "LocalAccessPoint");
        int n2 = this.getLTDindex(string2);
        if (n2 == -1) {
            if (string2 != null) {
                System.out.println("ERROR: The local TDomain " + string2 + " for password " + this.getEAVal(element, "LocalAccessPoint") + " can not be found!");
            } else {
                System.out.println("ERROR: The local TDomain is not specified for password ");
            }
            this.currSection = string;
            return false;
        }
        TDMLocalTDomain tDMLocalTDomain = this.ltd_list[n2];
        String string3 = this.getEAVal(element, "RemoteAccessPoint");
        int n3 = this.getRTDindex(string3);
        if (n3 == -1) {
            if (string3 != null) {
                System.out.println("ERROR: Can not continue processing the TDMPassword object because the RemoteDomain " + string3 + " is not valid!");
            } else {
                System.out.println("ERROR: Can not continue processing the TDMPassword object because the RemoteDomain  is not specified!");
            }
            this.currSection = string;
            return false;
        }
        TDMRemoteTDomain tDMRemoteTDomain = this.rtd_list[n3];
        try {
            tDMPasswd = new TDMPasswd(string2, string3);
        }
        catch (Exception exception) {
            System.out.println("ERROR: Could not construct TDMPasswd object for local domain " + string2 + " and remote domain " + string3 + " (" + exception.toString() + ")!");
            this.currSection = string;
            return false;
        }
        tDMPasswd.setLocalPasswordIV(this.getSubEAVal(element, "LocalPassword", "IV"));
        tDMPasswd.setLocalPassword(this.getSubElemText(element, "LocalPassword", true));
        tDMPasswd.setRemotePasswordIV(this.getSubEAVal(element, "RemotePassword", "IV"));
        tDMPasswd.setRemotePassword(this.getSubElemText(element, "RemotePassword", true));
        this.pwd_list[n] = tDMPasswd;
        this.currSection = string;
        return true;
    }

    private boolean setupTDMResources(Element element) {
        String string = this.currSection;
        this.currSection = resourceSection;
        String string2 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2;
            Element element2;
            String string3;
            Node node3;
            if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
            Element element3 = (Element)node;
            String string4 = element3.getTagName();
            if (string4.equals("FieldTables")) {
                int n = 0;
                int n2 = 0;
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string3 = (element2 = (Element)node3).getTagName()).equals("FldTblClass")) continue;
                    string2 = this.getEAVal(element2, "Type");
                    if (string2 == null) {
                        System.out.println("ERROR: Type for the Field Table is not  specified!");
                        this.currSection = string;
                        return false;
                    }
                    if (string2.equals("fml32")) {
                        ++n2;
                        continue;
                    }
                    ++n;
                }
                if (n != 0) {
                    this.myFldTbls16 = new FldTbl[n];
                }
                if (n2 != 0) {
                    this.myFldTbls32 = new FldTbl[n2];
                }
                int n3 = 0;
                int n4 = 0;
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string3 = (element2 = (Element)node3).getTagName()).equals("FldTblClass")) continue;
                    node2 = element2.getFirstChild();
                    if (node2 == null) {
                        System.out.println("ERROR: Can not get TNODE!");
                        this.currSection = string;
                        return false;
                    }
                    String string5 = node2.getNodeValue();
                    if (string5 == null) {
                        System.out.println("ERROR: Can not get TNODE value!");
                        this.currSection = string;
                        return false;
                    }
                    try {
                        Class<?> clazz = Class.forName(string5.trim());
                        string2 = this.getEAVal(element2, "Type");
                        if (string2.equals("fml32")) {
                            this.myFldTbls32[n4] = (FldTbl)clazz.newInstance();
                            ++n4;
                            continue;
                        }
                        this.myFldTbls16[n3] = (FldTbl)clazz.newInstance();
                        ++n3;
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: Can not create TDMResources object, reason(" + exception.toString() + ")!");
                        this.currSection = string;
                        return false;
                    }
                }
                continue;
            }
            if (string4.equals("ViewTables")) {
                String string6 = null;
                String string7 = null;
                ViewHelper viewHelper = new ViewHelper();
                ViewHelper viewHelper2 = viewHelper.getInstance();
                for (node3 = element3.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !(node3 instanceof Element) || !(string3 = (element2 = (Element)node3).getTagName()).equals("ViewTblClass")) continue;
                    node2 = element2.getFirstChild();
                    if (node2 == null) {
                        System.out.println("ERROR: Can not get ViewTbl Text NODE!");
                        this.currSection = string;
                        return false;
                    }
                    string6 = node2.getNodeValue();
                    if (string6 == null) {
                        System.out.println("ERROR: Can not get ViewTbl NODE value!");
                        this.currSection = string;
                        return false;
                    }
                    try {
                        string2 = this.getEAVal(element2, "Type");
                        if (!string2.equals("view32") && !string2.equals("view16")) {
                            System.out.println("WARNING: Unknown Type label for ViewTblClass: " + string2);
                        }
                        string7 = string6.substring(string6.lastIndexOf(46) + 1);
                        viewHelper2.setViewClass(string7, string6.trim());
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: Resources " + string2 + " Info " + ", reason(" + exception.toString() + ")!");
                        this.currSection = string;
                        return false;
                    }
                }
                continue;
            }
            if (!string4.equals("AppPassword")) continue;
            this.myAppPwIV = this.getEAVal(element3, "IV");
            node2 = element3.getFirstChild();
            if (node2 == null) {
                System.out.println("ERROR: No TNODE for AppPassword was found!");
                this.currSection = string;
                return false;
            }
            String string8 = node2.getNodeValue();
            if (string8 == null) {
                System.out.println("ERROR: Failed to get AppPassword text!");
                this.currSection = string;
                return false;
            }
            this.myAppPwPWD = string8.trim();
        }
        this.currSection = string;
        return true;
    }

    private int getLTDindex(String string) {
        for (int i = 0; i < this.ltdcnt; ++i) {
            String string2 = this.ltd_list[i].getAccessPoint();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int getRTDindex(String string) {
        for (int i = 0; i < this.rtdcnt; ++i) {
            String string2 = this.rtd_list[i].getAccessPoint();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private String getEAVal(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2 == null) {
            System.out.println("ERROR: The element " + element.getTagName() + " does not have an attribute " + string + " defined!");
            return null;
        }
        return string2;
    }

    private String getSubElemText(Element element, String string, boolean bl) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() != 1) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " has more than one sub element of the tag name " + string + "!");
            }
            return null;
        }
        Node node = nodeList.item(0);
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " has zero sub element of the tag name " + string + "!");
            }
            return null;
        }
        String string2 = node2.getNodeValue();
        if (string2 == null) {
            if (bl) {
                System.out.println("ERROR: The parent element " + element.getTagName() + " has the sub element of the tag name " + string + " without value!");
            }
            return null;
        }
        return string2.trim();
    }

    private String getSubEAVal(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() != 1) {
            System.out.println("ERROR: The parent element " + element.getTagName() + " has more than one sub element of the tag name " + string + "!");
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        String string3 = element2.getAttribute(string2);
        if (string3 == null) {
            System.out.println("ERROR: The element " + element.getTagName() + " does not have an attribute " + string + " defined!");
            return null;
        }
        return string3;
    }

    private boolean crossChecking() {
        int n;
        HashMap<String, WTCMBeanObject> hashMap = new HashMap<String, WTCMBeanObject>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (n = 0; n < this.rtd_list.length; ++n) {
            TDMRemoteTDomain tDMRemoteTDomain = this.rtd_list[n];
            try {
                tDMRemoteTDomain.checkConfigIntegrity();
            }
            catch (TPException tPException) {
                return false;
            }
            hashMap.put(tDMRemoteTDomain.getAccessPointId(), tDMRemoteTDomain);
            RDomainListEntry rDomainListEntry = new RDomainListEntry(tDMRemoteTDomain);
            RDomainListEntry rDomainListEntry2 = (RDomainListEntry)hashMap2.put(tDMRemoteTDomain.getAccessPointId(), rDomainListEntry);
            if (rDomainListEntry2 == null) continue;
            rDomainListEntry.setNext(rDomainListEntry2);
        }
        for (n = 0; n < this.ltd_list.length; ++n) {
            TDMLocalTDomain tDMLocalTDomain = this.ltd_list[n];
            try {
                tDMLocalTDomain.checkConfigIntegrity();
            }
            catch (TPException tPException) {
                return false;
            }
            if (hashMap.put(tDMLocalTDomain.getAccessPointId(), tDMLocalTDomain) == null) continue;
            System.out.println("ERROR: Duplicated local domain id " + tDMLocalTDomain.getAccessPointId() + " found!");
            return false;
        }
        for (RDomainListEntry rDomainListEntry2 : hashMap2.values()) {
            HashMap<String, TDMLocal> hashMap3 = new HashMap<String, TDMLocal>();
            do {
                TDMRemoteTDomain tDMRemoteTDomain;
                TDMLocal tDMLocal;
                if (hashMap3.put((tDMLocal = (tDMRemoteTDomain = rDomainListEntry2.getRDom()).getLocalAccessPointObject()).getAccessPointId(), tDMLocal) == null) continue;
                System.out.println("ERROR: There are two remote domain " + tDMRemoteTDomain.getAccessPointId() + " with same local domain " + tDMLocal.getAccessPointId());
                return false;
            } while ((rDomainListEntry2 = rDomainListEntry2.getNext()) != null);
        }
        return true;
    }
}

