/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import com.bea.core.jatmi.common.ntrace;
import weblogic.wtc.jatmi.CallDescriptor;
import weblogic.wtc.jatmi.Conversation;
import weblogic.wtc.jatmi.ConversationReply;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.ReqMsg;
import weblogic.wtc.jatmi.SessionAcallDescriptor;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TdomTcb;
import weblogic.wtc.jatmi.TuxedoReply;
import weblogic.wtc.jatmi.TypedBuffer;
import weblogic.wtc.jatmi.UserTcb;
import weblogic.wtc.jatmi.dsession;
import weblogic.wtc.jatmi.rdsession;
import weblogic.wtc.jatmi.tcb;
import weblogic.wtc.jatmi.tcm;
import weblogic.wtc.jatmi.tfmh;

public class DomainOutboundConversation
implements Conversation {
    private boolean isDisconnected = false;
    private dsession myDomainSession;
    private int mySendSequenceNumber = 1;
    private int myRecvSequenceNumber = 1;
    private int myConversationIdentifier;
    private boolean mySendOnly;
    private ConversationReply myRplyObj;
    private SessionAcallDescriptor myCallDescriptor;
    private boolean myInTransaction;
    private rdsession myRecieveSession;

    public DomainOutboundConversation(dsession dsession2, ConversationReply conversationReply, int n, boolean bl, SessionAcallDescriptor sessionAcallDescriptor, boolean bl2) {
        this.myDomainSession = dsession2;
        this.myRplyObj = conversationReply;
        this.myConversationIdentifier = n;
        this.mySendOnly = bl;
        this.myCallDescriptor = sessionAcallDescriptor;
        this.myInTransaction = bl2;
        this.myRecieveSession = dsession2.get_rcv_place();
    }

    private void internalDisconnect() {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/DomainOutboundConversation/internalDisconnect/");
        }
        if (this.isDisconnected) {
            if (bl) {
                ntrace.doTrace((String)"]/DomainOutboundConversation/internalDisconnect/10");
            }
            return;
        }
        this.myRecieveSession.remove_rplyObj(this.myCallDescriptor);
        this.myDomainSession = null;
        this.myRplyObj = null;
        this.myCallDescriptor = null;
        this.myRecieveSession = null;
        this.isDisconnected = true;
        if (bl) {
            ntrace.doTrace((String)"]/DomainOutboundConversation/internalDisconnect/20");
        }
    }

    public synchronized void tpsend(TypedBuffer typedBuffer, int n) throws TPException {
        tfmh tfmh2;
        boolean bl;
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        if (bl2) {
            ntrace.doTrace((String)("[/DomainOutboundConversation/tpsend/" + typedBuffer + "/" + n));
        }
        if (!this.mySendOnly) {
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tpsend/10/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Attempting to send but direction is receive");
        }
        if (this.myDomainSession.getIsTerminated()) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tpsend/20/TPESYSTEM");
            }
            throw new TPException(12, "WARN: The domain link was removed underneath the conversation");
        }
        if ((n & 0xFFFFEFDE) != 0) {
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tpsend/30/TPEINVAL");
            }
            throw new TPException(4);
        }
        boolean bl3 = bl = ((n &= 0xFFFFFFDE) & 0x1000) != 0;
        if (typedBuffer == null) {
            tfmh2 = new tfmh(1);
        } else {
            tcm tcm2 = new tcm(0, (tcb)new UserTcb(typedBuffer));
            tfmh2 = new tfmh(typedBuffer.getHintIndex(), tcm2, 1);
        }
        try {
            this.myDomainSession._tpsend_internal(tfmh2, this.mySendSequenceNumber, this.myConversationIdentifier, true, bl, false);
        }
        catch (TPException tPException) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)("*]/DomainOutboundConversation/tpsend/40/" + (Object)((Object)tPException)));
            }
            throw tPException;
        }
        ++this.mySendSequenceNumber;
        if (bl) {
            this.mySendOnly = false;
        }
        if (bl2) {
            ntrace.doTrace((String)"]/DomainOutboundConversation/tpsend/50/");
        }
    }

    public synchronized Reply tprecv(int n) throws TPException, TPReplyException {
        boolean bl;
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        if (bl2) {
            ntrace.doTrace((String)("[/DomainOutboundConversation/tprecv/" + n));
        }
        TuxedoReply tuxedoReply = null;
        if (this.mySendOnly) {
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/10/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Attempting to receive but direction is send");
        }
        if (this.myDomainSession.getIsTerminated()) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/20/TPESYSTEM");
            }
            throw new TPException(12, "WARN: The domain link was removed underneath the conversation");
        }
        if ((n & 0xFFFFFFDE) != 0) {
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/30/TPEINVAL");
            }
            throw new TPException(4);
        }
        boolean bl3 = bl = (n & 1) == 0;
        if (!this.myInTransaction && (n & 0x20) == 0 && !this.myRecieveSession.addRplyObjTimeout(this.myCallDescriptor, 0)) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/40/TPESYSTEM");
            }
            throw new TPException(12, "ERROR: Unable to set a timeout for tprecv");
        }
        ReqMsg reqMsg = this.myRplyObj.get_reply(bl);
        if (reqMsg == null) {
            if (bl) {
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/50/TPESYSTEM");
                }
                throw new TPException(12, "ERROR: Conversation in invalid state");
            }
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/60/TPEBLOCK");
            }
            throw new TPException(3);
        }
        tfmh tfmh2 = reqMsg.getReply();
        if (tfmh2 == null) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/70/TPESYSTEM");
            }
            throw new TPException(12, "ERROR: Invalid tprecv message");
        }
        TdomTcb tdomTcb = (TdomTcb)tfmh2.tdom.body;
        int n2 = tdomTcb.get_diagnostic();
        int n3 = tdomTcb.get_flag();
        int n4 = tdomTcb.getTpurcode();
        int n5 = tdomTcb.get_errdetail();
        int n6 = tdomTcb.get_opcode();
        int n7 = tdomTcb.get_tpevent();
        int n8 = tdomTcb.get_seqnum();
        if ((n3 & 0x1000) != 0 && n7 == 0) {
            n7 = 32;
        }
        TypedBuffer typedBuffer = tfmh2.user == null ? null : ((UserTcb)tfmh2.user.body).user_data;
        if (n8 != this.myRecvSequenceNumber) {
            TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, 1, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/80/" + (Object)((Object)tPReplyException) + "/" + n8 + "/" + this.myRecvSequenceNumber));
            }
            throw tPReplyException;
        }
        ++this.myRecvSequenceNumber;
        if (bl2) {
            ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/85/" + n2 + "/" + n3 + "/" + n4 + "/" + n5 + "/" + n6 + "/" + n7 + "/" + n8));
        }
        switch (n6) {
            case 5: {
                if (n2 == 22) {
                    switch (n7) {
                        case 32: {
                            this.mySendOnly = true;
                            TPReplyException tPReplyException = new TPReplyException(n2, 0, n4, n5, 0, n7, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                            if (bl2) {
                                ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/90/" + (Object)((Object)tPReplyException)));
                            }
                            throw tPReplyException;
                        }
                    }
                    this.internalDisconnect();
                    if (bl2) {
                        ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/100/TPESYSTEM");
                    }
                    throw new TPException(12, "ERROR: Invalid tpevent detected " + n7);
                }
                if (n2 != 0) {
                    if (bl2) {
                        ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/110/TPESYSTEM/invalid diagnostic:" + n2));
                    }
                    throw new TPException(12, "ERROR: Invalid diagnostic:" + n2);
                }
                tuxedoReply = new TuxedoReply(typedBuffer, 0, (CallDescriptor)this.myCallDescriptor);
                break;
            }
            case 2: {
                TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, 8, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/120/" + (Object)((Object)tPReplyException)));
                }
                throw tPReplyException;
            }
            case 6: {
                TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, 1, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/130/" + (Object)((Object)tPReplyException)));
                }
                throw tPReplyException;
            }
            case 3: {
                this.internalDisconnect();
                if (n2 == 22) {
                    switch (n7) {
                        case 1: 
                        case 2: 
                        case 4: {
                            TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, n7, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                            if (bl2) {
                                ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/140/" + (Object)((Object)tPReplyException)));
                            }
                            throw tPReplyException;
                        }
                    }
                    if (bl2) {
                        ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/145/TPESYSTEM");
                    }
                    throw new TPException(12, "ERROR: Invalid tpevent detected " + n7);
                }
                if (bl2) {
                    ntrace.doTrace((String)"*]/DomainOutboundConversation/tprecv/146/TPESYSTEM");
                }
                throw new TPException(12, "ERROR: Unexpected exception:" + n2);
            }
            default: {
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/DomainOutboundConversation/tprecv/150/TPESYSTEM" + n6));
                }
                throw new TPException(12, "ERROR: Got an invalid conversational response");
            }
        }
        if (bl2) {
            ntrace.doTrace((String)("]/DomainOutboundConversation/tprecv/160/" + tuxedoReply));
        }
        return tuxedoReply;
    }

    public synchronized void tpdiscon() throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/DomainOutboundConversation/tpdiscon/");
        }
        if (this.myDomainSession == null) {
            if (bl) {
                ntrace.doTrace((String)"*]/DomainOutboundConversation/tpdiscon/10/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Attempting tpdiscon in an improper context");
        }
        tfmh tfmh2 = new tfmh(1);
        try {
            this.myDomainSession._tpsend_internal(tfmh2, this.mySendSequenceNumber, this.myConversationIdentifier, true, false, true);
        }
        catch (TPException tPException) {
            if (bl) {
                ntrace.doTrace((String)("/DomainOutboundConversation/tpdiscon/internal send failure: " + (Object)((Object)tPException)));
            }
            throw tPException;
        }
        ++this.mySendSequenceNumber;
        this.internalDisconnect();
        if (bl) {
            ntrace.doTrace((String)"]/DomainOutboundConversation/tpdiscon/20");
        }
    }

    public String toString() {
        return new String(this.isDisconnected + ":" + this.mySendSequenceNumber + ":" + this.myConversationIdentifier + ":" + this.mySendOnly + ":" + this.myCallDescriptor + ":" + this.myInTransaction);
    }
}

