/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import com.bea.core.jatmi.common.ntrace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import weblogic.utils.collections.NumericHashtable;
import weblogic.utils.collections.NumericValueHashtable;

public final class HTableParser {
    private static HTableParser _instance;
    private static final int FLD_SHORT = 0;
    private static final int FLD_LONG = 1;
    private static final int FLD_CHAR = 2;
    private static final int FLD_FLOAT = 3;
    private static final int FLD_DOUBLE = 4;
    private static final int FLD_STRING = 5;
    private static final int FLD_CARRAY = 6;
    private static final int FLD_INT = 7;
    private static final int FLD_DECIMAL = 8;
    private static final int FLD_PTR = 9;
    private static final int FLD_FML32 = 10;
    private static final int FLD_VIEW32 = 11;
    private static final int FNMASK32 = 0x1FFFFFF;
    private static final int FTMASK32 = 63;
    private static final int FTSHIFT32 = 25;
    private static final int FNMASK = 8191;
    private static final int FTMASK = 7;
    private static final int FTSHIFT = 13;
    private NumericValueHashtable nametofieldHashTable;
    private NumericHashtable fieldtonameHashTable;
    private Vector fieldNameSet;

    public static HTableParser getInstance(String string, boolean bl) {
        return HTableParser.getInstance(string, bl, 101, 0.75f);
    }

    public static synchronized HTableParser getInstance(String string, boolean bl, int n, float f) {
        if (_instance == null) {
            _instance = new HTableParser(string, bl, n, f);
        }
        return _instance;
    }

    public HTableParser(String string, boolean bl) {
        this(string, bl, 101, 0.75f);
    }

    public HTableParser(String string, boolean bl, int n, float f) {
        BufferedReader bufferedReader = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        if (bl2) {
            ntrace.doTrace((String)("[/HTableParser/Startup/Initial Capacity = " + n + "/Load Factor = " + f));
        }
        File file = new File(string);
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ClassLoader classLoader;
            InputStream inputStream;
            if (bl2) {
                ntrace.doTrace((String)("]/HTableParser/Startup/Could not find file " + string + "/20"));
            }
            if ((inputStream = (classLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(string)) == null) {
                if (bl2) {
                    ntrace.doTrace((String)("]/HTableParser/Startup/Could not find resource " + string + "/25"));
                }
                return;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        this.nametofieldHashTable = new NumericValueHashtable(n, f);
        this.fieldtonameHashTable = new NumericHashtable(n, f);
        this.fieldNameSet = new Vector();
        while (true) {
            String string2;
            int n7;
            int n8;
            String string3;
            try {
                string3 = bufferedReader.readLine();
                if (string3 == null) break;
                string3 = string3.trim();
                ++n3;
                n8 = 0;
            }
            catch (IOException iOException) {
                System.out.println("Finished! " + iOException);
                if (!bl2) break;
                ntrace.doTrace((String)"]/HTableParser/Startup/Finished!/30");
                break;
            }
            int n9 = string3.length();
            if (n9 == 0 || string3.startsWith("#") || string3.startsWith("$")) continue;
            if (string3.startsWith("*base")) {
                if (!Character.isWhitespace(string3.charAt(5))) {
                    if (bl2) {
                        ntrace.doTrace((String)"]/HTableParser/Startup/*base must be followed by white space/40");
                    }
                    return;
                }
                n8 = 6;
                while (Character.isWhitespace(string3.charAt(n8))) {
                    ++n8;
                }
                if (!Character.isDigit(string3.charAt(n8))) {
                    if (bl2) {
                        ntrace.doTrace((String)"]/HTableParser/Startup/*base must be followed by a numeric value/50");
                    }
                    return;
                }
                n7 = n8++;
                while (n8 < string3.length() && Character.isDigit(string3.charAt(n8))) {
                    ++n8;
                }
                n2 = new Integer(string3.substring(n7, n8));
                continue;
            }
            while (!Character.isWhitespace(string3.charAt(n8))) {
                ++n8;
            }
            String string4 = string3.substring(0, n8);
            while (Character.isWhitespace(string3.charAt(n8))) {
                ++n8;
            }
            if (!Character.isDigit(string3.charAt(n8))) {
                if (bl2) {
                    ntrace.doTrace((String)("]/HTableParser/Startup/" + string4 + " must be followed by a numeric value/60"));
                }
                return;
            }
            n7 = n8++;
            while (Character.isDigit(string3.charAt(n8))) {
                ++n8;
            }
            n4 = new Integer(string3.substring(n7, n8)) + n2;
            if (bl) {
                if (n4 > 0x1FFFFFF) {
                    if (bl2) {
                        ntrace.doTrace((String)("]/HTableParser/Startup/" + n4 + " must be less than or equal to " + 0x1FFFFFF + "/70"));
                    }
                    return;
                }
            } else if (n4 > 8191) {
                if (bl2) {
                    ntrace.doTrace((String)("]/HTableParser/Startup/" + n4 + " must be less than or equal to " + 8191 + "/80"));
                }
                return;
            }
            while (Character.isWhitespace(string3.charAt(n8))) {
                ++n8;
            }
            n7 = n8;
            while (!Character.isWhitespace(string3.charAt(n8)) && string3.charAt(n8) != '\n') {
                if (++n8 < n9) continue;
                n8 = n9;
                break;
            }
            if ((string2 = string3.substring(n7, n8)).equals("char")) {
                n6 = 2;
            } else if (string2.equals("string")) {
                n6 = 5;
            } else if (string2.equals("short")) {
                n6 = 0;
            } else if (string2.equals("long")) {
                n6 = 1;
            } else if (string2.equals("float")) {
                n6 = 3;
            } else if (string2.equals("double")) {
                n6 = 4;
            } else if (string2.equals("carray")) {
                n6 = 6;
            } else if (bl && string2.equals("ptr")) {
                n6 = 9;
            } else if (bl && string2.equals("fml32")) {
                n6 = 10;
            } else if (bl && string2.equals("view32")) {
                n6 = 11;
            } else {
                if (bl2) {
                    ntrace.doTrace((String)("]/HTableParser/Startup/" + string2 + " is invalid/90"));
                }
                return;
            }
            n5 = bl ? (n6 & 0x3F) << 25 | n4 & 0x1FFFFFF : (n6 & 7) << 13 | n4 & 0x1FFF;
            this.fieldtonameHashTable.put((long)n5, (Object)string4);
            this.nametofieldHashTable.put((Object)string4, (long)n5);
            this.fieldNameSet.add(string4);
        }
        if (bl2) {
            ntrace.doTrace((String)"]/HTableParser/Startup/Loaded/100");
        }
    }

    public NumericValueHashtable getnametofieldHashTable() {
        return this.nametofieldHashTable;
    }

    public NumericHashtable getfieldtonameHashTable() {
        return this.fieldtonameHashTable;
    }

    public Vector getfieldNameSet() {
        return this.fieldNameSet;
    }
}

