/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import com.bea.core.jatmi.common.ntrace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import weblogic.wtc.jatmi.CallDescriptor;
import weblogic.wtc.jatmi.Conversation;
import weblogic.wtc.jatmi.ConversationReply;
import weblogic.wtc.jatmi.DomainRegistry;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.ReqMsg;
import weblogic.wtc.jatmi.SessionAcallDescriptor;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TdomTcb;
import weblogic.wtc.jatmi.TuxedoReply;
import weblogic.wtc.jatmi.TypedBuffer;
import weblogic.wtc.jatmi.TypedBufferFactory;
import weblogic.wtc.jatmi.UserTcb;
import weblogic.wtc.jatmi.dsession;
import weblogic.wtc.jatmi.gwatmi;
import weblogic.wtc.jatmi.rdsession;
import weblogic.wtc.jatmi.tcb;
import weblogic.wtc.jatmi.tcm;
import weblogic.wtc.jatmi.tfmh;

public class TPServiceInformation
extends TuxedoReply
implements Conversation {
    private static final long serialVersionUID = -2256092221608261884L;
    private String service_name;
    private TypedBuffer service_data;
    private int service_flags;
    private String service_data_key;
    private int mySessionIdentifier = -1;
    private int myConversationIdentifier;
    private transient boolean isConversationInitialized = false;
    private transient boolean conversationInitializationStatus;
    private transient boolean isDisconnected = false;
    private transient dsession myDomainSession;
    private transient int mySendSequenceNumber;
    private transient int myRecvSequenceNumber;
    private transient boolean mySendOnly;
    private transient ConversationReply myRplyObj;
    private transient SessionAcallDescriptor myCallDescriptor;
    private transient rdsession myRecieveSession;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = ntrace.isTraceEnabled((int)50000);
        if (bl) {
            ntrace.doTrace((String)"[/TPServiceInformation/writeObject/");
        }
        if (null == TypedBufferFactory.getBufferPool() || null == this.service_data) {
            this.service_data_key = null;
            objectOutputStream.defaultWriteObject();
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/writeObject/10/false");
            }
            return;
        }
        this.service_data_key = this.service_data.toString();
        TypedBufferFactory.getBufferPool().put(this.service_data_key, this.service_data);
        TypedBuffer typedBuffer = this.service_data;
        this.service_data = null;
        objectOutputStream.defaultWriteObject();
        this.service_data = typedBuffer;
        this.service_data_key = null;
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceInformation/writeObject/20/true");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = ntrace.isTraceEnabled((int)50000);
        if (bl) {
            ntrace.doTrace((String)"[/TPServiceInformation/readObject/");
        }
        this.service_data_key = null;
        objectInputStream.defaultReadObject();
        if (null == TypedBufferFactory.getBufferPool() || null == this.service_data_key) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/readObject/10/false");
            }
            return;
        }
        this.service_data = TypedBufferFactory.getBufferPool().get(this.service_data_key);
        this.service_data_key = null;
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceInformation/readObject/20/true");
        }
    }

    public TPServiceInformation() {
    }

    public TPServiceInformation(String string, TypedBuffer typedBuffer, int n, int n2, int n3) {
        this.service_name = string;
        this.service_data = typedBuffer;
        this.service_flags = n;
        this.mySessionIdentifier = n2;
        this.myConversationIdentifier = n3;
    }

    public String getServiceName() {
        return this.service_name;
    }

    public TypedBuffer getServiceData() {
        return this.service_data;
    }

    public int getServiceFlags() {
        return this.service_flags;
    }

    private void initializeConversation() {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TPServiceInformation/initializeConversation/");
        }
        if (this.isConversationInitialized) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/initializeConversation/10/false");
            }
            return;
        }
        this.conversationInitializationStatus = false;
        this.isConversationInitialized = true;
        gwatmi gwatmi2 = DomainRegistry.getDomainSession((int)this.mySessionIdentifier);
        if (gwatmi2 == null) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/initializeConversation/20/false");
            }
            return;
        }
        if (!(gwatmi2 instanceof dsession)) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/initializeConversation/30/false");
            }
            return;
        }
        this.myDomainSession = (dsession)gwatmi2;
        this.mySendOnly = (this.service_flags & 0x800) != 0;
        this.myCallDescriptor = new SessionAcallDescriptor(this.myConversationIdentifier, true);
        this.myRecieveSession = this.myDomainSession.get_rcv_place();
        if (this.myRecieveSession == null) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/initializeConversation/40/false");
            }
            return;
        }
        this.myRplyObj = this.myRecieveSession.getConversationReply(this.myConversationIdentifier);
        if (this.myRplyObj == null) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/initializeConversation/50/false");
            }
            return;
        }
        this.mySendSequenceNumber = 1;
        this.myRecvSequenceNumber = 1;
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceInformation/initializeConversation/60/true");
        }
        this.conversationInitializationStatus = true;
    }

    private void internalDisconnect() {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TPServiceInformation/internalDisconnect/");
        }
        if (this.isDisconnected) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceInformation/internalDisconnect/10");
            }
            return;
        }
        this.myRecieveSession.remove_rplyObj(this.myCallDescriptor);
        this.myDomainSession = null;
        this.myRplyObj = null;
        this.myCallDescriptor = null;
        this.myRecieveSession = null;
        this.isDisconnected = true;
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceInformation/internalDisconnect/20");
        }
    }

    public void tpsend(TypedBuffer typedBuffer, int n) throws TPException {
        tfmh tfmh2;
        boolean bl;
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        if (bl2) {
            ntrace.doTrace((String)("[/TPServiceInformation/tpsend/" + typedBuffer + "/" + n));
        }
        if ((this.service_flags & 0x400) == 0) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tpsend/10/TPEINVAL");
            }
            throw new TPException(4, "ERROR: This service is not conversational");
        }
        if (!this.isConversationInitialized) {
            this.initializeConversation();
        }
        if (!this.conversationInitializationStatus) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tpsend/20/TPEINVAL");
            }
            throw new TPException(12, "ERROR: Conversation initialization failed");
        }
        if (this.isDisconnected) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tpsend/25/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Conversation has been disconnected");
        }
        if (!this.mySendOnly) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tpsend/30/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Attempting to send but direction is receive");
        }
        if (this.myDomainSession.getIsTerminated()) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tpsend/40/TPESYSTEM");
            }
            throw new TPException(12, "WARN: The domain link was removed underneath the conversation");
        }
        if ((n & 0xFFFFEFDE) != 0) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tpsend/50/TPEINVAL");
            }
            throw new TPException(4);
        }
        boolean bl3 = bl = ((n &= 0xFFFFFFDE) & 0x1000) != 0;
        if (typedBuffer == null) {
            tfmh2 = new tfmh(1);
        } else {
            tcm tcm2 = new tcm(0, (tcb)new UserTcb(typedBuffer));
            tfmh2 = new tfmh(typedBuffer.getHintIndex(), tcm2, 1);
        }
        try {
            this.myDomainSession._tpsend_internal(tfmh2, this.mySendSequenceNumber, this.myConversationIdentifier, false, bl, false);
        }
        catch (TPException tPException) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)("*]/TPServiceInformation/tpsend/60/" + (Object)((Object)tPException)));
            }
            throw tPException;
        }
        ++this.mySendSequenceNumber;
        if (bl) {
            this.mySendOnly = false;
        }
        if (bl2) {
            ntrace.doTrace((String)"]/TPServiceInformation/tpsend/70/");
        }
    }

    public Reply tprecv(int n) throws TPException, TPReplyException {
        boolean bl;
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        if (bl2) {
            ntrace.doTrace((String)("[/TPServiceInformation/tprecv/" + n));
        }
        TuxedoReply tuxedoReply = null;
        if ((this.service_flags & 0x400) == 0) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/10/TPEINVAL");
            }
            throw new TPException(4, "ERROR: This service is not conversational");
        }
        if (!this.isConversationInitialized) {
            this.initializeConversation();
        }
        if (!this.conversationInitializationStatus) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/20/TPESYSTEM");
            }
            throw new TPException(12, "ERROR: Conversation initialization failed");
        }
        if (this.isDisconnected) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/25/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Conversation has been disconnected");
        }
        if (this.mySendOnly) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/30/TPEPROTO");
            }
            throw new TPException(9, "ERROR: Attempting to receive but direction is send");
        }
        if (this.myDomainSession.getIsTerminated()) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/40/TPESYSTEM");
            }
            throw new TPException(12, "WARN: The domain link was removed underneath the conversation");
        }
        if ((n & 0xFFFFFFDE) != 0) {
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/50/TPEINVAL");
            }
            throw new TPException(4);
        }
        boolean bl3 = bl = (n & 1) == 0;
        if ((n & 0x20) == 0 && !this.myRecieveSession.addRplyObjTimeout(this.myCallDescriptor, 0)) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/60/TPESYSTEM");
            }
            throw new TPException(12, "ERROR: Unable to set a timeout for tprecv");
        }
        ReqMsg reqMsg = this.myRplyObj.get_reply(bl);
        if (reqMsg == null) {
            if (bl) {
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/70/TPESYSTEM");
                }
                throw new TPException(12, "ERROR: Conversation in invalid state");
            }
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/80/TPEBLOCK");
            }
            throw new TPException(3);
        }
        tfmh tfmh2 = reqMsg.getReply();
        if (tfmh2 == null) {
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/90/TPESYSTEM");
            }
            throw new TPException(12, "ERROR: Invalid tprecv message");
        }
        TdomTcb tdomTcb = (TdomTcb)tfmh2.tdom.body;
        int n2 = tdomTcb.get_diagnostic();
        int n3 = tdomTcb.get_flag();
        int n4 = tdomTcb.getTpurcode();
        int n5 = tdomTcb.get_errdetail();
        int n6 = tdomTcb.get_opcode();
        int n7 = tdomTcb.get_tpevent();
        int n8 = tdomTcb.get_seqnum();
        if ((n3 & 0x1000) != 0 && n7 == 0) {
            n7 = 32;
        }
        TypedBuffer typedBuffer = tfmh2.user == null ? null : ((UserTcb)tfmh2.user.body).user_data;
        if (n8 != this.myRecvSequenceNumber) {
            TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, 1, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
            this.internalDisconnect();
            if (bl2) {
                ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/100/" + (Object)((Object)tPReplyException) + "/" + n8 + "/" + this.myRecvSequenceNumber));
            }
            throw tPReplyException;
        }
        ++this.myRecvSequenceNumber;
        switch (n6) {
            case 5: {
                if (n2 == 22) {
                    switch (n7) {
                        case 32: {
                            this.mySendOnly = true;
                            TPReplyException tPReplyException = new TPReplyException(n2, 0, n4, n5, 0, n7, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                            if (bl2) {
                                ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/110/" + (Object)((Object)tPReplyException)));
                            }
                            throw tPReplyException;
                        }
                    }
                    this.internalDisconnect();
                    if (bl2) {
                        ntrace.doTrace((String)"*]/TPServiceInformation/tprecv/120/TPESYSTEM");
                    }
                    throw new TPException(12, "ERROR: Invalid tpevent detected " + n7);
                }
                if (n2 != 0) {
                    if (bl2) {
                        ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/130/TPESYSTEM/invalid diagnostic:" + n2));
                    }
                    throw new TPException(12, "ERROR: Invalid diagnostic:" + n2);
                }
                tuxedoReply = new TuxedoReply(typedBuffer, 0, (CallDescriptor)this.myCallDescriptor);
                break;
            }
            case 2: {
                TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, 8, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/140/" + (Object)((Object)tPReplyException)));
                }
                throw tPReplyException;
            }
            case 6: {
                TPReplyException tPReplyException = new TPReplyException(22, 0, n4, n5, 0, 1, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor));
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/150/" + (Object)((Object)tPReplyException)));
                }
                throw tPReplyException;
            }
            case 3: {
                TPReplyException tPReplyException = n2 == 11 ? new TPReplyException(22, 0, n4, n5, 0, 4, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor)) : (n2 == 10 ? new TPReplyException(22, 0, n4, n5, 0, 2, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor)) : new TPReplyException(22, 0, n4, n5, 0, 1, (Reply)new TuxedoReply(typedBuffer, n4, (CallDescriptor)this.myCallDescriptor)));
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/160/" + (Object)((Object)tPReplyException)));
                }
                throw tPReplyException;
            }
            default: {
                this.internalDisconnect();
                if (bl2) {
                    ntrace.doTrace((String)("*]/TPServiceInformation/tprecv/170/TPESYSTEM" + n6));
                }
                throw new TPException(12, "ERROR: Got an invalid conversational response");
            }
        }
        if (bl2) {
            ntrace.doTrace((String)("]/TPServiceInformation/tprecv/180/" + tuxedoReply));
        }
        return tuxedoReply;
    }

    public void tpdiscon() throws TPException {
        boolean bl;
        block11: {
            bl = ntrace.isTraceEnabled((int)4);
            if (bl) {
                ntrace.doTrace((String)"[/TPServiceInformation/tpdiscon/");
            }
            tfmh tfmh2 = new tfmh(1);
            if ((this.service_flags & 0x400) == 0) {
                if (bl) {
                    ntrace.doTrace((String)"]/TPServiceInformation/tpdiscon/10/TPEINVAL");
                }
                throw new TPException(4, "ERROR: This service is not conversational");
            }
            if (!this.isConversationInitialized) {
                this.initializeConversation();
            }
            if (!this.conversationInitializationStatus) {
                if (bl) {
                    ntrace.doTrace((String)"]/TPServiceInformation/tpdiscon/20/TPESYSTEM");
                }
                throw new TPException(12, "ERROR: Conversation initialization failed");
            }
            if (this.isDisconnected) {
                if (bl) {
                    ntrace.doTrace((String)"*]/TPServiceInformation/tpdiscon/25/TPEPROTO");
                }
                throw new TPException(9, "ERROR: Conversation has been disconnected");
            }
            try {
                this.myDomainSession._tpsend_internal(tfmh2, this.mySendSequenceNumber, this.myConversationIdentifier, true, false, true);
            }
            catch (TPException tPException) {
                if (!bl) break block11;
                ntrace.doTrace((String)("/TPServiceInformation/tpdiscon/internal send failure: " + (Object)((Object)tPException)));
            }
        }
        ++this.mySendSequenceNumber;
        this.internalDisconnect();
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceInformation/tpdiscon/30");
        }
    }

    public String toString() {
        return new String(super.toString() + ":" + this.service_name + ":" + this.service_data + ":" + this.service_flags + ":" + this.mySessionIdentifier + ":" + this.myConversationIdentifier);
    }
}

