/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.intf.TCAuthenticatedUser;
import com.bea.core.jatmi.intf.TCTask;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import weblogic.wtc.jatmi.BetaFeatures;
import weblogic.wtc.jatmi.InvokeInfo;
import weblogic.wtc.jatmi.InvokeSvc;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TdomTcb;
import weblogic.wtc.jatmi.TypedBuffer;
import weblogic.wtc.jatmi.UserTcb;
import weblogic.wtc.jatmi.dreqid;
import weblogic.wtc.jatmi.gwatmi;
import weblogic.wtc.jatmi.tcb;
import weblogic.wtc.jatmi.tcm;
import weblogic.wtc.jatmi.tfmh;

public class TPServiceRequest
implements TCTask {
    private InvokeSvc how_to_do_them;
    private gwatmi mysession;
    private int protocol;
    private DataOutputStream output_stream;
    private tfmh myServiceRequest;
    String myLocalDomain;
    private BetaFeatures beta;
    TCAuthenticatedUser mySubject;
    private String myName;

    public TPServiceRequest(gwatmi gwatmi2, int n, String string, DataOutputStream dataOutputStream, InvokeSvc invokeSvc, tfmh tfmh2, BetaFeatures betaFeatures) throws TPException {
        if (gwatmi2 == null || dataOutputStream == null || invokeSvc == null || tfmh2 == null || string == null) {
            throw new TPException(4, "Invalid null parameter/" + gwatmi2 + "/" + dataOutputStream + "/" + invokeSvc + "/" + tfmh2 + "/" + string);
        }
        this.mysession = gwatmi2;
        this.protocol = n;
        this.myLocalDomain = string;
        this.output_stream = dataOutputStream;
        this.how_to_do_them = invokeSvc;
        this.myServiceRequest = tfmh2;
        this.beta = betaFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        TypedBuffer typedBuffer;
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TPServiceRequest/execute/");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        dreqid dreqid2 = null;
        int n4 = 0;
        tfmh tfmh2 = this.myServiceRequest;
        if (tfmh2.tdom == null) {
            if (bl) {
                ntrace.doTrace((String)"]/TPServiceRequest/10/Unknown message format");
            }
            return 0;
        }
        TdomTcb tdomTcb = (TdomTcb)tfmh2.tdom.body;
        dreqid2 = new dreqid(tdomTcb.get_reqid());
        int n5 = tdomTcb.get_convid();
        int n6 = tdomTcb.get_flag();
        if ((n6 & 4) != 0) {
            n4 |= 4;
        }
        if (n5 != -1) {
            n4 |= 0x400;
            n4 = (n6 & 0x800) != 0 ? (n4 |= 0x1000) : (n4 |= 0x800);
        }
        if (tfmh2.user == null) {
            typedBuffer = null;
        } else {
            UserTcb userTcb = (UserTcb)tfmh2.user.body;
            typedBuffer = userTcb.user_data;
        }
        if (n == 0) {
            if (this.how_to_do_them != null) {
                InvokeInfo invokeInfo = new InvokeInfo(tdomTcb.get_service(), typedBuffer, n4, tfmh2, (Serializable)dreqid2, this.mysession.getUid(), n5);
                if (this.mySubject != null) {
                    invokeInfo.setTargetSubject(this.mySubject);
                }
                try {
                    if (bl) {
                        ntrace.doTrace((String)("/servicethr/calling invoker/" + (Object)((Object)invokeInfo)));
                    }
                    this.how_to_do_them.invoke(invokeInfo, this.mysession);
                    if (bl) {
                        ntrace.doTrace((String)("/servicethr/invoker success/" + (Object)((Object)invokeInfo)));
                    }
                    n = 0;
                }
                catch (TPException tPException) {
                    if (bl) {
                        ntrace.doTrace((String)("/servicethr/invoker threw TPException " + (Object)((Object)tPException) + "/"));
                    }
                    n = tPException.gettperrno();
                    n3 = tPException.gettpurcode();
                    n2 = tPException.gettperrordetail();
                }
            } else {
                if (bl) {
                    ntrace.doTrace((String)"/servicethr/no invoker/");
                }
                n = 6;
            }
        }
        if (n != 0) {
            if (bl) {
                ntrace.doTrace((String)"/servicethr/sending failure/");
            }
            tfmh tfmh3 = new tfmh(1);
            TdomTcb tdomTcb2 = new TdomTcb(3, dreqid2.reqid, 0, null);
            tdomTcb2.set_errdetail(n2);
            tdomTcb2.set_tpurcode(n3);
            tdomTcb2.set_diagnostic(n);
            tfmh3.tdom = new tcm(7, (tcb)tdomTcb2);
            DataOutputStream dataOutputStream = this.output_stream;
            synchronized (dataOutputStream) {
                block28: {
                    try {
                        if (this.protocol >= 15) {
                            tfmh3.write_tfmh(this.output_stream, this.mysession.getCompressionThreshold());
                        } else {
                            tfmh3.write_dom_65_tfmh(this.output_stream, this.myLocalDomain, this.protocol, this.mysession.getCompressionThreshold());
                        }
                        if (bl) {
                            ntrace.doTrace((String)"/servicethr/failure sent/");
                        }
                    }
                    catch (IOException iOException) {
                        if (!bl) break block28;
                        ntrace.doTrace((String)("/servicethr/Could not send failure/" + iOException));
                    }
                }
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceRequest/20/Success");
        }
        return 0;
    }

    public void setTargetSubject(TCAuthenticatedUser tCAuthenticatedUser) {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TPServiceRequest/setTargetSubject/");
        }
        this.mySubject = tCAuthenticatedUser;
        if (bl) {
            ntrace.doTrace((String)"]/TPServiceRequest/setTargetSubject/10");
        }
    }

    public void setTaskName(String string) {
        this.myName = new String("TPServiceRequest$" + string);
    }

    public String getTaskName() {
        if (this.myName == null) {
            return "TPServiceRequest$unknown";
        }
        return this.myName;
    }
}

